/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import java.util.List;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerFunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

public abstract class TypeReferenceVisitor {
    protected void doVisitTypeReference(LightweightTypeReference reference) {
        throw new UnsupportedOperationException("Missing implementation for " + reference);
    }

    protected void doVisitAnyTypeReference(AnyTypeReference reference) {
        this.doVisitTypeReference(reference);
    }

    protected void doVisitUnknownTypeReference(UnknownTypeReference reference) {
        this.doVisitTypeReference(reference);
    }

    protected void doVisitCompoundTypeReference(CompoundTypeReference reference) {
        List<LightweightTypeReference> components = reference.getMultiTypeComponents();
        if (components.isEmpty()) {
            this.doVisitTypeReference(reference);
        } else {
            for (LightweightTypeReference component : components) {
                component.accept(this);
            }
        }
    }

    protected void doVisitMultiTypeReference(CompoundTypeReference reference) {
        this.doVisitCompoundTypeReference(reference);
    }

    protected void doVisitSynonymTypeReference(CompoundTypeReference reference) {
        this.doVisitCompoundTypeReference(reference);
    }

    protected void doVisitArrayTypeReference(ArrayTypeReference reference) {
        this.doVisitTypeReference(reference);
    }

    protected void doVisitFunctionTypeReference(FunctionTypeReference reference) {
        this.doVisitParameterizedTypeReference(reference);
    }

    protected void doVisitInnerFunctionTypeReference(InnerFunctionTypeReference reference) {
        this.doVisitFunctionTypeReference(reference);
    }

    protected void doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
        this.doVisitTypeReference(reference);
    }

    protected void doVisitInnerTypeReference(InnerTypeReference reference) {
        this.doVisitParameterizedTypeReference(reference);
    }

    protected void doVisitUnboundTypeReference(UnboundTypeReference reference) {
        this.doVisitTypeReference(reference);
    }

    protected void doVisitWildcardTypeReference(WildcardTypeReference reference) {
        this.doVisitTypeReference(reference);
    }
}

