/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.web;

import org.eclipse.xtext.util.Strings;

public class RegexpExtensions {
    public static String toRegexpString(String string, boolean ignoreCase) {
        int length = string.length();
        StringBuilder out = new StringBuilder(2 * length);
        block8: for (int x = 0; x < length; ++x) {
            char c = string.charAt(x);
            switch (c) {
                case '\t': {
                    out.append("\\\\t");
                    continue block8;
                }
                case '\n': {
                    out.append("\\\\n");
                    continue block8;
                }
                case '\r': {
                    out.append("\\\\r");
                    continue block8;
                }
                case '\f': {
                    out.append("\\\\f");
                    continue block8;
                }
                case '\b': {
                    out.append("[\\\\b]");
                    continue block8;
                }
                case '\"': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    out.append("\\\\");
                    out.append(c);
                    continue block8;
                }
                default: {
                    if (ignoreCase && Character.isLetter(c)) {
                        out.append('[');
                        out.append(Character.toLowerCase(c));
                        out.append(Character.toUpperCase(c));
                        out.append(']');
                        continue block8;
                    }
                    if (c < ' ' || c > '~') {
                        out.append("\\\\u");
                        out.append(Strings.toHex((int)(c >> 12 & 0xF)));
                        out.append(Strings.toHex((int)(c >> 8 & 0xF)));
                        out.append(Strings.toHex((int)(c >> 4 & 0xF)));
                        out.append(Strings.toHex((int)(c & 0xF)));
                        continue block8;
                    }
                    out.append(c);
                }
            }
        }
        return out.toString();
    }
}

