/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.jni.win32;

import org.eclipse.fx.drift.internal.ResourceLogger;
import org.eclipse.fx.drift.internal.jni.IMemoryStack;
import org.eclipse.fx.drift.internal.jni.MemoryStack;
import org.eclipse.fx.drift.internal.jni.win32.WindowsError;

public final class Win32 {
    public static final int D3DUSAGE_NONSECURE = 0x800000;
    public static final int D3DUSAGE_DYNAMIC = 512;
    public static final int D3DFMT_A8R8G8B8 = 21;
    public static final int D3DPOOL_DEFAULT = 0;

    private Win32() {
    }

    private static native long nIUnknownAddRef(long var0);

    private static native long nIUnknownRelease(long var0);

    private static native long nIDirect3DDevice9CreateTexture(long var0, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static class IDirect3DTexture9
    extends IDirect3DBaseTexture9 {
        public final HANDLE shareHandle;

        public IDirect3DTexture9(long address, HANDLE shareHandle) {
            super(address);
            this.shareHandle = shareHandle;
        }

        public IDirect3DTexture9(long address) {
            this(address, null);
        }

        @Override
        public long Release() {
            long res = super.Release();
            if (res == 0L) {
                ResourceLogger.resourceDisposed(this.address);
            }
            return res;
        }
    }

    public static class IDirect3DBaseTexture9
    extends IDirect3DResource9 {
        public IDirect3DBaseTexture9(long address) {
            super(address);
        }
    }

    public static class IDirect3DResource9
    extends IUnknown {
        public IDirect3DResource9(long address) {
            super(address);
        }
    }

    public static class IDirect3DDevice9Ex
    extends IDirect3DDevice9 {
        public IDirect3DDevice9Ex(long address) {
            super(address);
        }
    }

    public static class IDirect3DDevice9
    extends IUnknown {
        public IDirect3DDevice9(long address) {
            super(address);
        }

        public IDirect3DTexture9 CreateTexture(int width, int height, int levels, int usage, int format, int pool) throws WindowsError {
            try (IMemoryStack.IScopedMemeoryStack memoryStack = MemoryStack.scoped();){
                MemoryStack.Long texture = memoryStack.allocateLong(0L);
                MemoryStack.Long shareHandle = memoryStack.allocateLong(0L);
                long hresult = Win32.nIDirect3DDevice9CreateTexture(this.address, width, height, levels, usage, format, pool, texture.getAddress(), shareHandle.getAddress());
                WindowsError.checkHResult(hresult);
                ResourceLogger.resourceAllocated(texture.get(), "DXTex", "shareHandle=" + Long.toHexString(shareHandle.get()));
                IDirect3DTexture9 iDirect3DTexture9 = new IDirect3DTexture9(texture.get(), new HANDLE(shareHandle.get()));
                return iDirect3DTexture9;
            }
        }

        public IDirect3DTexture9 CreateTexture(int width, int height, int levels, int usage, int format, int pool, HANDLE shareHandle) throws WindowsError {
            try (IMemoryStack.IScopedMemeoryStack memoryStack = MemoryStack.scoped();){
                MemoryStack.Long texture = memoryStack.allocateLong(0L);
                MemoryStack.Long shareHandlev = memoryStack.allocateLong(shareHandle.address);
                long hresult = Win32.nIDirect3DDevice9CreateTexture(this.address, width, height, levels, usage, format, pool, texture.getAddress(), shareHandlev.getAddress());
                WindowsError.checkHResult(hresult);
                ResourceLogger.resourceAllocated(texture.get(), "DXTex", "shareHandle=" + Long.toHexString(shareHandlev.get()));
                IDirect3DTexture9 iDirect3DTexture9 = new IDirect3DTexture9(texture.get(), new HANDLE(shareHandlev.get()));
                return iDirect3DTexture9;
            }
        }
    }

    public static class IUnknown
    extends Pointer {
        public IUnknown(long address) {
            super(address);
        }

        public long AddRef() {
            return Win32.nIUnknownAddRef(this.address);
        }

        public long Release() {
            return Win32.nIUnknownRelease(this.address);
        }
    }

    public static class HANDLE
    extends Pointer {
        public HANDLE(long address) {
            super(address);
        }
    }

    public static class NativeLong {
        public long value;
    }

    public static class Pointer {
        public final long address;

        public Pointer(long address) {
            this.address = address;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + Long.toHexString(this.address) + "]";
        }
    }

    public static class HRESULT {
        public final long value;

        public HRESULT(long value) {
            this.value = value;
        }

        public boolean isOk() {
            return 0L == this.value;
        }
    }
}

