/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.securitycontext;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;

@Path(value="/Servlet")
public class TestServlet {
    private static void addSecuredInfo(SecurityContext context, StringBuilder sb) {
        Security security = context.isSecure() ? Security.SECURED : Security.UNSECURED;
        sb.append((Object)security).append("|");
    }

    private static void addSchemaInfo(SecurityContext context, StringBuilder sb) {
        String authScheme = context.getAuthenticationScheme();
        Scheme scheme = authScheme == null ? Scheme.NOSCHEME : (authScheme.equalsIgnoreCase(Scheme.BASIC.name()) ? Scheme.BASIC : Scheme.DIGEST);
        sb.append((Object)scheme).append("|");
    }

    private static void addRoleInfo(SecurityContext context, StringBuilder sb) {
        Principal userPrincipal = context.getUserPrincipal();
        String principal = userPrincipal == null ? "" : userPrincipal.getName();
        sb.append(principal).append("|");
    }

    private static void addPrincipalInfo(SecurityContext context, StringBuilder sb) {
        Role role = context.isUserInRole(Role.DIRECTOR.name()) ? Role.DIRECTOR : (context.isUserInRole(Role.OTHERROLE.name()) ? Role.OTHERROLE : Role.NOROLE);
        sb.append((Object)role).append("|");
    }

    @GET
    @Path(value="/Context")
    public Response test(@Context SecurityContext context) {
        StringBuilder sb = new StringBuilder();
        TestServlet.addSecuredInfo(context, sb);
        TestServlet.addPrincipalInfo(context, sb);
        TestServlet.addRoleInfo(context, sb);
        TestServlet.addSchemaInfo(context, sb);
        return Response.ok((Object)sb.toString()).build();
    }

    public static enum Security {
        SECURED,
        UNSECURED;

    }

    public static enum Scheme {
        BASIC,
        DIGEST,
        NOSCHEME;

    }

    public static enum Role {
        DIRECTOR,
        OTHERROLE,
        NOROLE;

    }
}

