/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.net.ServerSocket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public abstract class JaxrsUtil {
    public static final int freePort() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
    }

    public static final String readFromStream(InputStream stream) throws IOException {
        InputStreamReader isr = new InputStreamReader(stream);
        return JaxrsUtil.readFromReader(isr);
    }

    public static final String readFromReader(Reader reader) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        String entity = br.readLine();
        br.close();
        return entity;
    }

    public static final String readFromFile(File file) throws IOException {
        FileReader reader = new FileReader(file);
        return JaxrsUtil.readFromReader(reader);
    }

    public static final <T> String iterableToString(String separator, Iterable<T> collection) {
        if (collection != null) {
            return JaxrsUtil.iterableToString(separator, collection.iterator());
        }
        return "";
    }

    public static final <T> String iterableToString(String separator, Iterator<T> iterator) {
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (item == null) continue;
            String appendable = item.toString();
            sb.append(appendable);
            if (!iterator.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static final <T> String enumerationToString(String separator, Enumeration<T> enumeration) {
        StringBuilder sb = new StringBuilder();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                T item = enumeration.nextElement();
                if (item == null) continue;
                String appendable = item.toString();
                sb.append(appendable);
                if (!enumeration.hasMoreElements()) continue;
                sb.append(separator);
            }
        }
        return sb.toString();
    }

    public static final String iterableToString(String separator, Object ... collection) {
        StringBuilder sb = new StringBuilder();
        if (collection != null) {
            for (int i = 0; i != collection.length; ++i) {
                Object item = collection[i];
                if (item == null) continue;
                String appendable = item.toString();
                sb.append(appendable);
                if (i == collection.length - 1) continue;
                sb.append(separator);
            }
        }
        return sb.toString();
    }

    public static final TimeZone findTimeZoneInDate(String date) {
        char c;
        StringBuilder sb = new StringBuilder();
        StringBuilder dateBuilder = new StringBuilder(date.trim()).reverse();
        int index = 0;
        while ((c = dateBuilder.charAt(index++)) != ' ') {
            sb.append(c);
        }
        TimeZone timezone = TimeZone.getTimeZone(sb.reverse().toString());
        return timezone;
    }

    public static final String mapToString(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        if (map != null) {
            for (Object key : map.keySet()) {
                sb.append("[").append(key).append(" : ");
                Object value = map.get(key);
                sb.append(JaxrsUtil.toString(value)).append("]");
            }
        }
        return sb.toString();
    }

    public static final DateFormat createDateFormat(TimeZone timezone) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        sdf.setTimeZone(timezone);
        return sdf;
    }

    public static String toString(Object object) {
        String to = null;
        to = object == null ? "null" : (Iterable.class.isInstance(object) ? JaxrsUtil.iterableToString(" ", (Iterable)object) : (Enumeration.class.isInstance(object) ? JaxrsUtil.enumerationToString(" ", (Enumeration)object) : (Map.class.isInstance(object) ? JaxrsUtil.mapToString((Map)object) : (Iterator.class.isInstance(object) ? JaxrsUtil.iterableToString(" ", (Iterator)object) : (Array.class.isInstance(object) ? JaxrsUtil.iterableToString(" ", (Object[])object) : (object.getClass().isArray() ? JaxrsUtil.primitiveArrayToString(object) : String.valueOf(object)))))));
        return to;
    }

    public static String primitiveArrayToString(Object array) {
        String to = null;
        if (array == null) {
            to = "null";
        } else if (array.getClass().isArray()) {
            String sarray = array.toString();
            if (sarray.startsWith("[I")) {
                to = Arrays.toString((int[])array);
            } else if (sarray.startsWith("[B")) {
                to = Arrays.toString((byte[])array);
            } else if (sarray.startsWith("[J")) {
                to = Arrays.toString((long[])array);
            } else if (sarray.startsWith("[C")) {
                to = Arrays.toString((char[])array);
            } else if (sarray.startsWith("[S")) {
                to = Arrays.toString((short[])array);
            } else if (sarray.startsWith("[F")) {
                to = Arrays.toString((float[])array);
            } else if (sarray.startsWith("[D")) {
                to = Arrays.toString((double[])array);
            } else if (sarray.startsWith("[Z")) {
                to = Arrays.toString((boolean[])array);
            } else if (sarray.startsWith("[L")) {
                to = Arrays.toString((Object[])array);
            }
        } else {
            to = String.valueOf(array);
        }
        return to;
    }
}

