/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.headers;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.ee.rs.core.headers.HttpHeadersTest;
import ee.jakarta.tck.ws.rs.ee.rs.core.headers.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Variant;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.TimeZone;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = -5727774504018187299L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_core_headers_web/HeadersTest");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/core/headers/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_core_headers_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, HttpHeadersTest.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void cookieTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Cookie: $Version=1; name1=value1; $Domain=" + this._hostname + "; $Path=/jaxrs_ee_core_headers_web");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "cookie"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "getCookie|Cookie Name=name1|Cookie Value=value1|Cookie Path=/jaxrs_ee_core_headers_web|Cookie Domain=|Cookie Version=1");
        this.invoke();
    }

    @Test
    public void acceptLanguageTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept-Language:en-US");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "acl"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Accept-Language|en-US");
        this.invoke();
    }

    @Test
    public void contentLanguageTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        Variant variant = new Variant(MediaType.WILDCARD_TYPE, "en", "US", null);
        Entity entity = Entity.entity((Object)"anything", (Variant)variant);
        this.setRequestContentEntity(entity);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.PUT, ""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, "Content-Language|en-US");
        this.invoke();
    }

    @Test
    public void mediaTypeTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Content-Type:application/xml;charset=utf8");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "mt"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "getMediaType|application/xml|MediaType size=1|Key charset|Value utf8");
        this.invoke();
    }

    @Test
    public void mediaTypeAcceptableTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept:text/*, text/html, text/html;level=1, */*");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "amt"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "getAcceptableMediaTypes|text/*|text/html|text/html|*/*");
        this.invoke();
    }

    @Test
    public void requestHeadersTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept:text/*, text/html, text/html;level=1, */*");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Content-Type:application/xml;charset=utf8");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "headers"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "getRequestHeaders=|Accept:|text/*");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/html|text/html|*/*");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Content-Type:|application/xml");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "charset=utf8");
        this.invoke();
    }

    @Test
    public void containsHeaderStringTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept:text/*, text/html, text/html;level=1, */*");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Content-Type:application/xml;charset=utf8");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Header3:value1 ;; Value2 ;;value 3");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "contains-headers"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Test1");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Test2");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Test3");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Test4");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Test5");
        this.invoke();
    }

    @Test
    public void getDateTest() throws JAXRSCommonClient.Fault {
        long currentTime = System.currentTimeMillis();
        DateFormat format = JaxrsUtil.createDateFormat(TimeZone.getTimeZone("GMT"));
        String gmt = format.format(currentTime);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "date"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "getDate");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Date:" + gmt);
        this.invoke();
        long responseTime = Long.parseLong(this.getResponseBody());
        boolean check = Math.abs(currentTime - responseTime) < 1001L;
        Assertions.assertTrue((boolean)check, (String)("HttpHeaders.getDate()=" + responseTime + "differs from expected" + currentTime + "by more than 1000 ms."));
        JAXRSClientIT.logMsg("#getDate() returned expected Date instance");
    }

    @Test
    public void getHeaderStringTest() throws JAXRSCommonClient.Fault {
        String[] headers;
        for (String header : headers = new String[]{"askdjb", "ksadbva", "klwiaslkfn", "klwvasbk"}) {
            this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "headerstring"));
            this.setProperty(JAXRSCommonClient.Property.CONTENT, header);
            this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, header + ":" + header + header);
            this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, header + header);
            this.invoke();
        }
        JAXRSClientIT.logMsg("#getHeaderString() returned expected header values");
    }

    @Test
    public void getHeaderStringUsesToStringTest() throws JAXRSCommonClient.Fault {
        final StringBean bean = new StringBean("bean");
        ClientRequestFilter filter = new ClientRequestFilter(){

            public void filter(ClientRequestContext ctx) throws IOException {
                ctx.getHeaders().add((Object)bean.get(), (Object)bean);
            }
        };
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "headerstring"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, bean.get());
        this.addProvider(filter);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, bean.toString());
        this.invoke();
        JAXRSClientIT.logMsg("#getHeaderString() returned expected header converted by toString() method");
    }

    @Test
    public void getLengthTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "length"));
        this.invoke();
        String body = this.getResponseBody();
        Assertions.assertTrue((body != null && body.length() > 0 ? 1 : 0) != 0, (String)"Nothing returned");
        long length = Long.parseLong(body);
        Assertions.assertTrue((length != 0L ? 1 : 0) != 0, (String)"Nothing returned");
        JAXRSClientIT.logMsg("#getLength() returned expected length", body);
    }
}

