/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.notfoundexception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -7425306771761061203L;
    private static final Response.Status STATUS = Response.Status.NOT_FOUND;
    protected static final String MESSAGE = "TCK NotFoundException description";
    protected static final String HOST = "www.jcp.org";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorTest() throws JAXRSCommonClient.Fault {
        NotFoundException e = new NotFoundException();
        this.assertResponse((WebApplicationException)e);
    }

    @Test
    public void constructorResponseTest() throws JAXRSCommonClient.Fault {
        NotFoundException e = new NotFoundException(this.buildResponse(STATUS));
        this.assertResponse((WebApplicationException)e, HOST);
    }

    @Test
    public void constructorResponseThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                NotFoundException e = new NotFoundException(this.buildResponse(status));
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NotFoundException e = new NotFoundException(t);
            this.assertResponse((WebApplicationException)e);
            this.assertCause((WebApplicationException)e, t);
        }
    }

    @Test
    public void constructorResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NotFoundException e = new NotFoundException(this.buildResponse(STATUS), t);
            this.assertResponse((WebApplicationException)e, HOST);
            this.assertCause((WebApplicationException)e, t);
        }
    }

    @Test
    public void constructorResponseThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                NotFoundException e = new NotFoundException(this.buildResponse(status), new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringTest() throws JAXRSCommonClient.Fault {
        NotFoundException e = new NotFoundException(MESSAGE);
        this.assertResponse((WebApplicationException)e);
        this.assertMessage((WebApplicationException)e);
    }

    @Test
    public void constructorStringResponseTest() throws JAXRSCommonClient.Fault {
        NotFoundException e = new NotFoundException(MESSAGE, this.buildResponse(STATUS));
        this.assertResponse((WebApplicationException)e, HOST);
        this.assertMessage((WebApplicationException)e);
    }

    @Test
    public void constructorStringResponseThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                NotFoundException e = new NotFoundException(MESSAGE, this.buildResponse(status));
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NotFoundException e = new NotFoundException(MESSAGE, t);
            this.assertResponse((WebApplicationException)e);
            this.assertCause((WebApplicationException)e, t);
            this.assertMessage((WebApplicationException)e);
        }
    }

    @Test
    public void constructorStringResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NotFoundException e = new NotFoundException(MESSAGE, this.buildResponse(STATUS), t);
            this.assertResponse((WebApplicationException)e, HOST);
            this.assertCause((WebApplicationException)e, t);
            this.assertMessage((WebApplicationException)e);
        }
    }

    @Test
    public void constructorStringResponseThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                NotFoundException e = new NotFoundException(MESSAGE, this.buildResponse(status), new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    protected Response buildResponse(Response.Status status) {
        return Response.status((Response.Status)status).header("Host", (Object)HOST).build();
    }

    protected void assertResponse(WebApplicationException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getResponse(), "#getResponse is null");
        Response response = e.getResponse();
        JAXRSClientIT.assertEqualsInt(response.getStatus(), STATUS.getStatusCode(), "response contains unexpected status", response.getStatus());
        JAXRSClientIT.logMsg("response contains expected", STATUS, "status");
    }

    protected void assertResponse(WebApplicationException e, String host) throws JAXRSCommonClient.Fault {
        this.assertResponse(e);
        String header = e.getResponse().getHeaderString("Host");
        JAXRSClientIT.assertNotNull(header, "http header", "Host", " of response is null");
        JAXRSClientIT.assertEquals(host, header, "Found unexpected http", "Host", "header", header);
        JAXRSClientIT.logMsg("Found expected http", "Host", "header");
    }

    protected void assertCause(WebApplicationException e, Throwable expected) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEquals(e.getCause(), expected, "#getCause does not contain expected", expected, "but", e.getCause());
        JAXRSClientIT.logMsg("getCause contains expected", expected);
    }

    protected void assertMessage(WebApplicationException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getMessage(), "getMessage() is null");
        JAXRSClientIT.assertContains(e.getMessage(), MESSAGE, new Object[]{"Unexpected getMessage()", e.getMessage()});
        JAXRSClientIT.logMsg("found expected getMessage()=", e.getMessage());
    }
}

