/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.URLSearchParams;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMParser;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.ProgressEvent;
import com.gargoylesoftware.htmlunit.javascript.host.file.Blob;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.xml.FormData;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLHttpRequestEventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLHttpRequestUpload;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLSerializer;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.WebResponseWrapper;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import net.sourceforge.htmlunit.corejs.javascript.json.JsonParser;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBufferView;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;

@JsxClass
public class XMLHttpRequest
extends XMLHttpRequestEventTarget {
    private static final Log LOG = LogFactory.getLog(XMLHttpRequest.class);
    @JsxConstant
    public static final int UNSENT = 0;
    @JsxConstant
    public static final int OPENED = 1;
    @JsxConstant
    public static final int HEADERS_RECEIVED = 2;
    @JsxConstant
    public static final int LOADING = 3;
    @JsxConstant
    public static final int DONE = 4;
    private static final String RESPONSE_TYPE_DEFAULT = "";
    private static final String RESPONSE_TYPE_ARRAYBUFFER = "arraybuffer";
    private static final String RESPONSE_TYPE_BLOB = "blob";
    private static final String RESPONSE_TYPE_DOCUMENT = "document";
    private static final String RESPONSE_TYPE_JSON = "json";
    private static final String RESPONSE_TYPE_TEXT = "text";
    private static final String ALLOW_ORIGIN_ALL = "*";
    private static final String[] ALL_PROPERTIES_ = new String[]{"onreadystatechange", "readyState", "responseText", "responseXML", "status", "statusText", "abort", "getAllResponseHeaders", "getResponseHeader", "open", "send", "setRequestHeader"};
    private static final HashSet<String> PROHIBITED_HEADERS_ = new HashSet<String>(Arrays.asList("accept-charset", "accept-encoding", "connection", "content-length", "cookie", "cookie2", "content-transfer-encoding", "date", "expect", "host", "keep-alive", "referer", "te", "trailer", "transfer-encoding", "upgrade", "user-agent", "via"));
    private int state_;
    private WebRequest webRequest_;
    private boolean async_;
    private int jobID_;
    private WebResponse webResponse_;
    private String overriddenMimeType_;
    private final boolean caseSensitiveProperties_;
    private boolean withCredentials_;
    private boolean isSameOrigin_;
    private int timeout_;
    private boolean aborted_;
    private String responseType_;

    @JsxConstructor
    public XMLHttpRequest() {
        this(true);
    }

    public XMLHttpRequest(boolean caseSensitiveProperties) {
        this.caseSensitiveProperties_ = caseSensitiveProperties;
        this.state_ = 0;
        this.responseType_ = RESPONSE_TYPE_DEFAULT;
    }

    private void setState(int state) {
        if (state == 0 || state == 1 || state == 2 || state == 3 || state == 4) {
            this.state_ = state;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("State changed to : " + state));
            }
            return;
        }
        LOG.error((Object)("Received an unknown state " + state + ", the state is not implemented, please check setState() implementation."));
    }

    private void fireJavascriptEvent(String eventName) {
        if (this.aborted_) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Firing javascript XHR event: " + eventName + " for an already aborted request - ignored."));
            }
            return;
        }
        this.fireJavascriptEventIgnoreAbort(eventName);
    }

    private void fireJavascriptEventIgnoreAbort(String eventName) {
        Event event;
        boolean isReadyStateChange;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Firing javascript XHR event: " + eventName));
        }
        if (isReadyStateChange = "readystatechange".equalsIgnoreCase(eventName)) {
            event = new Event(this, "readystatechange");
        } else {
            ProgressEvent progressEvent = new ProgressEvent(this, eventName);
            boolean lengthComputable = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_LENGTH_COMPUTABLE);
            if (lengthComputable) {
                progressEvent.setLengthComputable(true);
            }
            if (this.webResponse_ != null) {
                long contentLength = this.webResponse_.getContentLength();
                progressEvent.setLoaded(contentLength);
                if (lengthComputable) {
                    progressEvent.setTotal(contentLength);
                }
            }
            event = progressEvent;
        }
        this.executeEventLocally(event);
    }

    @JsxGetter
    public int getReadyState() {
        return this.state_;
    }

    @JsxGetter
    public String getResponseType() {
        return this.responseType_;
    }

    @JsxSetter
    public void setResponseType(String responseType) {
        if (this.state_ == 3 || this.state_ == 4) {
            throw Context.reportRuntimeError((String)"InvalidStateError");
        }
        if (this.state_ == 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_RESPONSE_TYPE_THROWS_UNSENT)) {
            throw Context.reportRuntimeError((String)"InvalidStateError");
        }
        if (RESPONSE_TYPE_DEFAULT.equals(responseType) || RESPONSE_TYPE_ARRAYBUFFER.equals(responseType) || RESPONSE_TYPE_BLOB.equals(responseType) || RESPONSE_TYPE_DOCUMENT.equals(responseType) || RESPONSE_TYPE_JSON.equals(responseType) && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_RESPONSE_TYPE_THROWS_UNSENT) || RESPONSE_TYPE_TEXT.equals(responseType)) {
            if (this.state_ == 1 && !this.async_ && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_RESPONSE_TYPE_THROWS_UNSENT)) {
                throw Context.reportRuntimeError((String)"InvalidAccessError: synchronous XMLHttpRequests do not support responseType");
            }
            this.responseType_ = responseType;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JsxGetter
    public Object getResponse() {
        if (RESPONSE_TYPE_DEFAULT.equals(this.responseType_)) return this.getResponseText();
        if (RESPONSE_TYPE_TEXT.equals(this.responseType_)) {
            return this.getResponseText();
        }
        if (this.state_ != 4) {
            return null;
        }
        if (this.webResponse_ instanceof NetworkErrorWebResponse) {
            if (!LOG.isDebugEnabled()) return null;
            LOG.debug((Object)("XMLHttpRequest.responseXML returns of a network error (" + ((NetworkErrorWebResponse)this.webResponse_).getError() + ")"));
            return null;
        }
        if (RESPONSE_TYPE_ARRAYBUFFER.equals(this.responseType_)) {
            long contentLength = this.webResponse_.getContentLength();
            NativeArrayBuffer nativeArrayBuffer = new NativeArrayBuffer((double)contentLength);
            try {
                int bufferLength = Math.min(1024, (int)contentLength);
                byte[] buffer = new byte[bufferLength];
                int offset = 0;
                try (InputStream inputStream2 = this.webResponse_.getContentAsStream();){
                    int readLen;
                    while ((readLen = inputStream2.read(buffer, 0, bufferLength)) != -1) {
                        long newLength = offset + readLen;
                        if (newLength > contentLength) {
                            NativeArrayBuffer expanded = new NativeArrayBuffer((double)newLength);
                            System.arraycopy(nativeArrayBuffer.getBuffer(), 0, expanded.getBuffer(), 0, (int)contentLength);
                            contentLength = newLength;
                            nativeArrayBuffer = expanded;
                        }
                        System.arraycopy(buffer, 0, nativeArrayBuffer.getBuffer(), offset, readLen);
                        offset = (int)newLength;
                    }
                }
                if ((long)offset < contentLength) {
                    NativeArrayBuffer shrinked = new NativeArrayBuffer((double)offset);
                    System.arraycopy(nativeArrayBuffer.getBuffer(), 0, shrinked.getBuffer(), 0, offset);
                    nativeArrayBuffer = shrinked;
                }
                nativeArrayBuffer.setParentScope(this.getParentScope());
                nativeArrayBuffer.setPrototype(ScriptableObject.getClassPrototype((Scriptable)this.getWindow(), (String)nativeArrayBuffer.getClassName()));
                return nativeArrayBuffer;
            }
            catch (IOException e) {
                this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, e);
                return null;
            }
        }
        if (RESPONSE_TYPE_BLOB.equals(this.responseType_)) {
            try {
                if (this.webResponse_ == null) return RESPONSE_TYPE_DEFAULT;
                try (InputStream inputStream = this.webResponse_.getContentAsStream();){
                    Blob blob2 = new Blob(IOUtils.toByteArray((InputStream)inputStream), this.webResponse_.getContentType());
                    blob2.setParentScope(this.getParentScope());
                    blob2.setPrototype(ScriptableObject.getClassPrototype((Scriptable)this.getWindow(), (String)blob2.getClassName()));
                    Blob blob = blob2;
                    return blob;
                }
            }
            catch (IOException e) {
                this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, e);
                return null;
            }
        }
        if (RESPONSE_TYPE_DOCUMENT.equals(this.responseType_)) {
            if (this.webResponse_ == null) return RESPONSE_TYPE_DEFAULT;
            try {
                Charset encoding = this.webResponse_.getContentCharset();
                if (encoding == null) {
                    return RESPONSE_TYPE_DEFAULT;
                }
                String content = this.webResponse_.getContentAsString(encoding);
                if (content != null) return DOMParser.parseFromString(this, content, this.webResponse_.getContentType());
                return RESPONSE_TYPE_DEFAULT;
            }
            catch (IOException e) {
                this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, e);
                return null;
            }
        }
        if (!RESPONSE_TYPE_JSON.equals(this.responseType_)) return RESPONSE_TYPE_DEFAULT;
        if (this.webResponse_ == null) return RESPONSE_TYPE_DEFAULT;
        Charset encoding = this.webResponse_.getContentCharset();
        if (encoding == null) {
            return null;
        }
        String content = this.webResponse_.getContentAsString(encoding);
        if (content == null) {
            return null;
        }
        try {
            return new JsonParser(Context.getCurrentContext(), (Scriptable)this).parseValue(content);
        }
        catch (JsonParser.ParseException e) {
            this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, new IOException(e));
            return null;
        }
    }

    @JsxGetter
    public String getResponseText() {
        if ((this.state_ == 0 || this.state_ == 1) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_RESPONSE_TEXT_EMPTY_UNSENT)) {
            return RESPONSE_TYPE_DEFAULT;
        }
        if (!RESPONSE_TYPE_DEFAULT.equals(this.responseType_) && !RESPONSE_TYPE_TEXT.equals(this.responseType_)) {
            throw Context.reportRuntimeError((String)("InvalidStateError: Failed to read the 'responseText' property from 'XMLHttpRequest': The value is only accessible if the object's 'responseType' is '' or 'text' (was '" + this.getResponseType() + "')."));
        }
        if (this.state_ == 0 || this.state_ == 1) {
            return RESPONSE_TYPE_DEFAULT;
        }
        if (this.webResponse_ instanceof NetworkErrorWebResponse) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("XMLHttpRequest.responseXML returns of a network error (" + ((NetworkErrorWebResponse)this.webResponse_).getError() + ")"));
            }
            return null;
        }
        if (this.webResponse_ != null) {
            Charset encoding = this.webResponse_.getContentCharset();
            if (encoding == null) {
                return RESPONSE_TYPE_DEFAULT;
            }
            String content = this.webResponse_.getContentAsString(encoding);
            if (content == null) {
                return RESPONSE_TYPE_DEFAULT;
            }
            return content;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"XMLHttpRequest.responseText was retrieved before the response was available.");
        }
        return RESPONSE_TYPE_DEFAULT;
    }

    @JsxGetter
    public Object getResponseXML() {
        if (this.webResponse_ == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"XMLHttpRequest.responseXML returns null because there in no web resonse so far (has send() been called?)");
            }
            return null;
        }
        if (this.webResponse_ instanceof NetworkErrorWebResponse) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("XMLHttpRequest.responseXML returns of a network error (" + ((NetworkErrorWebResponse)this.webResponse_).getError() + ")"));
            }
            return null;
        }
        String contentType = this.webResponse_.getContentType();
        if (contentType.isEmpty() || contentType.contains("xml")) {
            Window w = this.getWindow();
            try {
                XmlPage page = new XmlPage(this.webResponse_, w.getWebWindow());
                XMLDocument document = new XMLDocument();
                document.setPrototype(this.getPrototype(document.getClass()));
                document.setParentScope((Scriptable)w);
                document.setDomNode(page);
                return document;
            }
            catch (IOException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Failed parsing XML document " + this.webResponse_.getWebRequest().getUrl() + ": " + e.getMessage()));
                }
                return null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("XMLHttpRequest.responseXML was called but the response is " + this.webResponse_.getContentType()));
        }
        return null;
    }

    @JsxGetter
    public int getStatus() {
        if (this.state_ == 0 || this.state_ == 1) {
            return 0;
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusCode();
        }
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("XMLHttpRequest.status was retrieved without a response available (readyState: " + this.state_ + ")."));
        }
        return 0;
    }

    @JsxGetter
    public String getStatusText() {
        if (this.state_ == 0 || this.state_ == 1) {
            return RESPONSE_TYPE_DEFAULT;
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusMessage();
        }
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("XMLHttpRequest.statusText was retrieved without a response available (readyState: " + this.state_ + ")."));
        }
        return null;
    }

    @JsxFunction
    public void abort() {
        this.getWindow().getWebWindow().getJobManager().stopJob(this.jobID_);
        if (this.state_ == 1 || this.state_ == 2 || this.state_ == 3) {
            this.setState(4);
            this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, null);
            this.fireJavascriptEvent("readystatechange");
            this.fireJavascriptEvent("abort");
            this.fireJavascriptEvent("loadend");
        }
        this.setState(0);
        this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, null);
        this.aborted_ = true;
    }

    @JsxFunction
    public String getAllResponseHeaders() {
        if (this.state_ == 0 || this.state_ == 1) {
            return RESPONSE_TYPE_DEFAULT;
        }
        if (this.webResponse_ != null) {
            StringBuilder builder = new StringBuilder();
            for (NameValuePair header : this.webResponse_.getResponseHeaders()) {
                builder.append(header.getName()).append(": ").append(header.getValue());
                if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_ALL_RESPONSE_HEADERS_SEPARATE_BY_LF)) {
                    builder.append('\r');
                }
                builder.append('\n');
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_ALL_RESPONSE_HEADERS_APPEND_SEPARATOR)) {
                if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_ALL_RESPONSE_HEADERS_SEPARATE_BY_LF)) {
                    builder.append('\r');
                }
                builder.append('\n');
            }
            return builder.toString();
        }
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("XMLHttpRequest.getAllResponseHeaders() was called without a response available (readyState: " + this.state_ + ")."));
        }
        return null;
    }

    @JsxFunction
    public String getResponseHeader(String headerName) {
        if (this.state_ == 0 || this.state_ == 1) {
            return null;
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getResponseHeaderValue(headerName);
        }
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("XMLHttpRequest.getAllResponseHeaders(..) was called without a response available (readyState: " + this.state_ + ")."));
        }
        return null;
    }

    @JsxFunction
    public void open(String method, Object urlParam, Object asyncParam, Object user, Object password) {
        if ((urlParam == null || RESPONSE_TYPE_DEFAULT.equals(urlParam)) && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_OPEN_ALLOW_EMTPY_URL)) {
            throw Context.reportRuntimeError((String)"URL for XHR.open can't be empty!");
        }
        boolean async = true;
        if (!Undefined.isUndefined((Object)asyncParam)) {
            async = ScriptRuntime.toBoolean((Object)asyncParam);
        }
        String url = Context.toString((Object)urlParam);
        HtmlPage containingPage = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        try {
            boolean alwaysAddOrigin;
            URL fullUrl = containingPage.getFullyQualifiedUrl(url);
            if (!this.isAllowCrossDomainsFor(fullUrl)) {
                throw Context.reportRuntimeError((String)"Access to restricted URI denied");
            }
            WebRequest request = new WebRequest(fullUrl, this.getBrowserVersion().getXmlHttpRequestAcceptHeader(), this.getBrowserVersion().getAcceptEncodingHeader());
            request.setCharset(StandardCharsets.UTF_8);
            request.setRefererlHeader(containingPage.getUrl());
            try {
                request.setHttpMethod(HttpMethod.valueOf(method.toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Incorrect HTTP Method '" + method + "'"));
                }
                return;
            }
            URL pageRequestUrl = containingPage.getUrl();
            this.isSameOrigin_ = XMLHttpRequest.isSameOrigin(pageRequestUrl, fullUrl);
            boolean bl = alwaysAddOrigin = !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_NO_CROSS_ORIGIN_TO_ABOUT) && HttpMethod.GET != request.getHttpMethod() && HttpMethod.PATCH != request.getHttpMethod() && HttpMethod.HEAD != request.getHttpMethod();
            if (alwaysAddOrigin || !this.isSameOrigin_) {
                StringBuilder origin = new StringBuilder().append(pageRequestUrl.getProtocol()).append("://").append(pageRequestUrl.getHost());
                if (pageRequestUrl.getPort() != -1) {
                    origin.append(':').append(pageRequestUrl.getPort());
                }
                request.setAdditionalHeader("Origin", origin.toString());
            }
            if (user != null && !Undefined.isUndefined((Object)user)) {
                String userCred = user.toString();
                String passwordCred = RESPONSE_TYPE_DEFAULT;
                if (password != null && !Undefined.isUndefined((Object)password)) {
                    passwordCred = password.toString();
                }
                request.setCredentials((Credentials)new UsernamePasswordCredentials(userCred, passwordCred));
            }
            this.webRequest_ = request;
        }
        catch (MalformedURLException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Unable to initialize XMLHttpRequest using malformed URL '" + url + "'."));
            }
            return;
        }
        this.async_ = async;
        this.setState(1);
        this.fireJavascriptEvent("readystatechange");
    }

    private boolean isAllowCrossDomainsFor(URL newUrl) {
        return !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_NO_CROSS_ORIGIN_TO_ABOUT) || !"about".equals(newUrl.getProtocol());
    }

    private static boolean isSameOrigin(URL originUrl, URL newUrl) {
        int newPort;
        if (!originUrl.getHost().equals(newUrl.getHost())) {
            return false;
        }
        int originPort = originUrl.getPort();
        if (originPort == -1) {
            originPort = originUrl.getDefaultPort();
        }
        if ((newPort = newUrl.getPort()) == -1) {
            newPort = newUrl.getDefaultPort();
        }
        return originPort == newPort;
    }

    @JsxFunction
    public void send(Object content) {
        HtmlPage page;
        Window w;
        WebWindow ww;
        WebClient client;
        AjaxController ajaxController;
        boolean synchron;
        if (this.webRequest_ == null) {
            return;
        }
        if (!this.async_ && this.timeout_ > 0) {
            Context.throwAsScriptRuntimeEx((Throwable)new RuntimeException("Synchronous requests must not set a timeout."));
            return;
        }
        this.prepareRequestContent(content);
        if (this.timeout_ > 0) {
            this.webRequest_.setTimeout(this.timeout_);
        }
        if (synchron = (ajaxController = (client = (ww = (w = this.getWindow()).getWebWindow()).getWebClient()).getAjaxController()).processSynchron(page = (HtmlPage)ww.getEnclosedPage(), this.webRequest_, this.async_)) {
            this.doSend();
        } else {
            HtmlUnitContextFactory cf = ((JavaScriptEngine)client.getJavaScriptEngine()).getContextFactory();
            ContextAction<Object> action = new ContextAction<Object>(){

                public Object run(Context cx) {
                    ArrayDeque<Window> stack = (ArrayDeque<Window>)cx.getThreadLocal((Object)"startingScope");
                    if (null == stack) {
                        stack = new ArrayDeque<Window>();
                        cx.putThreadLocal((Object)"startingScope", stack);
                    }
                    stack.push(w);
                    try {
                        XMLHttpRequest.this.doSend();
                    }
                    finally {
                        stack.pop();
                    }
                    return null;
                }

                public String toString() {
                    return "XMLHttpRequest " + (Object)((Object)XMLHttpRequest.this.webRequest_.getHttpMethod()) + " '" + XMLHttpRequest.this.webRequest_.getUrl() + "'";
                }
            };
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavascriptXMLHttpRequestJob(cf, action);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Starting XMLHttpRequest thread for asynchronous request");
            }
            this.jobID_ = ww.getJobManager().addJob(job, page);
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_FIRE_STATE_OPENED_AGAIN_IN_ASYNC_MODE)) {
                this.fireJavascriptEvent("readystatechange");
            }
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_LOAD_START_ASYNC)) {
                this.fireJavascriptEvent("loadstart");
            }
        }
    }

    private void prepareRequestContent(Object content) {
        if (!(content == null || HttpMethod.POST != this.webRequest_.getHttpMethod() && HttpMethod.PUT != this.webRequest_.getHttpMethod() && HttpMethod.PATCH != this.webRequest_.getHttpMethod() || Undefined.isUndefined((Object)content))) {
            boolean setEncodingType;
            boolean bl = setEncodingType = this.webRequest_.getAdditionalHeader("Content-Type") == null;
            if (content instanceof HTMLDocument) {
                String body = new XMLSerializer().serializeToString((HTMLDocument)content);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Setting request body to: " + body));
                }
                this.webRequest_.setRequestBody(body);
                if (setEncodingType) {
                    this.webRequest_.setAdditionalHeader("Content-Type", "text/html;charset=UTF-8");
                }
            } else if (content instanceof XMLDocument) {
                try (StringWriter writer = new StringWriter();){
                    XMLDocument xmlDocument = (XMLDocument)content;
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.setOutputProperty("indent", "no");
                    transformer.transform(new DOMSource(xmlDocument.getDomNodeOrDie().getFirstChild()), new StreamResult(writer));
                    String body = writer.toString();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Setting request body to: " + body));
                    }
                    this.webRequest_.setRequestBody(body);
                    if (setEncodingType) {
                        this.webRequest_.setAdditionalHeader("Content-Type", "application/xml;charset=UTF-8");
                    }
                }
                catch (Exception e) {
                    Context.throwAsScriptRuntimeEx((Throwable)e);
                }
            } else if (content instanceof FormData) {
                ((FormData)content).fillRequest(this.webRequest_);
            } else if (content instanceof NativeArrayBufferView) {
                NativeArrayBufferView view = (NativeArrayBufferView)content;
                this.webRequest_.setRequestBody(new String(view.getBuffer().getBuffer(), StandardCharsets.UTF_8));
                if (setEncodingType) {
                    this.webRequest_.setEncodingType(null);
                }
            } else if (content instanceof URLSearchParams) {
                ((URLSearchParams)content).fillRequest(this.webRequest_);
                this.webRequest_.addHint(WebRequest.HttpHint.IncludeCharsetInContentTypeHeader);
            } else if (content instanceof Blob) {
                ((Blob)content).fillRequest(this.webRequest_);
            } else {
                String body = Context.toString((Object)content);
                if (!body.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Setting request body to: " + body));
                    }
                    this.webRequest_.setRequestBody(body);
                    this.webRequest_.setCharset(StandardCharsets.UTF_8);
                    if (setEncodingType) {
                        this.webRequest_.setEncodingType(FormEncodingType.TEXT_PLAIN);
                    }
                }
            }
        }
    }

    void doSend() {
        final BrowserVersion browserVersion = this.getBrowserVersion();
        if (this.async_ && browserVersion.hasFeature(BrowserVersionFeatures.XHR_LOAD_START_ASYNC)) {
            this.fireJavascriptEvent("loadstart");
        }
        WebClient wc = this.getWindow().getWebWindow().getWebClient();
        boolean preflighted = false;
        try {
            if (!this.isSameOrigin_ && this.isPreflight()) {
                WebResponse preflightResponse;
                preflighted = true;
                WebRequest preflightRequest = new WebRequest(this.webRequest_.getUrl(), HttpMethod.OPTIONS);
                String originHeaderValue = this.webRequest_.getAdditionalHeaders().get("Origin");
                preflightRequest.setAdditionalHeader("Origin", originHeaderValue);
                preflightRequest.setAdditionalHeader("Access-Control-Request-Method", this.webRequest_.getHttpMethod().name());
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<String, String> header : new TreeMap<String, String>(this.webRequest_.getAdditionalHeaders()).entrySet()) {
                    String name = header.getKey().toLowerCase(Locale.ROOT);
                    if (!XMLHttpRequest.isPreflightHeader(name, header.getValue())) continue;
                    if (builder.length() != 0) {
                        builder.append(',');
                    }
                    builder.append(name);
                }
                preflightRequest.setAdditionalHeader("Access-Control-Request-Headers", builder.toString());
                if (this.timeout_ > 0) {
                    preflightRequest.setTimeout(this.timeout_);
                }
                if (!(preflightResponse = wc.loadWebResponse(preflightRequest)).isSuccessOrUseProxyOrNotModified() || !this.isPreflightAuthorized(preflightResponse)) {
                    this.setState(4);
                    if (this.async_ || browserVersion.hasFeature(BrowserVersionFeatures.XHR_HANDLE_SYNC_NETWORK_ERRORS)) {
                        this.fireJavascriptEvent("readystatechange");
                        this.fireJavascriptEvent("error");
                        this.fireJavascriptEvent("loadend");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("No permitted request for URL " + this.webRequest_.getUrl()));
                    }
                    Context.throwAsScriptRuntimeEx((Throwable)new RuntimeException("No permitted \"Access-Control-Allow-Origin\" header."));
                    return;
                }
            }
            this.webResponse_ = wc.loadWebResponse(this.webRequest_);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Web response loaded successfully.");
            }
            this.webResponse_.defaultCharsetUtf8();
            boolean allowOriginResponse = true;
            if (!this.isSameOrigin_) {
                String value = this.webResponse_.getResponseHeaderValue("Access-Control-Allow-Origin");
                allowOriginResponse = this.webRequest_.getAdditionalHeaders().get("Origin").equals(value);
                if (this.isWithCredentials()) {
                    value = this.webResponse_.getResponseHeaderValue("Access-Control-Allow-Credentials");
                    allowOriginResponse = allowOriginResponse && Boolean.parseBoolean(value);
                } else {
                    boolean bl = allowOriginResponse = allowOriginResponse || ALLOW_ORIGIN_ALL.equals(value);
                }
            }
            if (allowOriginResponse && this.overriddenMimeType_ != null) {
                int index = this.overriddenMimeType_.toLowerCase(Locale.ROOT).indexOf("charset=");
                String charsetName = RESPONSE_TYPE_DEFAULT;
                if (index != -1) {
                    charsetName = this.overriddenMimeType_.substring(index + "charset=".length());
                }
                final Charset charset = EncodingSniffer.toCharset(charsetName);
                final String charsetNameFinal = charsetName;
                this.webResponse_ = new WebResponseWrapper(this.webResponse_){

                    @Override
                    public String getContentType() {
                        return XMLHttpRequest.this.overriddenMimeType_;
                    }

                    @Override
                    public Charset getContentCharset() {
                        if (charsetNameFinal.isEmpty() || charset == null && browserVersion.hasFeature(BrowserVersionFeatures.XHR_USE_CONTENT_CHARSET)) {
                            return super.getContentCharset();
                        }
                        return charset;
                    }
                };
            }
            if (!allowOriginResponse) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No permitted \"Access-Control-Allow-Origin\" header for URL " + this.webRequest_.getUrl()));
                }
                throw new IOException("No permitted \"Access-Control-Allow-Origin\" header.");
            }
            this.setState(2);
            if (this.async_) {
                this.fireJavascriptEvent("readystatechange");
            }
            if (this.async_) {
                this.setState(3);
                this.fireJavascriptEvent("readystatechange");
                this.fireJavascriptEvent("progress");
            }
            this.setState(4);
            this.fireJavascriptEvent("readystatechange");
            if (!this.async_ && this.aborted_ && browserVersion.hasFeature(BrowserVersionFeatures.XHR_SEND_NETWORK_ERROR_IF_ABORTED)) {
                throw ScriptRuntime.constructError((String)"Error", (String)("Failed to execute 'send' on 'XMLHttpRequest': Failed to load '" + this.webRequest_.getUrl() + "'"));
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.XHR_LOAD_ALWAYS_AFTER_DONE)) {
                this.fireJavascriptEventIgnoreAbort("load");
                this.fireJavascriptEventIgnoreAbort("loadend");
            } else {
                this.fireJavascriptEvent("load");
                this.fireJavascriptEvent("loadend");
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"IOException: returning a network error response.", (Throwable)e);
            }
            if (this.async_) {
                if (e instanceof SocketTimeoutException && browserVersion.hasFeature(BrowserVersionFeatures.XHR_LOAD_START_ASYNC)) {
                    try {
                        this.webResponse_ = wc.loadWebResponse(WebRequest.newAboutBlankRequest());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.setState(2);
                    this.fireJavascriptEvent("readystatechange");
                }
                if (!preflighted && e instanceof NoHttpResponseException && browserVersion.hasFeature(BrowserVersionFeatures.XHR_PROGRESS_ON_NETWORK_ERROR_ASYNC)) {
                    this.fireJavascriptEvent("progress");
                }
            }
            this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, e);
            if (this.async_) {
                this.setState(4);
                this.fireJavascriptEvent("readystatechange");
                if (e instanceof SocketTimeoutException) {
                    this.fireJavascriptEvent("timeout");
                } else {
                    this.fireJavascriptEvent("error");
                }
                this.fireJavascriptEvent("loadend");
            }
            this.setState(4);
            if (browserVersion.hasFeature(BrowserVersionFeatures.XHR_HANDLE_SYNC_NETWORK_ERRORS)) {
                this.fireJavascriptEvent("readystatechange");
                if (e instanceof SocketTimeoutException) {
                    this.fireJavascriptEvent("timeout");
                } else {
                    this.fireJavascriptEvent("error");
                }
                this.fireJavascriptEvent("loadend");
            }
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    private boolean isPreflight() {
        HttpMethod method = this.webRequest_.getHttpMethod();
        if (method != HttpMethod.GET && method != HttpMethod.HEAD && method != HttpMethod.POST) {
            return true;
        }
        for (Map.Entry<String, String> header : this.webRequest_.getAdditionalHeaders().entrySet()) {
            if (!XMLHttpRequest.isPreflightHeader(header.getKey().toLowerCase(Locale.ROOT), header.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean isPreflightAuthorized(WebResponse preflightResponse) {
        String originHeader = preflightResponse.getResponseHeaderValue("Access-Control-Allow-Origin");
        if (!ALLOW_ORIGIN_ALL.equals(originHeader) && !this.webRequest_.getAdditionalHeaders().get("Origin").equals(originHeader)) {
            return false;
        }
        String headersHeader = preflightResponse.getResponseHeaderValue("Access-Control-Allow-Headers");
        headersHeader = headersHeader == null ? RESPONSE_TYPE_DEFAULT : headersHeader.toLowerCase(Locale.ROOT);
        for (Map.Entry<String, String> header : this.webRequest_.getAdditionalHeaders().entrySet()) {
            String key = header.getKey().toLowerCase(Locale.ROOT);
            if (!XMLHttpRequest.isPreflightHeader(key, header.getValue()) || headersHeader.contains(key)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPreflightHeader(String name, String value) {
        if ("content-type".equals(name)) {
            String lcValue = value.toLowerCase(Locale.ROOT);
            return !lcValue.startsWith(FormEncodingType.URL_ENCODED.getName()) && !lcValue.startsWith(FormEncodingType.MULTIPART.getName()) && !lcValue.startsWith(FormEncodingType.TEXT_PLAIN.getName());
        }
        return !"accept".equals(name) && !"accept-language".equals(name) && !"content-language".equals(name) && !"referer".equals(name) && !"accept-encoding".equals(name) && !"origin".equals(name);
    }

    @JsxFunction
    public void setRequestHeader(String name, String value) {
        if (!XMLHttpRequest.isAuthorizedHeader(name)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Ignoring XMLHttpRequest.setRequestHeader for " + name + ": it is a restricted header"));
            }
            return;
        }
        if (this.webRequest_ == null) {
            throw Context.reportRuntimeError((String)"The open() method must be called before setRequestHeader().");
        }
        this.webRequest_.setAdditionalHeader(name, value);
    }

    static boolean isAuthorizedHeader(String name) {
        String nameLowerCase = name.toLowerCase(Locale.ROOT);
        if (PROHIBITED_HEADERS_.contains(nameLowerCase)) {
            return false;
        }
        return !nameLowerCase.startsWith("proxy-") && !nameLowerCase.startsWith("sec-");
    }

    @JsxFunction
    public void overrideMimeType(String mimeType) {
        if (this.state_ != 0 && this.state_ != 1) {
            throw Context.reportRuntimeError((String)"Property 'overrideMimeType' not writable after sent.");
        }
        this.overriddenMimeType_ = mimeType;
    }

    @JsxGetter
    public boolean isWithCredentials() {
        return this.withCredentials_;
    }

    @JsxSetter
    public void setWithCredentials(boolean withCredentials) {
        this.withCredentials_ = withCredentials;
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (!this.caseSensitiveProperties_) {
            for (String property : ALL_PROPERTIES_) {
                if (!property.equalsIgnoreCase(name)) continue;
                name = property;
                break;
            }
        }
        return super.get(name, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (!this.caseSensitiveProperties_) {
            for (String property : ALL_PROPERTIES_) {
                if (!property.equalsIgnoreCase(name)) continue;
                name = property;
                break;
            }
        }
        super.put(name, start, value);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public XMLHttpRequestUpload getUpload() {
        XMLHttpRequestUpload upload = new XMLHttpRequestUpload();
        upload.setParentScope(this.getParentScope());
        upload.setPrototype(this.getPrototype(upload.getClass()));
        return upload;
    }

    @JsxGetter(value={SupportedBrowser.IE}, propertyName="upload")
    public XMLHttpRequestEventTarget getUploadIE_js() {
        XMLHttpRequestEventTarget upload = new XMLHttpRequestEventTarget();
        upload.setParentScope(this.getParentScope());
        upload.setPrototype(this.getPrototype(upload.getClass()));
        return upload;
    }

    @Override
    @JsxGetter
    public Function getOnreadystatechange() {
        return super.getOnreadystatechange();
    }

    @Override
    @JsxSetter
    public void setOnreadystatechange(Function readyStateChangeHandler) {
        super.setOnreadystatechange(readyStateChangeHandler);
    }

    @JsxGetter
    public int getTimeout() {
        return this.timeout_;
    }

    @JsxSetter
    public void setTimeout(int timeout) {
        this.timeout_ = timeout;
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOntimeout() {
        return super.getOntimeout();
    }

    @Override
    @JsxSetter
    public void setOntimeout(Function timeoutHandler) {
        super.setOntimeout(timeoutHandler);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnprogress() {
        return super.getOnprogress();
    }

    @Override
    @JsxSetter
    public void setOnprogress(Function progressHandler) {
        super.setOnprogress(progressHandler);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnload() {
        return super.getOnload();
    }

    @Override
    @JsxSetter
    public void setOnload(Function loadHandler) {
        super.setOnload(loadHandler);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnloadstart() {
        return super.getOnloadstart();
    }

    @Override
    @JsxSetter
    public void setOnloadstart(Function loadstartHandler) {
        super.setOnloadstart(loadstartHandler);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnloadend() {
        return super.getOnloadend();
    }

    @Override
    @JsxSetter
    public void setOnloadend(Function loadendHandler) {
        super.setOnloadend(loadendHandler);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnabort() {
        return super.getOnabort();
    }

    @Override
    @JsxSetter
    public void setOnabort(Function abortHandler) {
        super.setOnabort(abortHandler);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnerror() {
        return super.getOnerror();
    }

    @Override
    @JsxSetter
    public void setOnerror(Function errorHandler) {
        super.setOnerror(errorHandler);
    }

    private static final class NetworkErrorWebResponse
    extends WebResponse {
        private final WebRequest request_;
        private final IOException error_;

        NetworkErrorWebResponse(WebRequest webRequest, IOException error) {
            super(null, null, 0L);
            this.request_ = webRequest;
            this.error_ = error;
        }

        @Override
        public int getStatusCode() {
            return 0;
        }

        @Override
        public String getStatusMessage() {
            return XMLHttpRequest.RESPONSE_TYPE_DEFAULT;
        }

        @Override
        public String getContentType() {
            return XMLHttpRequest.RESPONSE_TYPE_DEFAULT;
        }

        @Override
        public String getContentAsString() {
            return XMLHttpRequest.RESPONSE_TYPE_DEFAULT;
        }

        @Override
        public InputStream getContentAsStream() {
            return null;
        }

        @Override
        public List<NameValuePair> getResponseHeaders() {
            return Collections.emptyList();
        }

        @Override
        public String getResponseHeaderValue(String headerName) {
            return XMLHttpRequest.RESPONSE_TYPE_DEFAULT;
        }

        @Override
        public long getLoadTime() {
            return 0L;
        }

        @Override
        public Charset getContentCharset() {
            return null;
        }

        @Override
        public Charset getContentCharsetOrNull() {
            return null;
        }

        @Override
        public WebRequest getWebRequest() {
            return this.request_;
        }

        public IOException getError() {
            return this.error_;
        }
    }
}

