/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page.impl;

import jakarta.data.page.CursoredPage;
import jakarta.data.page.PageRequest;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public record CursoredPageRecord<T>(List<T> content, List<PageRequest.Cursor> cursors, long totalElements, PageRequest pageRequest, PageRequest nextPageRequest, PageRequest previousPageRequest) implements CursoredPage<T>
{
    private final long totalElements;
    private final PageRequest nextPageRequest;
    private final PageRequest previousPageRequest;

    public CursoredPageRecord(List<T> content, List<PageRequest.Cursor> cursors, long totalElements, PageRequest pageRequest, boolean firstPage, boolean lastPage) {
        this(content, cursors, totalElements, pageRequest, lastPage ? null : PageRequest.afterCursor(cursors.get(cursors.size() - 1), pageRequest.page() + 1L, pageRequest.size(), pageRequest.requestTotal()), firstPage ? null : PageRequest.beforeCursor(cursors.get(0), pageRequest.page() == 1L ? 1L : pageRequest.page() - 1L, pageRequest.size(), pageRequest.requestTotal()));
    }

    @Override
    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    @Override
    public int numberOfElements() {
        return this.content.size();
    }

    @Override
    public boolean hasNext() {
        return this.nextPageRequest != null;
    }

    @Override
    public boolean hasPrevious() {
        return this.previousPageRequest != null;
    }

    @Override
    public PageRequest nextPageRequest() {
        if (this.nextPageRequest == null) {
            throw new NoSuchElementException();
        }
        return this.nextPageRequest;
    }

    @Override
    public PageRequest previousPageRequest() {
        if (this.previousPageRequest == null) {
            throw new NoSuchElementException();
        }
        return this.previousPageRequest;
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    @Override
    public PageRequest.Cursor cursor(int index) {
        return this.cursors.get(index);
    }

    @Override
    public boolean hasTotals() {
        return this.totalElements >= 0L;
    }

    @Override
    public long totalElements() {
        if (this.totalElements < 0L) {
            throw new IllegalStateException("total elements are not available");
        }
        return this.totalElements;
    }

    @Override
    public long totalPages() {
        if (this.totalElements < 0L) {
            throw new IllegalStateException("total elements are not available");
        }
        int size = this.pageRequest.size();
        return (this.totalElements + (long)size - 1L) / (long)size;
    }
}

