/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.event.AdminCommandEventBrokerImpl;
import com.sun.enterprise.util.AnnotationUtil;
import com.sun.enterprise.v3.admin.AdminCommandInstanceImpl;
import com.sun.enterprise.v3.admin.CommandRunnerImpl;
import com.sun.enterprise.v3.admin.JobCreatorService;
import com.sun.enterprise.v3.admin.JobManagerService;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandParameters;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandSupport;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.JobCreator;
import org.glassfish.api.admin.JobManager;
import org.glassfish.api.admin.ManagedJob;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.hk2.api.ServiceLocator;

class CommandRunnerExecutionContext
implements CommandRunner.CommandInvocation {
    private final CommandRunnerImpl commandRunner;
    private static final Logger LOGGER = Logger.getLogger(CommandRunnerExecutionContext.class.getName());
    protected String scope;
    protected String name;
    protected ActionReport report;
    protected ParameterMap params;
    protected CommandParameters paramObject;
    protected Payload.Inbound inbound;
    protected Payload.Outbound outbound;
    protected Subject subject;
    protected ProgressStatus progressStatusChild;
    protected boolean isManagedJob;
    protected boolean isNotify;
    private final List<NameListerPair> nameListerPairs = new ArrayList<NameListerPair>();

    CommandRunnerExecutionContext(String scope, String name, ActionReport report, Subject subject, boolean isNotify, CommandRunnerImpl commandRunner) {
        this.commandRunner = commandRunner;
        this.scope = scope;
        this.name = name;
        this.report = report;
        this.subject = subject;
        this.isNotify = isNotify;
    }

    public CommandRunner.CommandInvocation parameters(CommandParameters paramObject) {
        this.paramObject = paramObject;
        return this;
    }

    public CommandRunner.CommandInvocation parameters(ParameterMap params) {
        this.params = params;
        return this;
    }

    public CommandRunner.CommandInvocation inbound(Payload.Inbound inbound) {
        this.inbound = inbound;
        return this;
    }

    public CommandRunner.CommandInvocation outbound(Payload.Outbound outbound) {
        this.outbound = outbound;
        return this;
    }

    public CommandRunner.CommandInvocation listener(String nameRegexp, AdminCommandEventBroker.AdminCommandListener listener) {
        this.nameListerPairs.add(new NameListerPair(this, nameRegexp, listener));
        return this;
    }

    public CommandRunner.CommandInvocation progressStatusChild(ProgressStatus ps) {
        this.progressStatusChild = ps;
        return this;
    }

    public CommandRunner.CommandInvocation managedJob() {
        this.isManagedJob = true;
        return this;
    }

    public void execute() {
        this.execute(null);
    }

    ParameterMap parameters() {
        return this.params;
    }

    CommandParameters typedParams() {
        return this.paramObject;
    }

    String name() {
        return this.name;
    }

    private String scope() {
        return this.scope;
    }

    public ActionReport report() {
        return this.report;
    }

    void setReport(ActionReport ar) {
        this.report = ar;
    }

    Payload.Inbound inboundPayload() {
        return this.inbound;
    }

    Payload.Outbound outboundPayload() {
        return this.outbound;
    }

    void executeFromCheckpoint(JobManager.Checkpoint checkpoint, boolean revert, AdminCommandEventBroker eventBroker) {
        Job job = checkpoint.getJob();
        if (this.subject == null) {
            this.subject = checkpoint.getContext().getSubject();
        }
        this.parameters(job.getParameters());
        AdminCommandContext context = checkpoint.getContext();
        this.report = context.getActionReport();
        this.inbound = context.getInboundPayload();
        this.outbound = context.getOutboundPayload();
        this.scope = job.getScope();
        this.name = job.getName();
        if (eventBroker == null) {
            eventBroker = job.getEventBroker() == null ? new AdminCommandEventBrokerImpl() : job.getEventBroker();
        }
        ((AdminCommandInstanceImpl)job).setEventBroker(eventBroker);
        ((AdminCommandInstanceImpl)job).setState(revert ? AdminCommandState.State.REVERTING : AdminCommandState.State.RUNNING_RETRYABLE);
        JobManager jobManager = (JobManager)this.commandRunner.serviceLocator.getService(JobManagerService.class, new Annotation[0]);
        jobManager.registerJob(job);
        AdminCommand command = checkpoint.getCommand();
        if (command == null && (command = this.commandRunner.getCommand(job.getScope(), job.getName(), this.report(), LOGGER)) == null) {
            return;
        }
        this.commandRunner.doCommand(this, command, this.subject, job);
        job.complete(this.report(), this.outboundPayload());
        if (this.progressStatusChild != null) {
            this.progressStatusChild.complete();
        }
        CommandSupport.done((ServiceLocator)this.commandRunner.serviceLocator, (AdminCommand)command, (Job)job);
    }

    public void execute(AdminCommand command) {
        if (command == null && (command = this.commandRunner.getCommand(this.scope(), this.name(), this.report(), LOGGER)) == null) {
            return;
        }
        if (this.subject == null) {
            this.subject = AccessController.doPrivileged(new PrivilegedAction<Subject>(this){

                @Override
                public Subject run() {
                    return Subject.getSubject(AccessController.getContext());
                }
            });
        }
        if (!this.isManagedJob) {
            this.isManagedJob = AnnotationUtil.presentTransitive(ManagedJob.class, (Class)command.getClass());
        }
        JobCreator jobCreator = null;
        JobManager jobManager = null;
        jobCreator = (JobCreator)this.commandRunner.serviceLocator.getService(JobCreator.class, this.scope + "job-creator", new Annotation[0]);
        jobManager = (JobManager)this.commandRunner.serviceLocator.getService(JobManagerService.class, new Annotation[0]);
        if (jobCreator == null) {
            jobCreator = (JobCreator)this.commandRunner.serviceLocator.getService(JobCreatorService.class, new Annotation[0]);
        }
        Job job = null;
        job = this.isManagedJob ? jobCreator.createJob(jobManager.getNewId(), this.scope(), this.name(), this.subject, this.isManagedJob, this.parameters()) : jobCreator.createJob(null, this.scope(), this.name(), this.subject, this.isManagedJob, this.parameters());
        for (NameListerPair nameListerPair : this.nameListerPairs) {
            job.getEventBroker().registerListener(nameListerPair.nameRegexp, nameListerPair.listener);
        }
        if (this.isManagedJob) {
            jobManager.registerJob(job);
        }
        this.commandRunner.doCommand(this, command, this.subject, job);
        job.complete(this.report(), this.outboundPayload());
        if (this.progressStatusChild != null) {
            this.progressStatusChild.complete();
        }
        CommandSupport.done((ServiceLocator)this.commandRunner.serviceLocator, (AdminCommand)command, (Job)job, (boolean)this.isNotify);
    }

    private class NameListerPair {
        private final String nameRegexp;
        private final AdminCommandEventBroker.AdminCommandListener listener;

        public NameListerPair(CommandRunnerExecutionContext commandRunnerExecutionContext, String nameRegexp, AdminCommandEventBroker.AdminCommandListener listener) {
            this.nameRegexp = nameRegexp;
            this.listener = listener;
        }
    }
}

