/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.glassfish.grizzly.config.GrizzlyConfig;
import org.glassfish.grizzly.config.ssl.JSSEKeyManager;
import org.glassfish.grizzly.http.util.StringManager;

public class SSLContextFactory
implements Cloneable {
    private static final StringManager sm = StringManager.getManager(SSLContextFactory.class.getPackage().getName(), SSLContextFactory.class.getClassLoader());
    private static final String defaultProtocol = "TLS";
    private static final String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private static final String defaultKeyPass = "changeit";
    private static final Logger logger = GrizzlyConfig.logger();
    private final Map<String, String> attributes = new HashMap<String, String>();
    private boolean clientAuthNeed;
    private boolean clientAuthWant;
    private SSLServerSocketFactory sslProxy;
    private String[] enabledCiphers;

    public SSLContext create() throws IOException {
        try {
            String algorithm;
            this.clientAuthNeed = Boolean.parseBoolean(this.getAttribute("clientAuthNeed"));
            this.clientAuthWant = Boolean.parseBoolean(this.getAttribute("clientAuthWant"));
            String protocol = this.getAttribute("protocol");
            if (protocol == null) {
                protocol = defaultProtocol;
            }
            if ((algorithm = this.getAttribute("algorithm")) == null) {
                algorithm = defaultAlgorithm;
            }
            SSLContext context = SSLContext.getInstance(protocol);
            this.configureSSLSessionContext(context.getServerSessionContext());
            String trustAlgorithm = this.getAttribute("truststoreAlgorithm");
            if (trustAlgorithm == null) {
                trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            context.init(this.getKeyManagers(algorithm, this.getAttribute("keyAlias")), this.getTrustManagers(trustAlgorithm), new SecureRandom());
            this.sslProxy = context.getServerSocketFactory();
            String requestedCiphers = this.getAttribute("ciphers");
            if (requestedCiphers != null) {
                this.enabledCiphers = this.getEnabledCiphers(requestedCiphers, this.sslProxy.getSupportedCipherSuites());
            }
            this.checkConfig();
            return context;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    public final void setAttribute(String name, String value) {
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }

    public final String getAttribute(String name) {
        return this.attributes.get(name);
    }

    protected String[] getEnabledCiphers(String requestedCiphers, String[] supportedCiphers) {
        String[] enabled = null;
        if (requestedCiphers != null) {
            ArrayList<String> vec = null;
            String cipher = requestedCiphers;
            int index = requestedCiphers.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    cipher = requestedCiphers.substring(fromIndex, index).trim();
                    if (cipher.length() > 0) {
                        for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                            if (!supportedCiphers[i].equals(cipher)) continue;
                            if (vec == null) {
                                vec = new ArrayList();
                            }
                            vec.add(cipher);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedCiphers.indexOf(44, fromIndex);
                }
                cipher = requestedCiphers.substring(fromIndex);
            }
            assert (cipher != null);
            if ((cipher = cipher.trim()).length() > 0) {
                for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                    if (!supportedCiphers[i].equals(cipher)) continue;
                    if (vec == null) {
                        vec = new ArrayList<String>();
                    }
                    vec.add(cipher);
                    break;
                }
            }
            if (vec != null) {
                enabled = (String[])vec.toArray(String[]::new);
            }
        }
        return enabled;
    }

    private String getKeystorePassword() {
        String keystorePass;
        String keyPass = this.getAttribute("keypass");
        if (keyPass == null) {
            keyPass = defaultKeyPass;
        }
        if ((keystorePass = this.getAttribute("keystorePass")) == null) {
            keystorePass = keyPass;
        }
        return keystorePass;
    }

    private KeyStore getKeystore(String pass) throws IOException {
        String keystoreFile = this.getAttribute("keystore");
        logger.log(Level.FINE, "Keystore file= {0}", keystoreFile);
        String keystoreType = this.getAttribute("keystoreType");
        logger.log(Level.FINE, "Keystore type= {0}", keystoreType);
        return this.getStore(keystoreType, keystoreFile, pass);
    }

    protected KeyStore getTrustStore() throws IOException {
        KeyStore ts = null;
        String truststore = this.getAttribute("truststore");
        logger.log(Level.FINE, "Truststore file= {0}", truststore);
        String truststoreType = this.getAttribute("truststoreType");
        logger.log(Level.FINE, "Truststore type= {0}", truststoreType);
        String truststorePassword = this.getTruststorePassword();
        if (truststore != null && truststorePassword != null) {
            ts = this.getStore(truststoreType, truststore, truststorePassword);
        }
        return ts;
    }

    private String getTruststorePassword() {
        String truststorePassword = this.getAttribute("truststorePass");
        if (truststorePassword == null && (truststorePassword = System.getProperty("javax.net.ssl.trustStorePassword")) == null) {
            truststorePassword = this.getKeystorePassword();
        }
        return truststorePassword;
    }

    private KeyStore getStore(String type, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            ks = KeyStore.getInstance(type);
            if (!"PKCS11".equalsIgnoreCase(type) && !"".equalsIgnoreCase(path)) {
                File keyStoreFile = new File(path);
                if (!keyStoreFile.isAbsolute()) {
                    keyStoreFile = new File(System.getProperty("catalina.base"), path);
                }
                istream = new FileInputStream(keyStoreFile);
            }
            ks.load(istream, pass.toCharArray());
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.SEVERE, sm.getString("jsse.keystore_load_failed", type, path, fnfe.getMessage()), fnfe);
            throw fnfe;
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, sm.getString("jsse.keystore_load_failed", type, path, ioe.getMessage()), ioe);
            throw ioe;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, sm.getString("jsse.keystore_load_failed", type, path, ex.getMessage()), ex);
            throw new IOException(sm.getString("jsse.keystore_load_failed", type, path, ex.getMessage()));
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    protected String[] getEnabledProtocols(SSLServerSocket socket, String requestedProtocols) {
        String[] supportedProtocols = socket.getSupportedProtocols();
        String[] enabledProtocols = null;
        if (requestedProtocols != null) {
            ArrayList<String> vec = null;
            String protocol = requestedProtocols;
            int index = requestedProtocols.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    protocol = requestedProtocols.substring(fromIndex, index).trim();
                    if (supportedProtocols != null && protocol.length() > 0) {
                        String[] stringArray = supportedProtocols;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String supportedProtocol = stringArray[i];
                            if (!supportedProtocol.equals(protocol)) continue;
                            if (vec == null) {
                                vec = new ArrayList();
                            }
                            vec.add(protocol);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedProtocols.indexOf(44, fromIndex);
                }
                protocol = requestedProtocols.substring(fromIndex);
            }
            assert (protocol != null);
            if ((protocol = protocol.trim()).length() > 0 && supportedProtocols != null) {
                for (String supportedProtocol : supportedProtocols) {
                    if (!supportedProtocol.equals(protocol)) continue;
                    if (vec == null) {
                        vec = new ArrayList<String>();
                    }
                    vec.add(protocol);
                    break;
                }
            }
            if (vec != null) {
                enabledProtocols = (String[])vec.toArray(String[]::new);
            }
        }
        return enabledProtocols;
    }

    private void initServerSocket(ServerSocket ssocket) {
        if (!(ssocket instanceof SSLServerSocket)) {
            throw new IllegalArgumentException("The ServerSocket has to be SSLServerSocket");
        }
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        if (this.getAttribute("ciphers") != null) {
            socket.setEnabledCipherSuites(this.enabledCiphers);
        }
        String requestedProtocols = this.getAttribute("protocols");
        this.setEnabledProtocols(socket, this.getEnabledProtocols(socket, requestedProtocols));
        if (this.clientAuthNeed) {
            socket.setNeedClientAuth(this.clientAuthNeed);
        } else {
            socket.setWantClientAuth(this.clientAuthWant);
        }
    }

    private void setEnabledProtocols(SSLServerSocket socket, String[] protocols) {
        if (protocols != null) {
            socket.setEnabledProtocols(protocols);
        }
    }

    protected KeyManager[] getKeyManagers(String algorithm, String keyAlias) throws Exception {
        String keystorePass = this.getKeystorePassword();
        KeyStore ks = this.getKeystore(keystorePass);
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException(sm.getString("jsse.alias_no_key_entry", keyAlias));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keystorePass.toCharArray());
        KeyManager[] kms = kmf.getKeyManagers();
        if (keyAlias != null) {
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], keyAlias);
            }
        }
        return kms;
    }

    protected TrustManager[] getTrustManagers(String algorithm) throws Exception {
        String crlFile = this.getAttribute("crlFile");
        TrustManager[] tms = null;
        KeyStore trustStore = this.getTrustStore();
        if (trustStore != null) {
            if (crlFile == null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(trustStore);
                tms = tmf.getTrustManagers();
            } else {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                CertPathParameters params = this.getParameters(algorithm, crlFile, trustStore);
                CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
                tmf.init(mfp);
                tms = tmf.getTrustManagers();
            }
        }
        return tms;
    }

    private CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws Exception {
        PKIXBuilderParameters xparams;
        if ("PKIX".equalsIgnoreCase(algorithm)) {
            xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            Collection<? extends CRL> crls = this.getCRLs(crlf);
            CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
            CertStore store = CertStore.getInstance("Collection", csp);
            xparams.addCertStore(store);
            xparams.setRevocationEnabled(true);
            String trustLength = this.getAttribute("trustMaxCertLength");
            if (trustLength != null) {
                try {
                    xparams.setMaxPathLength(Integer.parseInt(trustLength));
                }
                catch (Exception ex) {
                    logger.warning("Bad maxCertLength: " + trustLength);
                }
            }
        } else {
            throw new CRLException("CRLs not supported for type: " + algorithm);
        }
        PKIXBuilderParameters params = xparams;
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends CRL> getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        File crlFile = new File(crlf);
        if (!crlFile.isAbsolute()) {
            crlFile = new File(System.getProperty("catalina.base"), crlf);
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        FileInputStream is = new FileInputStream(crlFile);
        try {
            Collection<? extends CRL> collection = cf.generateCRLs(is);
            return collection;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void configureSSLSessionContext(SSLSessionContext sslSessionCtxt) {
        String attrValue = this.getAttribute("sslSessionTimeout");
        if (attrValue != null) {
            sslSessionCtxt.setSessionTimeout(Integer.parseInt(attrValue));
        }
        if ((attrValue = this.getAttribute("ssl3SessionTimeout")) != null) {
            sslSessionCtxt.setSessionTimeout(Integer.parseInt(attrValue));
        }
        if ((attrValue = this.getAttribute("sslSessionCacheSize")) != null) {
            sslSessionCtxt.setSessionCacheSize(Integer.parseInt(attrValue));
        }
    }

    private void checkConfig() throws IOException {
        ServerSocket socket = this.sslProxy.createServerSocket();
        this.initServerSocket(socket);
        try {
            socket.setSoTimeout(1);
            socket.accept();
        }
        catch (SSLException ssle) {
            throw new IOException(sm.getString("jsse.invalid_ssl_conf", ssle.getMessage()), ssle);
        }
        catch (Exception exception) {
        }
        finally {
            if (!socket.isClosed()) {
                socket.close();
            }
        }
    }
}

