/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.timer;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.timer.TimerFactory;
import org.apache.derby.shared.common.error.StandardException;

public class SingletonTimerFactory
implements TimerFactory,
ModuleControl {
    private final Timer singletonTimer;
    private final AtomicInteger cancelCount = new AtomicInteger();
    private StringBuilder warnings = new StringBuilder();

    public SingletonTimerFactory() {
        ClassLoader classLoader = this.getContextClassLoader();
        if (classLoader != null) {
            this.setContextClassLoader(null);
        }
        this.singletonTimer = new Timer(true);
        if (classLoader != null) {
            this.setContextClassLoader(classLoader);
        }
    }

    @Override
    public void schedule(TimerTask timerTask, long l) {
        this.singletonTimer.schedule(timerTask, l);
    }

    @Override
    public void cancel(TimerTask timerTask) {
        timerTask.cancel();
        if (this.cancelCount.incrementAndGet() % 1000 == 0) {
            this.singletonTimer.purge();
        }
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
    }

    @Override
    public void stop() {
        this.singletonTimer.cancel();
    }

    private ClassLoader getContextClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == this.getClass().getClassLoader() || classLoader == Thread.class.getClassLoader()) {
            return null;
        }
        return classLoader;
    }

    private void setContextClassLoader(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    public String getWarnings() {
        String string = this.warnings.toString();
        this.warnings = null;
        return "".equals(string) ? null : string;
    }
}

