/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.HelpWindow;
import com.sun.webui.jsf.renderkit.html.HyperlinkRenderer;
import com.sun.webui.jsf.util.LogUtil;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public final class HelpWindowRenderer
extends HyperlinkRenderer {
    @Override
    protected String getCorrectURL(FacesContext context, UIComponent component, String url) {
        if (!(component instanceof HelpWindow)) {
            return null;
        }
        if (url == null) {
            return null;
        }
        StringBuffer urlBuffer = new StringBuffer();
        urlBuffer.append(context.getApplication().getViewHandler().getActionURL(context, url)).append("?");
        HelpWindow hw = (HelpWindow)component;
        try {
            if (hw.getWindowTitle() != null) {
                this.addParameter(urlBuffer, "windowTitle", hw.getWindowTitle());
            }
            if (hw.getHelpFile() != null) {
                this.addParameter(urlBuffer, "helpFile", hw.getHelpFile());
            }
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.warning("Encoding error: ", e);
        }
        return urlBuffer.toString();
    }

    private void addParameter(StringBuffer buffer, String name, String value) throws UnsupportedEncodingException {
        if (buffer == null || name == null || value == null) {
            return;
        }
        buffer.append("&").append(name).append("=").append(URLEncoder.encode(value, "UTF-8"));
    }
}

