/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.SerializationContextImpl;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.ModelSerializer;

public class NullSerializer
implements ModelSerializer {
    private final ModelSerializer delegate;
    private final ModelSerializer nullSerializer;
    private final ModelSerializer rootNullSerializer;

    public NullSerializer(ModelSerializer delegate, Customization customization, JsonbContext jsonbContext) {
        this.delegate = delegate;
        this.nullSerializer = customization.isNillable() ? new NullWritingEnabled() : new NullWritingDisabled();
        JsonbSerializer<Object> userDefinedNullSerializer = jsonbContext.getConfigProperties().getNullSerializer();
        this.rootNullSerializer = userDefinedNullSerializer != null ? (value, generator, context) -> userDefinedNullSerializer.serialize(null, generator, (SerializationContext)context) : this.nullSerializer;
    }

    @Override
    public void serialize(Object value, JsonGenerator generator, SerializationContextImpl context) {
        if (value == null) {
            if (context.isRoot()) {
                context.setRoot(false);
                this.rootNullSerializer.serialize(null, generator, context);
            } else {
                this.nullSerializer.serialize(null, generator, context);
            }
            context.setKey(null);
        } else {
            context.setRoot(false);
            this.delegate.serialize(value, generator, context);
        }
    }

    private static final class NullWritingEnabled
    implements ModelSerializer {
        private NullWritingEnabled() {
        }

        @Override
        public void serialize(Object value, JsonGenerator generator, SerializationContextImpl context) {
            if (context.getKey() == null) {
                generator.writeNull();
            } else {
                generator.writeNull(context.getKey());
            }
        }
    }

    private static class NullWritingDisabled
    implements ModelSerializer {
        private NullWritingDisabled() {
        }

        @Override
        public void serialize(Object value, JsonGenerator generator, SerializationContextImpl context) {
            if (context.isContainerWithNulls()) {
                if (context.getKey() == null) {
                    generator.writeNull();
                } else {
                    generator.writeNull(context.getKey());
                }
            }
            context.setKey(null);
        }
    }
}

