/*
 * Decompiled with CFR 0.152.
 */
package com.sun.logging;

import com.sun.logging.LogDomainsLogger;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogDomains {
    public static final String DOMAIN_ROOT = "jakarta.";
    public static final String UPGRADE_LOGGER = "upgradeLogger";
    public static final String PACKAGE_ROOT = "com.sun.logging.";
    public static final String RESOURCE_BUNDLE = "LogStrings";
    public static final String EJB_LOGGER = "jakarta.enterprise.system.container.ejb";
    public static final String JAVAMAIL_LOGGER = "jakarta.enterprise.resource.javamail";
    public static final String JMS_LOGGER = "jakarta.enterprise.resource.jms";
    public static final String WEB_LOGGER = "jakarta.enterprise.system.container.web";
    public static final String CMP_LOGGER = "jakarta.enterprise.system.container.cmp";
    public static final String JDO_LOGGER = "jakarta.enterprise.resource.jdo";
    public static final String ACC_LOGGER = "jakarta.enterprise.system.container.appclient";
    public static final String MDB_LOGGER = "jakarta.enterprise.system.container.ejb.mdb";
    public static final String SECURITY_LOGGER = "jakarta.enterprise.system.core.security";
    public static final String TRANSACTION_LOGGER = "jakarta.enterprise.system.core.transaction";
    public static final String CORBA_LOGGER = "jakarta.enterprise.resource.corba";
    public static final String UTIL_LOGGER = "jakarta.enterprise.system.util";
    public static final String JNDI_LOGGER = "jakarta.enterprise.system.core.naming";
    public static final String JTA_LOGGER = "jakarta.enterprise.resource.jta";
    public static final String RSR_LOGGER = "jakarta.enterprise.resource.resourceadapter";
    public static final String DPL_LOGGER = "jakarta.enterprise.system.tools.deployment";
    public static final String JAXRPC_LOGGER = "jakarta.enterprise.system.webservices.rpc";
    public static final String JAXR_LOGGER = "jakarta.enterprise.system.webservices.registry";
    public static final String SAAJ_LOGGER = "jakarta.enterprise.system.webservices.saaj";
    public static final String SELF_MANAGEMENT_LOGGER = "jakarta.enterprise.system.core.selfmanagement";
    public static final String SQL_TRACE_LOGGER = "jakarta.enterprise.resource.sqltrace";
    public static final String ADMIN_LOGGER = "jakarta.enterprise.system.tools.admin";
    public static final String SERVER_LOGGER = "jakarta.enterprise.system";
    public static final String CORE_LOGGER = "jakarta.enterprise.system.core";
    public static final String LOADER_LOGGER = "jakarta.enterprise.system.core.classloading";
    public static final String CONFIG_LOGGER = "jakarta.enterprise.system.core.config";
    public static final String PERSISTENCE_LOGGER = "jakarta.org.glassfish.persistence";
    private static final LogManager MANAGER = LogManager.getLogManager();
    private static final Logger LOG = Logger.getLogger(LogDomains.class.getName());

    public static Logger getLogger(Class<?> clazz, String loggerNamePrefix) {
        return LogDomains.getLogger(clazz, loggerNamePrefix, true);
    }

    public static Logger getLogger(Class<?> clazz, String loggerNamePrefix, boolean findResourceBundle) {
        ClassLoader resourceBundleLoader = findResourceBundle ? clazz.getClassLoader() : null;
        return LogDomains.getLogger(clazz, loggerNamePrefix, resourceBundleLoader);
    }

    public static Logger getLogger(Class<?> clazz, String loggerNamePrefix, ClassLoader rbLoader) {
        ResourceBundle resourceBundle;
        String loggerName = loggerNamePrefix + "." + clazz.getPackageName();
        Logger cachedLogger = MANAGER.getLogger(loggerName);
        if (cachedLogger != null) {
            LOG.log(Level.FINEST, "Cached logger: {0}", cachedLogger);
            return cachedLogger;
        }
        if (rbLoader == null) {
            resourceBundle = null;
        } else {
            String bundleName = LogDomains.getResourceBundleNameForDomainRoot(loggerNamePrefix);
            resourceBundle = LogDomains.getResourceBundle(bundleName, clazz, rbLoader);
        }
        LogDomainsLogger newLogger = new LogDomainsLogger(loggerName, resourceBundle);
        boolean added = MANAGER.addLogger((Logger)((Object)newLogger));
        if (added) {
            LOG.log(Level.CONFIG, "Registered new logger: {0}", (Object)newLogger);
            return newLogger;
        }
        return MANAGER.getLogger(((Logger)((Object)newLogger)).getName());
    }

    private static String getResourceBundleNameForDomainRoot(String loggerNamePrefix) {
        if (loggerNamePrefix.startsWith(DOMAIN_ROOT)) {
            return loggerNamePrefix.replaceFirst(DOMAIN_ROOT, PACKAGE_ROOT);
        }
        return loggerNamePrefix;
    }

    private static ResourceBundle getResourceBundle(String name, Class<?> clazz, ClassLoader rbLoader) {
        ResourceBundle classBundle = LogDomains.findResourceBundle(name, clazz, rbLoader);
        if (classBundle != null) {
            return classBundle;
        }
        LOG.log(Level.WARNING, "Cannot find the resource bundle for the name {0} for {1} using classloader {2}", new Object[]{name, clazz, rbLoader});
        return null;
    }

    private static ResourceBundle findResourceBundle(String name, Class<?> clazz, ClassLoader rbLoader) {
        ResourceBundle packageRootBundle = LogDomains.tryTofindResourceBundle(name, rbLoader);
        if (packageRootBundle != null) {
            return packageRootBundle;
        }
        StringBuilder rbPackage = new StringBuilder(clazz.getPackage().getName());
        while (true) {
            ResourceBundle subPkgBundle;
            if ((subPkgBundle = LogDomains.tryTofindResourceBundle(rbPackage.toString(), rbLoader)) != null) {
                return subPkgBundle;
            }
            int lastDotIndex = rbPackage.lastIndexOf(".");
            if (lastDotIndex == -1) break;
            rbPackage.delete(lastDotIndex, rbPackage.length());
        }
        return null;
    }

    private static ResourceBundle tryTofindResourceBundle(String name, ClassLoader rbLoader) {
        try {
            return ResourceBundle.getBundle(name + ".LogStrings", Locale.getDefault(), rbLoader);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

