/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.xact.ContainerLocking2;
import org.apache.derby.impl.store.raw.xact.ContainerLocking3;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.InternalXact;
import org.apache.derby.impl.store.raw.xact.NoLocking;
import org.apache.derby.impl.store.raw.xact.RowLocking1;
import org.apache.derby.impl.store.raw.xact.RowLocking2;
import org.apache.derby.impl.store.raw.xact.RowLocking2nohold;
import org.apache.derby.impl.store.raw.xact.RowLocking3;
import org.apache.derby.impl.store.raw.xact.RowLockingRR;
import org.apache.derby.impl.store.raw.xact.TransactionTable;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.impl.store.raw.xact.XactContext;
import org.apache.derby.impl.store.raw.xact.XactId;
import org.apache.derby.impl.store.raw.xact.XactXAResourceManager;
import org.apache.derby.shared.common.error.StandardException;

public class XactFactory
implements TransactionFactory,
ModuleControl,
ModuleSupportable {
    protected static final String USER_CONTEXT_ID = "UserTransaction";
    protected static final String NESTED_READONLY_USER_CONTEXT_ID = "NestedRawReadOnlyUserTransaction";
    protected static final String NESTED_UPDATE_USER_CONTEXT_ID = "NestedRawUpdateUserTransaction";
    protected static final String INTERNAL_CONTEXT_ID = "InternalTransaction";
    protected static final String NTT_CONTEXT_ID = "NestedTransaction";
    protected DaemonService rawStoreDaemon;
    private UUIDFactory uuidFactory;
    protected ContextService contextFactory;
    protected LockFactory lockFactory;
    protected LogFactory logFactory;
    protected DataFactory dataFactory;
    protected DataValueFactory dataValueFactory;
    protected RawStoreFactory rawStoreFactory;
    public TransactionTable ttab;
    private final AtomicLong tranId = new AtomicLong();
    private LockingPolicy[][] lockingPolicies = new LockingPolicy[3][6];
    private boolean inCreateNoLog = false;
    private Object xa_resource;
    private Object backupSemaphore = new Object();
    private long backupBlockingOperations = 0L;
    private boolean inBackup = false;

    @Override
    public boolean canSupport(Properties properties) {
        return true;
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        this.uuidFactory = XactFactory.getMonitor().getUUIDFactory();
        this.dataValueFactory = (DataValueFactory)XactFactory.bootServiceModule(bl, this, "org.apache.derby.iapi.types.DataValueFactory", properties);
        this.contextFactory = XactFactory.getContextService();
        this.lockFactory = (LockFactory)XactFactory.bootServiceModule(false, this, "org.apache.derby.iapi.services.locks.LockFactory", properties);
        this.lockingPolicies[0][0] = new NoLocking();
        this.lockingPolicies[1][0] = new NoLocking();
        this.lockingPolicies[1][1] = new RowLocking1(this.lockFactory);
        this.lockingPolicies[1][2] = new RowLocking2(this.lockFactory);
        this.lockingPolicies[1][3] = new RowLocking2nohold(this.lockFactory);
        this.lockingPolicies[1][4] = new RowLockingRR(this.lockFactory);
        this.lockingPolicies[1][5] = new RowLocking3(this.lockFactory);
        this.lockingPolicies[2][0] = new NoLocking();
        this.lockingPolicies[2][1] = new ContainerLocking2(this.lockFactory);
        this.lockingPolicies[2][2] = new ContainerLocking2(this.lockFactory);
        this.lockingPolicies[2][3] = new ContainerLocking2(this.lockFactory);
        this.lockingPolicies[2][4] = new ContainerLocking3(this.lockFactory);
        this.lockingPolicies[2][5] = new ContainerLocking3(this.lockFactory);
        if (bl) {
            this.ttab = new TransactionTable();
            String string = properties.getProperty("derby.__rt.storage.createWithNoLog");
            this.inCreateNoLog = string != null && Boolean.valueOf(string) != false;
        }
    }

    @Override
    public void stop() {
        if (this.rawStoreDaemon != null) {
            this.rawStoreDaemon.stop();
        }
    }

    @Override
    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    @Override
    public void createFinished() throws StandardException {
        if (!this.inCreateNoLog) {
            throw StandardException.newException("XSTB5.M", new Object[0]);
        }
        if (this.ttab.hasActiveUpdateTransaction()) {
            throw StandardException.newException("XSTB5.M", new Object[0]);
        }
        this.inCreateNoLog = false;
    }

    private Xact startCommonTransaction(RawStoreFactory rawStoreFactory, Xact xact, ContextManager contextManager, boolean bl, CompatibilitySpace compatibilitySpace, String string, String string2, boolean bl2, boolean bl3) throws StandardException {
        Xact xact2 = new Xact(this, xact, this.logFactory, this.dataFactory, this.dataValueFactory, bl, compatibilitySpace, bl3);
        xact2.setTransName(string2);
        this.pushTransactionContext(contextManager, string, xact2, false, rawStoreFactory, bl2);
        return xact2;
    }

    @Override
    public RawTransaction startTransaction(RawStoreFactory rawStoreFactory, ContextManager contextManager, String string) throws StandardException {
        return this.startCommonTransaction(rawStoreFactory, null, contextManager, false, null, USER_CONTEXT_ID, string, true, true);
    }

    @Override
    public RawTransaction startNestedReadOnlyUserTransaction(RawStoreFactory rawStoreFactory, RawTransaction rawTransaction, CompatibilitySpace compatibilitySpace, ContextManager contextManager, String string) throws StandardException {
        return this.startCommonTransaction(rawStoreFactory, (Xact)rawTransaction, contextManager, true, compatibilitySpace, NESTED_READONLY_USER_CONTEXT_ID, string, false, true);
    }

    @Override
    public RawTransaction startNestedUpdateUserTransaction(RawStoreFactory rawStoreFactory, RawTransaction rawTransaction, ContextManager contextManager, String string, boolean bl) throws StandardException {
        return this.startCommonTransaction(rawStoreFactory, (Xact)rawTransaction, contextManager, false, null, NESTED_UPDATE_USER_CONTEXT_ID, string, true, bl);
    }

    @Override
    public RawTransaction startGlobalTransaction(RawStoreFactory rawStoreFactory, ContextManager contextManager, int n, byte[] byArray, byte[] byArray2) throws StandardException {
        GlobalXactId globalXactId = new GlobalXactId(n, byArray, byArray2);
        if (this.ttab.findTransactionContextByGlobalId(globalXactId) != null) {
            throw StandardException.newException("XSAX1.S", new Object[0]);
        }
        Xact xact = this.startCommonTransaction(rawStoreFactory, null, contextManager, false, null, USER_CONTEXT_ID, USER_CONTEXT_ID, true, true);
        xact.setTransactionId(globalXactId, xact.getId());
        return xact;
    }

    @Override
    public RawTransaction findUserTransaction(RawStoreFactory rawStoreFactory, ContextManager contextManager, String string) throws StandardException {
        XactContext xactContext = (XactContext)contextManager.getContext(USER_CONTEXT_ID);
        if (xactContext == null) {
            return this.startTransaction(rawStoreFactory, contextManager, string);
        }
        return xactContext.getTransaction();
    }

    @Override
    public RawTransaction startNestedTopTransaction(RawStoreFactory rawStoreFactory, ContextManager contextManager) throws StandardException {
        Xact xact = new Xact(this, null, this.logFactory, this.dataFactory, this.dataValueFactory, false, null, false);
        xact.setPostComplete();
        this.pushTransactionContext(contextManager, NTT_CONTEXT_ID, xact, true, rawStoreFactory, true);
        return xact;
    }

    @Override
    public RawTransaction startInternalTransaction(RawStoreFactory rawStoreFactory, ContextManager contextManager) throws StandardException {
        InternalXact internalXact = new InternalXact(this, this.logFactory, this.dataFactory, this.dataValueFactory);
        this.pushTransactionContext(contextManager, INTERNAL_CONTEXT_ID, internalXact, true, rawStoreFactory, true);
        return internalXact;
    }

    @Override
    public boolean findTransaction(TransactionId transactionId, RawTransaction rawTransaction) {
        return this.ttab.findAndAssumeTransaction(transactionId, rawTransaction);
    }

    @Override
    public void rollbackAllTransactions(RawTransaction rawTransaction, RawStoreFactory rawStoreFactory) throws StandardException {
        int n = 0;
        if (this.ttab.hasRollbackFirstTransaction()) {
            RawTransaction rawTransaction2 = this.startInternalTransaction(rawStoreFactory, rawTransaction.getContextManager());
            rawTransaction2.recoveryTransaction();
            while (this.ttab.getMostRecentRollbackFirstTransaction(rawTransaction2)) {
                ++n;
                rawTransaction2.abort();
            }
            rawTransaction2.close();
        }
        int n2 = 0;
        while (this.ttab.getMostRecentTransactionForRollback(rawTransaction)) {
            ++n2;
            rawTransaction.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePreparedXacts(RawStoreFactory rawStoreFactory) throws StandardException {
        boolean bl = false;
        if (this.ttab.hasPreparedRecoveredXact()) {
            while (true) {
                ContextManager contextManager = this.contextFactory.newContextManager();
                this.contextFactory.setCurrentContextManager(contextManager);
                try {
                    RawTransaction rawTransaction = this.startTransaction(this.rawStoreFactory, contextManager, USER_CONTEXT_ID);
                    if (this.ttab.getMostRecentPreparedRecoveredXact(rawTransaction)) {
                        rawTransaction.reprepare();
                        continue;
                    }
                    rawTransaction.destroy();
                }
                finally {
                    this.contextFactory.resetCurrentContextManager(contextManager);
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public LogInstant firstUpdateInstant() {
        return this.ttab.getFirstLogInstant();
    }

    @Override
    public StandardException markCorrupt(StandardException standardException) {
        this.logFactory.markCorrupt(standardException);
        return standardException;
    }

    public void setNewTransactionId(TransactionId transactionId, Xact xact) {
        boolean bl = true;
        if (transactionId != null) {
            bl = this.remove(transactionId);
        }
        XactId xactId = new XactId(this.tranId.getAndIncrement());
        xact.setTransactionId(xact.getGlobalId(), (TransactionId)xactId);
        if (transactionId != null) {
            this.add(xact, bl);
        }
    }

    @Override
    public void resetTranId() {
        XactId xactId = (XactId)this.ttab.largestUpdateXactId();
        long l = xactId == null ? 0L : xactId.getId();
        this.tranId.set(l + 1L);
    }

    protected void pushTransactionContext(ContextManager contextManager, String string, Xact xact, boolean bl, RawStoreFactory rawStoreFactory, boolean bl2) throws StandardException {
        if (contextManager.getContext(string) != null) {
            throw StandardException.newException("XSTA2.S", new Object[0]);
        }
        XactContext xactContext = new XactContext(contextManager, string, xact, bl, rawStoreFactory);
        this.add(xact, bl2);
    }

    protected void addUpdateTransaction(TransactionId transactionId, RawTransaction rawTransaction, int n) {
        this.ttab.addUpdateTransaction(transactionId, rawTransaction, n);
    }

    protected void removeUpdateTransaction(TransactionId transactionId) {
        this.ttab.removeUpdateTransaction(transactionId);
    }

    protected void prepareTransaction(TransactionId transactionId) {
        this.ttab.prepareTransaction(transactionId);
    }

    @Override
    public boolean submitPostCommitWork(Serviceable serviceable) {
        if (this.rawStoreDaemon != null) {
            return this.rawStoreDaemon.enqueue(serviceable, serviceable.serviceASAP());
        }
        return false;
    }

    @Override
    public void setRawStoreFactory(RawStoreFactory rawStoreFactory) throws StandardException {
        this.rawStoreFactory = rawStoreFactory;
        this.rawStoreDaemon = rawStoreFactory.getDaemon();
        this.logFactory = (LogFactory)XactFactory.findServiceModule(this, rawStoreFactory.getLogFactoryModule());
        this.dataFactory = (DataFactory)XactFactory.findServiceModule(this, rawStoreFactory.getDataFactoryModule());
    }

    @Override
    public boolean noActiveUpdateTransaction() {
        return !this.ttab.hasActiveUpdateTransaction();
    }

    @Override
    public boolean hasPreparedXact() {
        return this.ttab.hasPreparedXact();
    }

    protected boolean remove(TransactionId transactionId) {
        return this.ttab.remove(transactionId);
    }

    protected void add(Xact xact, boolean bl) {
        this.ttab.add(xact, bl);
    }

    public UUID makeNewUUID() {
        return this.uuidFactory.createUUID();
    }

    final LockingPolicy getLockingPolicy(int n, int n2, boolean bl) {
        LockingPolicy lockingPolicy;
        if (n == 0) {
            n2 = 0;
        }
        if ((lockingPolicy = this.lockingPolicies[n][n2]) != null || !bl) {
            return lockingPolicy;
        }
        ++n;
        while (n <= 2) {
            for (int i = n2; i <= 5; ++i) {
                lockingPolicy = this.lockingPolicies[n][i];
                if (lockingPolicy == null) continue;
                return lockingPolicy;
            }
            ++n;
        }
        return null;
    }

    @Override
    public Formatable getTransactionTable() {
        return this.ttab;
    }

    @Override
    public void useTransactionTable(Formatable formatable) throws StandardException {
        if (this.ttab != null && formatable != null) {
            throw StandardException.newException("XSTB6.M", new Object[0]);
        }
        if (this.ttab == null) {
            this.ttab = formatable == null ? new TransactionTable() : (TransactionTable)formatable;
        }
    }

    @Override
    public TransactionInfo[] getTransactionInfo() {
        return this.ttab.getTransactionInfo();
    }

    public boolean inDatabaseCreation() {
        return this.inCreateNoLog;
    }

    @Override
    public Object getXAResourceManager() throws StandardException {
        if (this.xa_resource == null) {
            this.xa_resource = new XactXAResourceManager(this.rawStoreFactory, this.ttab);
        }
        return this.xa_resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean blockBackup(boolean bl) {
        Object object = this.backupSemaphore;
        synchronized (object) {
            if (this.inBackup) {
                if (bl) {
                    while (this.inBackup) {
                        try {
                            this.backupSemaphore.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            InterruptStatus.setInterrupted();
                        }
                    }
                } else {
                    return false;
                }
            }
            ++this.backupBlockingOperations;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unblockBackup() {
        Object object = this.backupSemaphore;
        synchronized (object) {
            --this.backupBlockingOperations;
            if (this.inBackup) {
                this.backupSemaphore.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean blockBackupBlockingOperations(boolean bl) {
        Object object = this.backupSemaphore;
        synchronized (object) {
            if (bl) {
                this.inBackup = true;
                try {
                    while (this.backupBlockingOperations > 0L) {
                        try {
                            this.backupSemaphore.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            InterruptStatus.setInterrupted();
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.inBackup = false;
                    this.backupSemaphore.notifyAll();
                    throw runtimeException;
                }
            } else if (this.backupBlockingOperations == 0L) {
                this.inBackup = true;
            }
        }
        return this.inBackup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unblockBackupBlockingOperations() {
        Object object = this.backupSemaphore;
        synchronized (object) {
            this.inBackup = false;
            this.backupSemaphore.notifyAll();
        }
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static Object bootServiceModule(final boolean bl, final Object object, final String string, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.bootServiceModule(bl, object, string, properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }

    private static Object findServiceModule(final Object object, final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(object, string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }
}

