/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class DriverLoader
implements ConnectorConstants {
    private static Logger logger = LogDomains.getLogger(DriverLoader.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private static final String DRIVER_INTERFACE_NAME = "java.sql.Driver";
    private static final String SERVICES_DRIVER_IMPL_NAME = "META-INF/services/java.sql.Driver";
    private static final String DATABASE_VENDOR_DERBY = "DERBY";
    private static final String DATABASE_VENDOR_JAVADB = "JAVADB";
    private static final String DATABASE_VENDOR_EMBEDDED_DERBY = "EMBEDDED-DERBY";
    private static final String DATABASE_VENDOR_DERBY_30 = "DERBY-30";
    private static final String DATABASE_VENDOR_EMBEDDED_DERBY_30 = "EMBEDDED-DERBY-30";
    private static final String DATABASE_VENDOR_JAVADB_30 = "JAVADB-30";
    private static final String DATABASE_VENDOR_MSSQLSERVER = "MICROSOFTSQLSERVER";
    private static final String DATABASE_VENDOR_SUN_SQLSERVER = "SUN-SQLSERVER";
    private static final String DATABASE_VENDOR_SUN_ORACLE = "SUN-ORACLE";
    private static final String DATABASE_VENDOR_SUN_DB2 = "SUN-DB2";
    private static final String DATABASE_VENDOR_SUN_SYBASE = "SUN-SYBASE";
    private static final String DATABASE_VENDOR_SYBASE = "SYBASE";
    private static final String DATABASE_VENDOR_ORACLE = "ORACLE";
    private static final String DATABASE_VENDOR_DB2 = "DB2";
    private static final String DATABASE_VENDOR_EMBEDDED = "EMBEDDED";
    private static final String DATABASE_VENDOR_30 = "30";
    private static final String DATABASE_VENDOR_40 = "40";
    private static final String DATABASE_VENDOR_SQLSERVER = "SQLSERVER";
    private static final String DS_PROPERTIES = "ds.properties";
    private static final String CPDS_PROPERTIES = "cpds.properties";
    private static final String XADS_PROPERTIES = "xads.properties";
    private static final String DRIVER_PROPERTIES = "driver.properties";
    private static final String VENDOR_PROPERTIES = "dbvendor.properties";
    private static final String VALIDATIONCLASSNAMES_PROPERTIES = "validationclassnames.properties";
    private File mappingsRoot;

    @PostConstruct
    private void initPaths() {
        this.mappingsRoot = DriverLoader.resolveDbVendorMappingRoot();
    }

    private static File resolveDbVendorMappingRoot() {
        File connDbVendorMappingRoot = DriverLoader.getSystemPropertyAsFile("org.glassfish.connectors.dbVendorMappingRoot");
        if (connDbVendorMappingRoot != null) {
            return connDbVendorMappingRoot;
        }
        File installRoot = DriverLoader.getSystemPropertyAsFile("com.sun.aas.installRoot");
        if (installRoot == null) {
            return null;
        }
        File defaultRoot = installRoot.toPath().normalize().resolve(Path.of("lib", "install", "databases", "dbvendormapping")).toFile();
        if (defaultRoot.exists()) {
            return defaultRoot;
        }
        return null;
    }

    public Set<String> getDatabaseVendorNames() {
        if (this.mappingsRoot == null) {
            return Set.of();
        }
        File dbVendorFile = new File(this.mappingsRoot, VENDOR_PROPERTIES);
        Properties fileProperties = DriverLoader.loadFile(dbVendorFile);
        TreeSet<String> dbvendorNames = new TreeSet<String>();
        for (String vendor : fileProperties.stringPropertyNames()) {
            dbvendorNames.add(vendor);
        }
        return dbvendorNames;
    }

    public Properties getValidationClassMappingFile() {
        if (this.mappingsRoot == null) {
            return DriverLoader.loadFile(null);
        }
        return DriverLoader.loadFile(new File(this.mappingsRoot, VALIDATIONCLASSNAMES_PROPERTIES));
    }

    public String getDatabaseVendorName(String className) {
        if (this.mappingsRoot == null) {
            return null;
        }
        String dbVendor = this.getDatabaseVendorName(DriverLoader.loadFile(new File(this.mappingsRoot, DS_PROPERTIES)), className);
        if (dbVendor == null) {
            dbVendor = this.getDatabaseVendorName(DriverLoader.loadFile(new File(this.mappingsRoot, CPDS_PROPERTIES)), className);
        }
        if (dbVendor == null) {
            dbVendor = this.getDatabaseVendorName(DriverLoader.loadFile(new File(this.mappingsRoot, XADS_PROPERTIES)), className);
        }
        if (dbVendor == null) {
            dbVendor = this.getDatabaseVendorName(DriverLoader.loadFile(new File(this.mappingsRoot, DRIVER_PROPERTIES)), className);
        }
        return dbVendor;
    }

    private File getResourceTypeFile(String resType) {
        if (this.mappingsRoot == null) {
            return null;
        }
        if ("javax.sql.DataSource".equals(resType)) {
            return new File(this.mappingsRoot, DS_PROPERTIES);
        }
        if ("javax.sql.XADataSource".equals(resType)) {
            return new File(this.mappingsRoot, XADS_PROPERTIES);
        }
        if ("javax.sql.ConnectionPoolDataSource".equals(resType)) {
            return new File(this.mappingsRoot, CPDS_PROPERTIES);
        }
        if (DRIVER_INTERFACE_NAME.equals(resType)) {
            return new File(this.mappingsRoot, DRIVER_PROPERTIES);
        }
        return null;
    }

    private String getDatabaseVendorName(Properties classNameProperties, String className) {
        Set<String> vendors = classNameProperties.stringPropertyNames();
        for (String vendor : vendors) {
            String value = classNameProperties.getProperty(vendor);
            if (!className.equalsIgnoreCase(value)) continue;
            return vendor;
        }
        return null;
    }

    public static Properties loadFile(File mappingFile) {
        Properties fileProperties = new Properties();
        if (mappingFile == null || !mappingFile.exists()) {
            logger.fine(() -> "File not found: " + String.valueOf(mappingFile));
            return fileProperties;
        }
        try (FileInputStream fis = new FileInputStream(mappingFile);){
            fileProperties.load(fis);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "IO Exception during properties load: " + String.valueOf(mappingFile));
        }
        return fileProperties;
    }

    private String getImplClassNameFromMapping(String dbVendor, String resType) {
        File mappingFile = this.getResourceTypeFile(resType);
        Properties fileProperties = DriverLoader.loadFile(mappingFile);
        return fileProperties.getProperty(dbVendor.toUpperCase(Locale.getDefault()));
    }

    private String getEquivalentName(String dbVendor) {
        if (dbVendor.toUpperCase(Locale.getDefault()).startsWith(DATABASE_VENDOR_JAVADB) || dbVendor.equalsIgnoreCase(DATABASE_VENDOR_EMBEDDED_DERBY) || dbVendor.equalsIgnoreCase(DATABASE_VENDOR_EMBEDDED_DERBY_30) || dbVendor.equalsIgnoreCase(DATABASE_VENDOR_DERBY_30) || dbVendor.equalsIgnoreCase(DATABASE_VENDOR_JAVADB_30)) {
            return DATABASE_VENDOR_DERBY;
        }
        if (dbVendor.equalsIgnoreCase(DATABASE_VENDOR_MSSQLSERVER) || dbVendor.equalsIgnoreCase(DATABASE_VENDOR_SUN_SQLSERVER)) {
            return DATABASE_VENDOR_SQLSERVER;
        }
        if (dbVendor.equalsIgnoreCase(DATABASE_VENDOR_SUN_DB2)) {
            return DATABASE_VENDOR_DB2;
        }
        if (dbVendor.equalsIgnoreCase(DATABASE_VENDOR_SUN_ORACLE)) {
            return DATABASE_VENDOR_ORACLE;
        }
        if (dbVendor.equalsIgnoreCase(DATABASE_VENDOR_SUN_SYBASE)) {
            return DATABASE_VENDOR_SYBASE;
        }
        return null;
    }

    public Set<String> getJdbcDriverClassNames(String dbVendor, String resType) {
        return this.getJdbcDriverClassNames(dbVendor, resType, false);
    }

    public Set<String> getJdbcDriverClassNames(String dbVendor, String resType, boolean introspect) {
        String implClass;
        Set<Object> implClassNames = new TreeSet();
        TreeSet<String> allImplClassNames = new TreeSet<String>();
        String vendor = null;
        if (dbVendor != null && (vendor = this.getEquivalentName(dbVendor = dbVendor.trim().replaceAll(" ", ""))) == null) {
            vendor = dbVendor;
        }
        if (!introspect && (implClass = this.getImplClassNameFromMapping(dbVendor, resType)) != null) {
            allImplClassNames.add(implClass);
            return allImplClassNames;
        }
        List<File> jarFileLocations = this.getJdbcDriverLocations();
        HashSet<File> allJars = new HashSet<File>();
        for (File lib : jarFileLocations) {
            File[] files;
            if (!lib.isDirectory() || (files = lib.listFiles((dir, name) -> name.endsWith(".jar"))) == null) continue;
            for (File file : files) {
                allJars.add(file);
            }
        }
        for (File file : allJars) {
            if (!file.isFile()) continue;
            if (vendor != null) {
                implClassNames = this.introspectAndLoadJar(file, resType, vendor, dbVendor);
            }
            if (implClassNames.isEmpty()) continue;
            for (String className : implClassNames) {
                allImplClassNames.add(className);
            }
        }
        return allImplClassNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getImplClassesByIteration(File f, String resType, String dbVendor, String origDbVendor) {
        TreeSet<String> implClassNames = new TreeSet<String>();
        String implClass = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(f);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                if (jarEntry == null) continue;
                String entry = jarEntry.getName();
                if (DRIVER_INTERFACE_NAME.equals(resType) && SERVICES_DRIVER_IMPL_NAME.equals(entry)) {
                    InputStream metaInf = jarFile.getInputStream(jarEntry);
                    implClass = this.processMetaInf(metaInf);
                    if (implClass != null && this.isLoaded(implClass, resType) && this.isVendorSpecific(f, dbVendor, implClass, origDbVendor)) {
                        implClassNames.add(implClass);
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Driver loader : implClass = " + implClass);
                    }
                }
                if (!entry.endsWith(".class") || entry.toUpperCase(Locale.getDefault()).indexOf("DATASOURCE") == -1 && entry.toUpperCase(Locale.getDefault()).indexOf("DRIVER") == -1 || !this.isLoaded(implClass = this.getClassName(entry), resType) || !this.isVendorSpecific(f, dbVendor, implClass, origDbVendor)) continue;
                implClassNames.add(implClass);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Error while getting Jdbc driver classnames ", ex);
        }
        finally {
            block17: {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ex) {
                        if (!logger.isLoggable(Level.FINE)) break block17;
                        logger.log(Level.FINE, "Exception while closing JarFile '" + jarFile.getName() + "' :", ex);
                    }
                }
            }
        }
        return implClassNames;
    }

    private Set<String> introspectAndLoadJar(File f, String resType, String dbVendor, String origDbVendor) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("DriverLoader : introspectAndLoadJar ");
        }
        return this.getImplClassesByIteration(f, resType, dbVendor, origDbVendor);
    }

    private boolean isNotAbstract(Class cls) {
        int modifier = cls.getModifiers();
        return !Modifier.isAbstract(modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processMetaInf(InputStream metaInf) {
        String driverClassName = null;
        InputStreamReader reader = null;
        BufferedReader buffReader = null;
        try {
            String line;
            reader = new InputStreamReader(metaInf);
            buffReader = new BufferedReader(reader);
            while ((line = buffReader.readLine()) != null) {
                driverClassName = line;
            }
        }
        catch (IOException ioex) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("DriverLoader : exception while processing META-INF directory for DriverClassName " + String.valueOf(ioex));
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (buffReader != null) {
                            buffReader.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!logger.isLoggable(Level.FINE)) break block22;
                        logger.log(Level.FINE, "Error while closing File handles after reading META-INF files : ", ex);
                    }
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    if (!logger.isLoggable(Level.FINE)) break block23;
                    logger.log(Level.FINE, "Error while closing File handles after reading META-INF files : ", ex);
                }
            }
        }
        return driverClassName;
    }

    private boolean isLoaded(String classname, String resType) {
        Class cls = null;
        try {
            cls = ConnectorRuntime.getRuntime().getConnectorClassLoader().loadClass(classname);
        }
        catch (Exception ex) {
            cls = null;
        }
        catch (Throwable t) {
            cls = null;
        }
        return this.isResType(cls, resType);
    }

    private boolean isResType(Class cls, String resType) {
        boolean isResType = false;
        if (cls != null) {
            if ("javax.sql.DataSource".equals(resType)) {
                if (DataSource.class.isAssignableFrom(cls)) {
                    isResType = this.isNotAbstract(cls);
                }
            } else if ("javax.sql.ConnectionPoolDataSource".equals(resType)) {
                if (ConnectionPoolDataSource.class.isAssignableFrom(cls)) {
                    isResType = this.isNotAbstract(cls);
                }
            } else if ("javax.sql.XADataSource".equals(resType)) {
                if (XADataSource.class.isAssignableFrom(cls)) {
                    isResType = this.isNotAbstract(cls);
                }
            } else if (DRIVER_INTERFACE_NAME.equals(resType) && Driver.class.isAssignableFrom(cls)) {
                isResType = this.isNotAbstract(cls);
            }
        }
        return isResType;
    }

    private String getClassName(String classname) {
        classname = classname.replaceAll("/", ".");
        classname = classname.substring(0, classname.lastIndexOf(".class"));
        return classname;
    }

    private boolean isVendorSpecific(File f, String dbVendor, String className, String origDbVendor) {
        String vendor;
        boolean isVendorSpecific = false;
        if (origDbVendor != null) {
            if (origDbVendor.equalsIgnoreCase(DATABASE_VENDOR_EMBEDDED_DERBY)) {
                return className.toUpperCase(Locale.getDefault()).indexOf(DATABASE_VENDOR_EMBEDDED) != -1;
            }
            if (origDbVendor.equalsIgnoreCase(DATABASE_VENDOR_EMBEDDED_DERBY_30) && className.toUpperCase(Locale.getDefault()).indexOf(DATABASE_VENDOR_EMBEDDED) != -1 && origDbVendor.endsWith(DATABASE_VENDOR_30)) {
                return !className.toUpperCase(Locale.getDefault()).endsWith(DATABASE_VENDOR_40);
            }
        }
        if ((vendor = this.getVendorFromManifest(f)) == null) {
            if (this.isVendorSpecific(dbVendor, className)) {
                isVendorSpecific = true;
            }
        } else if (vendor.equalsIgnoreCase(dbVendor) || vendor.toUpperCase(Locale.getDefault()).indexOf(dbVendor.toUpperCase(Locale.getDefault())) != -1) {
            isVendorSpecific = true;
        }
        if (isVendorSpecific && origDbVendor.endsWith(DATABASE_VENDOR_30)) {
            if (origDbVendor.equalsIgnoreCase(DATABASE_VENDOR_EMBEDDED_DERBY_30)) {
                return className.toUpperCase(Locale.getDefault()).indexOf(DATABASE_VENDOR_EMBEDDED) != -1;
            }
            return !className.toUpperCase(Locale.getDefault()).endsWith(DATABASE_VENDOR_40);
        }
        return isVendorSpecific;
    }

    private List<File> getJdbcDriverLocations() {
        File instanceRoot;
        File installRoot;
        ArrayList<File> jarFileLocations = new ArrayList<File>();
        File derby = this.getLocation("com.sun.aas.derbyRoot");
        if (derby != null) {
            jarFileLocations.add(derby);
        }
        if ((installRoot = this.getLocation("com.sun.aas.installRoot")) != null) {
            jarFileLocations.add(installRoot);
        }
        if ((instanceRoot = this.getLocation("com.sun.aas.instanceRoot")) != null) {
            jarFileLocations.add(instanceRoot);
        }
        return jarFileLocations;
    }

    private File getLocation(String property) {
        File directory = DriverLoader.getSystemPropertyAsFile(property);
        if (directory == null) {
            return null;
        }
        return new File(directory, "lib");
    }

    private static File getSystemPropertyAsFile(String property) {
        String propertyValue = System.getProperty(property);
        if (propertyValue == null || propertyValue.isBlank()) {
            return null;
        }
        File file = new File(propertyValue);
        return file.exists() ? file : null;
    }

    private boolean isVendorSpecific(String dbVendor, String className) {
        return className.toUpperCase(Locale.getDefault()).indexOf(dbVendor.toUpperCase(Locale.getDefault())) != -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getVendorFromManifest(File f) {
        try (JarFile jarFile = new JarFile(f);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                String string = null;
                return string;
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            if (mainAttributes == null) {
                String string = null;
                return string;
            }
            String string = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            return string;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception while reading manifest file : ", ex);
            return null;
        }
    }
}

