/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.EjbApplicationExceptionInfo;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.MethodPermissionDescriptor;
import com.sun.enterprise.deployment.node.AbstractBundleNode;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MessageDestinationNode;
import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.node.SecurityRoleNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbMessageBeanDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationshipDescriptor;
import org.glassfish.ejb.deployment.node.ContainerTransactionNode;
import org.glassfish.ejb.deployment.node.EjbApplicationExceptionNode;
import org.glassfish.ejb.deployment.node.EjbEntityNode;
import org.glassfish.ejb.deployment.node.EjbInterceptorNode;
import org.glassfish.ejb.deployment.node.EjbNode;
import org.glassfish.ejb.deployment.node.EjbSessionNode;
import org.glassfish.ejb.deployment.node.ExcludeListNode;
import org.glassfish.ejb.deployment.node.InterceptorBindingNode;
import org.glassfish.ejb.deployment.node.MessageDrivenBeanNode;
import org.glassfish.ejb.deployment.node.MethodPermissionNode;
import org.glassfish.ejb.deployment.node.RelationshipsNode;
import org.glassfish.ejb.deployment.node.runtime.EjbBundleRuntimeNode;
import org.glassfish.ejb.deployment.node.runtime.GFEjbBundleRuntimeNode;
import org.glassfish.security.common.Role;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Service
public class EjbBundleNode
extends AbstractBundleNode<EjbBundleDescriptorImpl> {
    private static final XMLElement tag = new XMLElement("ejb-jar");
    private static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    private static final String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    private static final String SYSTEM_ID = "http://java.sun.com/dtd/ejb-jar_2_0.dtd";
    private static final String SYSTEM_ID_12 = "http://java.sun.com/dtd/ejb-jar_1_1.dtd";
    private static final String SCHEMA_ID_21 = "ejb-jar_2_1.xsd";
    private static final String SCHEMA_ID_30 = "ejb-jar_3_0.xsd";
    private static final String SCHEMA_ID_31 = "ejb-jar_3_1.xsd";
    private static final String SCHEMA_ID_32 = "ejb-jar_3_2.xsd";
    private static final String SCHEMA_ID = "ejb-jar_4_0.xsd";
    public static final String SPEC_VERSION = "4.0";
    private static final List<String> SYSTEM_IDS = List.of("ejb-jar_4_0.xsd", "ejb-jar_3_2.xsd", "ejb-jar_3_1.xsd", "ejb-jar_3_0.xsd", "ejb-jar_2_1.xsd");
    private EjbBundleDescriptorImpl descriptor;

    public String registerBundle(Map<String, String> publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_12, SYSTEM_ID_12);
        return tag.getQName();
    }

    public Map<String, Class<?>> registerRuntimeBundle(Map<String, String> publicIDToDTD, Map<String, List<Class<?>>> versionUpgrades) {
        HashMap result = new HashMap();
        result.put(EjbBundleRuntimeNode.registerBundle(publicIDToDTD), EjbBundleRuntimeNode.class);
        result.put(GFEjbBundleRuntimeNode.registerBundle(publicIDToDTD), GFEjbBundleRuntimeNode.class);
        return result;
    }

    public EjbBundleNode() {
        this.registerElementHandler(new XMLElement("session"), EjbSessionNode.class);
        this.registerElementHandler(new XMLElement("entity"), EjbEntityNode.class);
        this.registerElementHandler(new XMLElement("message-driven"), MessageDrivenBeanNode.class);
        this.registerElementHandler(new XMLElement("method-permission"), MethodPermissionNode.class);
        this.registerElementHandler(new XMLElement("security-role"), SecurityRoleNode.class, "addRole");
        this.registerElementHandler(new XMLElement("container-transaction"), ContainerTransactionNode.class);
        this.registerElementHandler(new XMLElement("exclude-list"), ExcludeListNode.class);
        this.registerElementHandler(new XMLElement("relationships"), RelationshipsNode.class);
        this.registerElementHandler(new XMLElement("message-destination"), MessageDestinationNode.class, "addMessageDestination");
        this.registerElementHandler(new XMLElement("application-exception"), EjbApplicationExceptionNode.class, "addApplicationException");
        this.registerElementHandler(new XMLElement("interceptor"), EjbInterceptorNode.class, "addInterceptor");
        this.registerElementHandler(new XMLElement("interceptor-binding"), InterceptorBindingNode.class, "appendInterceptorBinding");
        SaxParserHandler.registerBundleNode((BundleNode)this, (String)"ejb-jar");
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbDescriptor) {
            this.descriptor.addEjb((com.sun.enterprise.deployment.EjbDescriptor)((EjbDescriptor)((Object)newDescriptor)));
        } else if (newDescriptor instanceof RelationshipDescriptor) {
            this.descriptor.addRelationship((RelationshipDescriptor)((Object)newDescriptor));
        } else if (newDescriptor instanceof MethodPermissionDescriptor) {
            MethodDescriptor[] array;
            MethodPermissionDescriptor nd = (MethodPermissionDescriptor)newDescriptor;
            for (MethodDescriptor element : array = nd.getMethods()) {
                MethodPermission[] mps;
                EjbDescriptor target = this.descriptor.getEjbByName(element.getEjbName());
                for (MethodPermission mp : mps = nd.getMethodPermissions()) {
                    DOLUtils.getDefaultLogger().fine("Adding mp " + mp + " to " + element + " for ejb " + element.getEjbName());
                    target.addPermissionedMethod(mp, element);
                }
            }
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    public void setElementValue(XMLElement element, String value) {
        if ("module-name".equals(element.getQName())) {
            EjbBundleDescriptorImpl bundleDesc = this.getDescriptor();
            if (bundleDesc.getModuleDescriptor().getDescriptor() instanceof EjbBundleDescriptorImpl) {
                bundleDesc.getModuleDescriptor().setModuleName(value);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public EjbBundleDescriptorImpl getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new EjbBundleDescriptorImpl();
        }
        return this.descriptor;
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    protected Map<String, String> getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("ejb-client-jar", "setEjbClientJarUri");
        return table;
    }

    public Node writeDescriptor(Node parent, EjbBundleDescriptorImpl ejbDesc) {
        Node jarNode = super.writeDescriptor(parent, (RootDeploymentDescriptor)ejbDesc);
        Element entrepriseBeansNode = EjbBundleNode.appendChild((Node)jarNode, (String)"enterprise-beans");
        for (EjbDescriptor ejb : ejbDesc.getEjbs()) {
            EjbNode subNode;
            if ("Session".equals(ejb.getType())) {
                subNode = new EjbSessionNode();
                ((EjbSessionNode)subNode).writeDescriptor(entrepriseBeansNode, "session", (EjbSessionDescriptor)ejb);
                continue;
            }
            if ("Entity".equals(ejb.getType())) {
                subNode = new EjbEntityNode();
                ((EjbEntityNode)subNode).writeDescriptor(entrepriseBeansNode, "entity", (EjbEntityDescriptor)ejb);
                continue;
            }
            if ("Message-driven".equals(ejb.getType())) {
                subNode = new MessageDrivenBeanNode();
                ((MessageDrivenBeanNode)subNode).writeDescriptor(entrepriseBeansNode, "message-driven", (EjbMessageBeanDescriptor)ejb);
                continue;
            }
            throw new IllegalStateException("Unknow ejb type " + ejb.getType());
        }
        Set interceptors = ejbDesc.getInterceptors();
        if (!interceptors.isEmpty()) {
            Element interceptorsNode = EjbBundleNode.appendChild((Node)jarNode, (String)"interceptors");
            EjbInterceptorNode interceptorNode = new EjbInterceptorNode();
            for (EjbInterceptor next : interceptors) {
                interceptorNode.writeDescriptor((Node)interceptorsNode, "interceptor", next);
            }
        }
        if (ejbDesc.hasRelationships()) {
            RelationshipsNode.writeRelationships(jarNode, "relationships", ejbDesc);
        }
        this.writeAssemblyDescriptor(jarNode, ejbDesc);
        EjbBundleNode.appendTextChild((Node)jarNode, (String)"ejb-client-jar", (String)ejbDesc.getEjbClientJarUri());
        return jarNode;
    }

    public String getDocType() {
        return null;
    }

    public String getSystemID() {
        return SCHEMA_ID;
    }

    public List<String> getSystemIDs() {
        return SYSTEM_IDS;
    }

    public String getSpecVersion() {
        return SPEC_VERSION;
    }

    private void writeAssemblyDescriptor(Node parentNode, EjbBundleDescriptorImpl bundleDescriptor) {
        Element assemblyNode = parentNode.getOwnerDocument().createElement("assembly-descriptor");
        SecurityRoleNode roleNode = new SecurityRoleNode();
        for (Object element : bundleDescriptor.getRoles()) {
            roleNode.writeDescriptor((Node)assemblyNode, "security-role", (Role)element);
        }
        HashMap<Object, Vector<MethodDescriptor>> excludedMethodsByEjb = new HashMap<Object, Vector<MethodDescriptor>>();
        MethodPermissionNode mpNode = new MethodPermissionNode();
        for (Object ejbDesc : bundleDescriptor.getEjbs()) {
            if (ejbDesc instanceof EjbMessageBeanDescriptor) continue;
            Vector<MethodDescriptor> excludedMethods = new Vector<MethodDescriptor>();
            this.addMethodPermissions((EjbDescriptor)((Object)ejbDesc), ejbDesc.getPermissionedMethodsByPermission(), excludedMethods, mpNode, assemblyNode);
            this.addMethodPermissions((EjbDescriptor)((Object)ejbDesc), ejbDesc.getStyledPermissionedMethodsByPermission(), excludedMethods, mpNode, assemblyNode);
            if (excludedMethods.isEmpty()) continue;
            excludedMethodsByEjb.put(ejbDesc, excludedMethods);
        }
        for (Object ejbDesc : bundleDescriptor.getEjbs()) {
            ContainerTransactionNode.writeContainerTransactions(assemblyNode, "container-transaction", ejbDesc.getName(), ejbDesc.getMethodContainerTransactions());
        }
        InterceptorBindingNode ibNode = new InterceptorBindingNode();
        for (Object ejbDesc : bundleDescriptor.getEjbs()) {
            if (ejbDesc.getInterceptorClasses().isEmpty()) continue;
            ibNode.writeBindings(assemblyNode, (EjbDescriptor)((Object)ejbDesc));
        }
        this.writeMessageDestinations(assemblyNode, bundleDescriptor.getMessageDestinations().iterator());
        if (!excludedMethodsByEjb.isEmpty()) {
            Element excludeListNode = DeploymentDescriptorNode.appendChild((Node)assemblyNode, (String)"exclude-list");
            for (Map.Entry entry : excludedMethodsByEjb.entrySet()) {
                EjbDescriptor ejbDesc = (EjbDescriptor)((Object)entry.getKey());
                Vector excludedMethods = (Vector)entry.getValue();
                MethodPermissionDescriptor mpd = new MethodPermissionDescriptor();
                mpd.addMethodPermission(MethodPermission.getDenyAllMethodPermission());
                mpd.addMethods((Collection)excludedMethods);
                mpNode.writeDescriptorInNode(excludeListNode, mpd, (com.sun.enterprise.deployment.EjbDescriptor)ejbDesc);
            }
        }
        for (EjbApplicationExceptionInfo next : bundleDescriptor.getApplicationExceptions().values()) {
            EjbApplicationExceptionNode ejbApplicationExceptionNode = new EjbApplicationExceptionNode();
            ejbApplicationExceptionNode.writeDescriptor((Node)assemblyNode, "application-exception", next);
        }
        if (assemblyNode.hasChildNodes()) {
            parentNode.appendChild(assemblyNode);
        }
    }

    private void addMethodPermissions(EjbDescriptor ejb, Map<MethodPermission, Set<MethodDescriptor>> mpToMethods, Vector<MethodDescriptor> excludedMethods, MethodPermissionNode mpNode, Node assemblyNode) {
        if (mpToMethods == null || mpToMethods.isEmpty()) {
            return;
        }
        for (Map.Entry<MethodPermission, Set<MethodDescriptor>> entry : mpToMethods.entrySet()) {
            MethodPermission mp = entry.getKey();
            if (mp.isExcluded()) {
                Set<MethodDescriptor> methods = entry.getValue();
                excludedMethods.addAll(methods);
                continue;
            }
            MethodPermissionDescriptor mpd = new MethodPermissionDescriptor();
            mpd.addMethodPermission(mp);
            mpd.addMethods((Collection)mpToMethods.get(mp));
            mpNode.writeDescriptor(assemblyNode, "method-permission", mpd, (com.sun.enterprise.deployment.EjbDescriptor)ejb);
        }
    }
}

