/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBs;
import java.util.ArrayList;
import java.util.logging.Level;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.EJBHandler;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=EJBs.class)
public class EJBsHandler
extends EJBHandler {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(EJBsHandler.class);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        EJBs ejbsAnnotation = (EJBs)ainfo.getAnnotation();
        EJB[] ejbAnnotations = ejbsAnnotation.value();
        if (ejbAnnotations.length == 0) {
            String localizedMsg = I18N.getLocalString("enterprise.deployment.annotation.handlers.emptyEJBs", "No @EJB elements in @EJBs on " + ainfo.getAnnotatedElement(), new Object[]{ejbsAnnotation, ainfo.getAnnotatedElement()});
            logger.log(Level.WARNING, localizedMsg);
        }
        ArrayList<HandlerProcessingResult> results = new ArrayList<HandlerProcessingResult>();
        for (EJB ejb : ejbAnnotations) {
            results.add(this.processEJB(ainfo, rcContexts, ejb));
        }
        return this.getOverallProcessingResult(results);
    }
}

