/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.GeneratorException;
import org.glassfish.admin.rest.generator.ResourcesGeneratorBase;
import org.glassfish.admin.rest.generator.TextClassWriter;
import org.glassfish.hk2.api.ServiceLocator;

public class TextResourcesGenerator
extends ResourcesGeneratorBase {
    private final File generationDir;

    public TextResourcesGenerator(String outputDir, ServiceLocator habitat) {
        super(habitat);
        this.generationDir = new File(outputDir);
        if (!this.generationDir.mkdirs()) {
            throw new RuntimeException("Unable to create output directory: " + outputDir);
        }
    }

    @Override
    public ClassWriter getClassWriter(String className, String baseClassName, String resourcePath) {
        TextClassWriter writer = null;
        try {
            writer = new TextClassWriter(this.habitat, this.generationDir, className, baseClassName, resourcePath);
        }
        catch (IOException e) {
            RestLogging.restLogger.log(Level.SEVERE, e.getMessage());
            throw new GeneratorException(e);
        }
        return writer;
    }

    @Override
    public String endGeneration() {
        Properties properties = new Properties(1);
        properties.setProperty("generation_date", new Date().toString());
        File file = new File(this.generationDir, "codegeneration.properties");
        try (FileOutputStream out = new FileOutputStream(file);){
            properties.store(out, null);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to generate " + file, e);
        }
        return "Code Generation done at : " + this.generationDir;
    }

    @Override
    protected boolean alreadyGenerated(String className) {
        return false;
    }
}

