/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page;

import jakarta.data.page.PageRequest;
import java.util.Optional;

record Pagination(long page, int size, PageRequest.Mode mode, PageRequest.Cursor type, boolean requestTotal) implements PageRequest
{
    Pagination {
        if (page < 1L) {
            throw new IllegalArgumentException("pageNumber: " + page);
        }
        if (size < 1) {
            throw new IllegalArgumentException("maxPageSize: " + size);
        }
        if (mode != PageRequest.Mode.OFFSET && (type == null || type.size() == 0)) {
            throw new IllegalArgumentException("No key values were provided.");
        }
    }

    @Override
    public PageRequest withoutTotal() {
        return new Pagination(this.page, this.size, this.mode, this.type, false);
    }

    @Override
    public PageRequest withTotal() {
        return new Pagination(this.page, this.size, this.mode, this.type, true);
    }

    @Override
    public PageRequest afterCursor(PageRequest.Cursor cursor) {
        return new Pagination(this.page, this.size, PageRequest.Mode.CURSOR_NEXT, cursor, this.requestTotal);
    }

    @Override
    public PageRequest beforeCursor(PageRequest.Cursor cursor) {
        return new Pagination(this.page, this.size, PageRequest.Mode.CURSOR_PREVIOUS, cursor, this.requestTotal);
    }

    @Override
    public Optional<PageRequest.Cursor> cursor() {
        return Optional.ofNullable(this.type);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.mode == PageRequest.Mode.OFFSET ? 100 : 150).append("PageRequest{page=").append(this.page).append(", size=").append(this.size).append(", mode=").append((Object)this.mode);
        if (this.type != null) {
            s.append(", cursor size=").append(this.type.size());
        }
        return s.append("}").toString();
    }

    @Override
    public PageRequest size(int maxPageSize) {
        return new Pagination(this.page, maxPageSize, this.mode, this.type, this.requestTotal);
    }
}

