/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.MQMessageConsumer;
import com.sun.messaging.jmq.jmsservice.Consumer;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSAck;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jms.ra.DirectSession;
import com.sun.messaging.jms.ra.TemporaryDestination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.logging.Logger;
import lombok.Generated;

public class DirectConsumer
implements MQMessageConsumer,
QueueReceiver,
TopicSubscriber,
Consumer {
    private JMSService jmsservice;
    private DirectSession ds;
    private long connectionId;
    private long sessionId;
    private long consumerId = 0L;
    private jakarta.jms.Destination destination;
    private String msgSelector;
    private String durableName;
    private String clientId;
    private MessageListener msgListener;
    private boolean noLocal;
    private boolean isClosed;
    SysMessageID lastMessageSeen;
    boolean lastMessageSeenInTransaction = false;
    private static final String _className = "com.sun.messaging.jms.ra.DirectConsumer";
    private static final String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final String _lgrNameJMSConsumer = "jakarta.jms.MessageConsumer.mqjmsra";
    private static final Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final Logger _loggerJMC = Logger.getLogger("jakarta.jms.MessageConsumer.mqjmsra");
    private static final String _lgrMIDPrefix = "MQJMSRA_DP";
    private static final String _lgrMID_INF = "MQJMSRA_DP1101: ";
    private static final String _lgrMID_WRN = "MQJMSRA_DP2001: ";
    private static final String _lgrMID_EXC = "MQJMSRA_DP4001: ";

    public DirectConsumer(DirectSession ds, JMSService jmsservice, jakarta.jms.Destination destination, Destination jmsservice_dest, boolean noLocal, String msgSelector, String durableName) {
        Object[] params = new Object[]{ds, jmsservice, destination, jmsservice_dest, noLocal, msgSelector, durableName};
        _loggerOC.entering(_className, "constructor()", params);
        this.ds = ds;
        this.jmsservice = jmsservice;
        this.destination = destination;
        this.connectionId = ds.getConnectionId();
        this.sessionId = ds.getSessionId();
        this.msgSelector = msgSelector;
        this.durableName = durableName;
        this.clientId = ds.getConnection()._getClientID();
        this.noLocal = noLocal;
    }

    protected void setLastMessageSeen(SysMessageID lastMessageSeen) {
        this.lastMessageSeen = lastMessageSeen;
        this.lastMessageSeenInTransaction = this.ds.getTransactedNoCheck();
    }

    public synchronized void close() throws JMSException {
        _loggerJMC.fine("MQJMSRA_DP1101: consumerId=" + this.consumerId + ":close()");
        if (this.isClosed) {
            return;
        }
        this.ds.removeConsumer(this);
        if (this.durableName != null) {
            this.ds.dc.removeDurableConsumer(this);
        }
        if (this.destination != null && this.destination instanceof TemporaryDestination) {
            this.ds.dc._decrementTemporaryDestinationUsage((TemporaryDestination)this.destination);
        }
        this._close();
    }

    public MessageListener getMessageListener() throws JMSException {
        this._checkIfClosed("getMessageListener()");
        return this.msgListener;
    }

    public String getMessageSelector() throws JMSException {
        this._checkIfClosed("getMessageSelector()");
        return this.msgSelector;
    }

    public Message receive() throws JMSException {
        String methodName = "receive()";
        this._checkIfClosed(methodName);
        return this.ds._fetchMessage(this, this.consumerId, 0L, methodName);
    }

    public Message receive(long timeout) throws JMSException {
        String methodName = "receive(timeout)";
        this._checkIfClosed(methodName);
        return this.ds._fetchMessage(this, this.consumerId, timeout, methodName);
    }

    public Message receiveNoWait() throws JMSException {
        String methodName = "receiveNoWait()";
        this._checkIfClosed(methodName);
        return this.ds._fetchMessage(this, this.consumerId, -1L, methodName);
    }

    @Override
    public <T> T receiveBody(Class<T> c) throws JMSException {
        String methodName = "receiveBody(Class<T> c)";
        this._checkIfClosed(methodName);
        return this.ds._fetchMessageBody(this, this.consumerId, 0L, c, methodName);
    }

    @Override
    public <T> T receiveBody(Class<T> c, long timeout) throws JMSException {
        String methodName = "receiveBody(Class<T> c, long timeout)";
        this._checkIfClosed(methodName);
        return this.ds._fetchMessageBody(this, this.consumerId, timeout, c, methodName);
    }

    @Override
    public <T> T receiveBodyNoWait(Class<T> c) throws JMSException {
        String methodName = "receiveBodyNoWait(Class<T> c)";
        this._checkIfClosed(methodName);
        return this.ds._fetchMessageBody(this, this.consumerId, -1L, c, methodName);
    }

    public void setMessageListener(MessageListener msgListener) throws JMSException {
        String methodName = "setMessageListener()";
        _loggerJMC.fine("MQJMSRA_DP1101: connectionId=" + this.connectionId + ":" + methodName + "=" + String.valueOf(msgListener));
        this._checkIfClosed(methodName);
        if (msgListener == null) {
            this.msgListener = null;
            this.ds._setAsync(false);
        } else {
            this.msgListener = msgListener;
            this.ds._setAsync(true);
        }
        try {
            this.jmsservice.setConsumerAsync(this.connectionId, this.sessionId, this.consumerId, msgListener == null ? null : this);
        }
        catch (JMSServiceException jse) {
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            String exerrmsg = "setMessageListener on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + ", sessionId:" + this.sessionId + ", consumerId:" + this.consumerId + " due to " + (String)(switch (status) {
                case JMSServiceReply.Status.NOT_FOUND -> "consumer not found.";
                default -> "unkown JMSService server error:" + jse.getMessage();
            });
            _loggerJMC.severe(exerrmsg);
            JMSException jmsse = new JMSException(exerrmsg);
            jmsse.initCause((Throwable)jse);
            throw jmsse;
        }
    }

    public Queue getQueue() throws JMSException {
        this._checkIfClosed("getQueue()");
        if (this.destination instanceof Queue) {
            return (Queue)this.destination;
        }
        String excMsg = "MQJMSRA_DP4001: getQueue():Invalid to Topic destination=" + String.valueOf(this.destination);
        _loggerJMC.warning(excMsg);
        throw new JMSException(excMsg);
    }

    public Topic getTopic() throws JMSException {
        this._checkIfClosed("getTopic()");
        if (this.destination instanceof Topic) {
            return (Topic)this.destination;
        }
        String excMsg = "MQJMSRA_DP4001: getTopic():Invalid to Queue destination=" + String.valueOf(this.destination);
        _loggerJMC.warning(excMsg);
        throw new JMSException(excMsg);
    }

    public boolean getNoLocal() throws JMSException {
        this._checkIfClosed("getNoLocal()");
        if (this.destination instanceof Queue) {
            String excMsg = "MQJMSRA_DP4001: getNoLocal():Invalid on Queue destination=" + String.valueOf(this.destination);
            _loggerJMC.warning(excMsg);
            throw new JMSException(excMsg);
        }
        return this.noLocal;
    }

    @Override
    public JMSAck deliver(JMSPacket jmsPacket) {
        return this.ds._deliverMessage(this.msgListener, jmsPacket, this.consumerId);
    }

    protected synchronized void _setConsumerId(long consumerId) {
        if (this.consumerId != 0L) {
            String wrnMsg = "MQJMSRA_DP2001: _setConsumerId():Attempt to reset Id of:" + this.consumerId + ":to:" + consumerId + ":Ignoring.";
            _loggerJMC.warning(wrnMsg);
        } else {
            this.consumerId = consumerId;
        }
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    private void _checkIfClosed(String methodname) throws JMSException {
        if (this.isClosed()) {
            String closedmsg = _lgrMID_EXC + methodname + "MessageConsumer is closed:Id=" + this.consumerId;
            _loggerJMC.warning(closedmsg);
            throw new IllegalStateException(closedmsg);
        }
    }

    protected synchronized void _close() throws JMSException {
        if (this.isClosed) {
            return;
        }
        try {
            this.jmsservice.deleteConsumer(this.connectionId, this.sessionId, this.consumerId, this.getLastMessageSeen(), this.isLastMessageSeenInTransaction(), null, this.clientId);
        }
        catch (JMSServiceException jmsse) {
            _loggerJMC.warning("MQJMSRA_DP2001: consumerId=" + this.consumerId + ":close():JMSService.deleteConsumer():JMSServiceException=" + jmsse.getMessage());
        }
        this.isClosed = true;
    }

    @Generated
    public long getConnectionId() {
        return this.connectionId;
    }

    @Generated
    public long getSessionId() {
        return this.sessionId;
    }

    @Generated
    public long getConsumerId() {
        return this.consumerId;
    }

    @Generated
    public String getDurableName() {
        return this.durableName;
    }

    @Generated
    private SysMessageID getLastMessageSeen() {
        return this.lastMessageSeen;
    }

    @Generated
    private boolean isLastMessageSeenInTransaction() {
        return this.lastMessageSeenInTransaction;
    }
}

