/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.invokable;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jboss.weld.invokable.CleanupActions;
import org.jboss.weld.invokable.ConfiguredLookup;
import org.jboss.weld.invokable.InvokerImpl;
import org.jboss.weld.invokable.LookupUtils;
import org.jboss.weld.invokable.MethodHandleUtils;
import org.jboss.weld.invokable.TargetMethod;
import org.jboss.weld.invokable.TransformerMetadata;
import org.jboss.weld.invokable.TransformerType;
import org.jboss.weld.invoke.WeldInvokerBuilder;
import org.jboss.weld.logging.InvokerLogger;
import org.jboss.weld.manager.BeanManagerImpl;

public abstract class AbstractInvokerBuilder<B, T>
implements WeldInvokerBuilder<T> {
    final AnnotatedType<B> beanClass;
    final TargetMethod method;
    boolean instanceLookup;
    boolean[] argLookup;
    TransformerMetadata instanceTransformer;
    TransformerMetadata[] argTransformers;
    TransformerMetadata returnValueTransformer;
    TransformerMetadata exceptionTransformer;
    TransformerMetadata invocationWrapper;
    final BeanManager beanManager;

    AbstractInvokerBuilder(AnnotatedType<B> beanClass, TargetMethod method, BeanManagerImpl beanManager) {
        this.beanClass = beanClass;
        this.method = method;
        this.argLookup = new boolean[method.getParameterCount()];
        this.argTransformers = new TransformerMetadata[method.getParameterCount()];
        this.beanManager = beanManager;
        beanManager.addInvoker(this);
    }

    @Override
    public WeldInvokerBuilder<T> withInstanceLookup() {
        this.instanceLookup = true;
        return this;
    }

    @Override
    public WeldInvokerBuilder<T> withArgumentLookup(int position) {
        if (position < 0 || position >= this.argLookup.length) {
            throw InvokerLogger.LOG.invalidArgumentPosition("argument lookup", position, this.argLookup.length);
        }
        this.argLookup[position] = true;
        return this;
    }

    @Override
    public WeldInvokerBuilder<T> withInstanceTransformer(Class<?> clazz, String methodName) {
        if (this.instanceTransformer != null) {
            throw InvokerLogger.LOG.settingTransformerRepeatedly("Instance");
        }
        this.instanceTransformer = new TransformerMetadata(clazz, methodName, TransformerType.INSTANCE);
        return this;
    }

    @Override
    public WeldInvokerBuilder<T> withArgumentTransformer(int position, Class<?> clazz, String methodName) {
        if (position < 0 || position >= this.argTransformers.length) {
            throw InvokerLogger.LOG.invalidArgumentPosition("argument transformer", position, this.argLookup.length);
        }
        if (this.argTransformers[position] != null) {
            throw InvokerLogger.LOG.settingTransformerRepeatedly("Argument");
        }
        this.argTransformers[position] = new TransformerMetadata(clazz, methodName, TransformerType.ARGUMENT);
        return this;
    }

    @Override
    public WeldInvokerBuilder<T> withReturnValueTransformer(Class<?> clazz, String methodName) {
        if (this.returnValueTransformer != null) {
            throw InvokerLogger.LOG.settingTransformerRepeatedly("Return value");
        }
        this.returnValueTransformer = new TransformerMetadata(clazz, methodName, TransformerType.RETURN_VALUE);
        return this;
    }

    @Override
    public WeldInvokerBuilder<T> withExceptionTransformer(Class<?> clazz, String methodName) {
        if (this.exceptionTransformer != null) {
            throw InvokerLogger.LOG.settingTransformerRepeatedly("Exception");
        }
        this.exceptionTransformer = new TransformerMetadata(clazz, methodName, TransformerType.EXCEPTION);
        return this;
    }

    @Override
    public WeldInvokerBuilder<T> withInvocationWrapper(Class<?> clazz, String methodName) {
        if (this.invocationWrapper != null) {
            throw InvokerLogger.LOG.settingTransformerRepeatedly("Invocation wrapper");
        }
        this.invocationWrapper = new TransformerMetadata(clazz, methodName, TransformerType.WRAPPER);
        return this;
    }

    private boolean requiresCleanup() {
        int i;
        boolean isStaticMethod = this.method.isStatic();
        if (this.instanceTransformer != null && !isStaticMethod) {
            return true;
        }
        for (i = 0; i < this.argTransformers.length; ++i) {
            if (this.argTransformers[i] == null) continue;
            return true;
        }
        if (this.instanceLookup && !isStaticMethod) {
            return true;
        }
        for (i = 0; i < this.argLookup.length; ++i) {
            if (!this.argLookup[i]) continue;
            return true;
        }
        return false;
    }

    InvokerImpl<B, ?> doBuild() {
        MethodHandle invoker;
        Class<B> reflectionBeanClass = this.beanClass.getJavaClass();
        Method reflectionMethod = this.method.getReflection();
        boolean isStaticMethod = this.method.isStatic();
        int instanceArguments = isStaticMethod ? 0 : 1;
        boolean requiresCleanup = this.requiresCleanup();
        MethodHandle mh = MethodHandleUtils.createMethodHandle(reflectionMethod);
        mh = mh.asFixedArity();
        if (this.instanceTransformer != null && !isStaticMethod) {
            MethodHandle instanceTransformerMethod = MethodHandleUtils.createMethodHandleFromTransformer(reflectionMethod, this.instanceTransformer, reflectionBeanClass);
            if (instanceTransformerMethod.type().parameterCount() == 1) {
                mh = MethodHandles.filterArguments(mh, 0, instanceTransformerMethod);
            } else if (instanceTransformerMethod.type().parameterCount() == 2) {
                instanceTransformerMethod = instanceTransformerMethod.asType(instanceTransformerMethod.type().changeParameterType(1, CleanupActions.class));
                mh = MethodHandles.collectArguments(mh, 0, instanceTransformerMethod);
                ++instanceArguments;
            } else {
                throw InvokerLogger.LOG.invalidTransformerMethod("instance", this.instanceTransformer);
            }
        }
        for (int i = this.argTransformers.length - 1; i >= 0; --i) {
            if (this.argTransformers[i] == null) continue;
            int position = instanceArguments + i;
            MethodHandle argTransformerMethod = MethodHandleUtils.createMethodHandleFromTransformer(reflectionMethod, this.argTransformers[i], reflectionMethod.getParameterTypes()[i]);
            if (argTransformerMethod.type().parameterCount() == 1) {
                mh = MethodHandles.filterArguments(mh, position, argTransformerMethod);
                continue;
            }
            if (argTransformerMethod.type().parameterCount() == 2) {
                argTransformerMethod = argTransformerMethod.asType(argTransformerMethod.type().changeParameterType(1, CleanupActions.class));
                mh = MethodHandles.collectArguments(mh, position, argTransformerMethod);
                continue;
            }
            throw InvokerLogger.LOG.invalidTransformerMethod("argument", this.argTransformers[i]);
        }
        if (this.returnValueTransformer != null) {
            MethodHandle returnValueTransformerMethod = MethodHandleUtils.createMethodHandleFromTransformer(reflectionMethod, this.returnValueTransformer, reflectionMethod.getReturnType());
            mh = MethodHandles.filterReturnValue(mh, returnValueTransformerMethod);
        }
        if (this.exceptionTransformer != null) {
            MethodHandle exceptionTransformerMethod = MethodHandleUtils.createMethodHandleFromTransformer(reflectionMethod, this.exceptionTransformer, Throwable.class);
            mh = MethodHandles.catchException(mh, Throwable.class, exceptionTransformerMethod);
        }
        if (requiresCleanup) {
            MethodType incomingType = MethodType.methodType(mh.type().returnType(), CleanupActions.class);
            for (Class<?> paramType : mh.type().parameterArray()) {
                if (paramType == CleanupActions.class) continue;
                incomingType = incomingType.appendParameterTypes(paramType);
            }
            int[] reordering = new int[mh.type().parameterCount()];
            int paramCounter = 1;
            for (int i = 0; i < reordering.length; ++i) {
                reordering[i] = mh.type().parameterType(i) == CleanupActions.class ? 0 : paramCounter++;
            }
            mh = MethodHandles.permuteArguments(mh, incomingType, reordering);
        }
        MethodType typeBeforeLookups = mh.type();
        int positionsBeforeArguments = 1;
        if (!isStaticMethod) {
            ++positionsBeforeArguments;
        }
        if (this.instanceLookup && !isStaticMethod) {
            TypeDescriptor.OfField parameterType = typeBeforeLookups.parameterType(1);
            Class<B> type = reflectionBeanClass;
            Annotation[] qualifiers = LookupUtils.extractQualifiers(this.beanClass.getAnnotations(), this.beanManager);
            MethodHandle instanceLookupMethod = MethodHandleUtils.LOOKUP;
            instanceLookupMethod = MethodHandles.insertArguments(instanceLookupMethod, 1, this.beanManager, type, qualifiers);
            instanceLookupMethod = instanceLookupMethod.asType(instanceLookupMethod.type().changeReturnType((Class<?>)parameterType));
            instanceLookupMethod = MethodHandles.dropArguments(instanceLookupMethod, 0, new Class[]{parameterType});
            mh = MethodHandles.collectArguments(mh, 1, instanceLookupMethod);
            ++positionsBeforeArguments;
        }
        for (int i = this.argLookup.length - 1; i >= 0; --i) {
            if (!this.argLookup[i]) continue;
            int position = positionsBeforeArguments + i;
            TypeDescriptor.OfField parameterType = typeBeforeLookups.parameterType(i + (isStaticMethod ? 1 : 2));
            Type type = reflectionMethod.getParameters()[i].getParameterizedType();
            Annotation[] qualifiers = LookupUtils.extractQualifiers(this.method.getParameterAnnotations(i), this.beanManager);
            MethodHandle argumentLookupMethod = MethodHandleUtils.LOOKUP;
            argumentLookupMethod = MethodHandles.insertArguments(argumentLookupMethod, 1, this.beanManager, type, qualifiers);
            argumentLookupMethod = argumentLookupMethod.asType(argumentLookupMethod.type().changeReturnType((Class<?>)parameterType));
            argumentLookupMethod = MethodHandles.dropArguments(argumentLookupMethod, 0, new Class[]{parameterType});
            mh = MethodHandles.collectArguments(mh, position, argumentLookupMethod);
        }
        if (requiresCleanup) {
            int[] reordering = new int[mh.type().parameterCount()];
            int paramCounter = 1;
            for (int i = 0; i < reordering.length; ++i) {
                reordering[i] = mh.type().parameterType(i) == CleanupActions.class ? 0 : paramCounter++;
            }
            mh = MethodHandles.permuteArguments(mh, typeBeforeLookups, reordering);
        }
        if (requiresCleanup) {
            MethodHandle cleanupMethod;
            MethodHandle methodHandle = cleanupMethod = mh.type().returnType() == Void.TYPE ? MethodHandleUtils.CLEANUP_FOR_VOID : MethodHandleUtils.CLEANUP_FOR_NONVOID;
            if (mh.type().returnType() != Void.TYPE) {
                cleanupMethod = cleanupMethod.asType(cleanupMethod.type().changeReturnType((Class<?>)mh.type().returnType()).changeParameterType(1, (Class<?>)mh.type().returnType()));
            }
            mh = MethodHandles.tryFinally(mh, cleanupMethod);
        }
        int leadingArgumentsToKeep = (requiresCleanup ? 1 : 0) + (isStaticMethod ? 0 : 1);
        if (isStaticMethod) {
            invoker = MethodHandles.spreadInvoker(mh.type(), leadingArgumentsToKeep);
            invoker = MethodHandles.insertArguments(invoker, 0, mh);
            mh = invoker = MethodHandles.dropArguments(invoker, requiresCleanup ? 1 : 0, new Class[]{Object.class});
        } else {
            invoker = MethodHandles.spreadInvoker(mh.type(), leadingArgumentsToKeep);
            mh = invoker = MethodHandles.insertArguments(invoker, 0, mh);
        }
        Class<?>[] parameterTypes = reflectionMethod.getParameterTypes();
        if (LookupUtils.hasPrimitiveArgLookup(parameterTypes, this.argLookup)) {
            MethodHandle replaceNulls = MethodHandleUtils.REPLACE_PRIMITIVE_LOOKUP_NULLS;
            replaceNulls = MethodHandles.insertArguments(replaceNulls, 1, parameterTypes, this.argLookup);
            mh = MethodHandles.filterArguments(mh, requiresCleanup ? 2 : 1, replaceNulls);
        }
        MethodHandle trimArgumentArray = MethodHandles.insertArguments(MethodHandleUtils.TRIM_ARRAY_TO_SIZE, 1, reflectionMethod.getParameterCount());
        mh = MethodHandles.filterArguments(mh, requiresCleanup ? 2 : 1, trimArgumentArray);
        if (requiresCleanup) {
            mh = MethodHandles.foldArguments(mh, MethodHandleUtils.CLEANUP_ACTIONS_CTOR);
        }
        if (this.invocationWrapper != null) {
            InvokerImpl invoker2 = new InvokerImpl(mh);
            MethodHandle invocationWrapperMethod = MethodHandleUtils.createMethodHandleFromTransformer(reflectionMethod, this.invocationWrapper, reflectionBeanClass);
            mh = MethodHandles.insertArguments(invocationWrapperMethod, 2, invoker2);
        }
        return new InvokerImpl(mh);
    }

    public AnnotatedType<B> getBeanClass() {
        return this.beanClass;
    }

    public TargetMethod getMethod() {
        return this.method;
    }

    public List<ConfiguredLookup> getConfiguredLookups() {
        ArrayList<ConfiguredLookup> result = new ArrayList<ConfiguredLookup>();
        if (this.instanceLookup) {
            result.add(new ConfiguredLookup(-1, this.beanClass.getJavaClass(), LookupUtils.extractQualifiers(this.beanClass.getAnnotations(), this.beanManager)));
        }
        for (int i = 0; i < this.argLookup.length; ++i) {
            if (!this.argLookup[i]) continue;
            result.add(new ConfiguredLookup(i, this.method.getParameterType(i), LookupUtils.extractQualifiers(this.method.getParameterAnnotations(i), this.beanManager)));
        }
        return result;
    }
}

