/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.enterprise.event.NotificationOptions;
import jakarta.enterprise.event.ObserverException;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.enterprise.inject.spi.ObserverMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.event.AsyncEventDeliveryStage;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.event.ResolvedObservers;
import org.jboss.weld.events.WeldNotificationOptions;
import org.jboss.weld.injection.ThreadLocalStack;
import org.jboss.weld.logging.EventLogger;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.reflection.Reflections;

public class ObserverNotifier {
    private static final RuntimeException NO_EXCEPTION_MARKER = new RuntimeException();
    private final TypeSafeObserverResolver resolver;
    private final SharedObjectCache sharedObjectCache;
    private final boolean strict;
    protected final CurrentEventMetadata currentEventMetadata;
    private final ComputingCache<Type, RuntimeException> eventTypeCheckCache;
    private final Executor asyncEventExecutor;
    private final ScheduledExecutorService timerExecutor;
    private final SecurityServices securityServices;
    private final LazyValueHolder<RequestContext> requestContextHolder;

    protected ObserverNotifier(String contextId, TypeSafeObserverResolver resolver, ServiceRegistry services, boolean strict) {
        this.resolver = resolver;
        this.sharedObjectCache = services.get(SharedObjectCache.class);
        this.strict = strict;
        this.currentEventMetadata = services.get(CurrentEventMetadata.class);
        this.eventTypeCheckCache = strict ? ComputingCacheBuilder.newBuilder().build(new EventTypeCheck()) : null;
        this.asyncEventExecutor = services.getOptional(ExecutorServices.class).map(e -> e.getTaskExecutor()).orElse(ForkJoinPool.commonPool());
        this.timerExecutor = services.getOptional(ExecutorServices.class).map(e -> e.getTimerExecutor()).orElse(null);
        this.securityServices = services.getRequired(SecurityServices.class);
        this.requestContextHolder = LazyValueHolder.forSupplier(() -> (RequestContext)Container.instance(contextId).deploymentManager().instance().select(RequestContext.class, UnboundLiteral.INSTANCE).get());
    }

    public <T> ResolvedObservers<T> resolveObserverMethods(Type eventType, Annotation ... qualifiers) {
        this.checkEventObjectType(eventType);
        return this.resolveObserverMethods(this.buildEventResolvable(eventType, qualifiers));
    }

    public <T> ResolvedObservers<T> resolveObserverMethods(Type eventType, Set<Annotation> qualifiers) {
        this.checkEventObjectType(eventType);
        return this.resolveObserverMethods(this.buildEventResolvable(eventType, qualifiers));
    }

    public <T> ResolvedObservers<T> resolveObserverMethods(Resolvable resolvable) {
        return (ResolvedObservers)Reflections.cast(this.resolver.resolve(resolvable, true));
    }

    public void fireEvent(Object event, EventMetadata metadata, Annotation ... qualifiers) {
        this.fireEvent(event.getClass(), event, metadata, qualifiers);
    }

    public void fireEvent(Type eventType, Object event, Annotation ... qualifiers) {
        this.fireEvent(eventType, event, (EventMetadata)null, qualifiers);
    }

    public void fireEvent(Type eventType, Object event, EventMetadata metadata, Annotation ... qualifiers) {
        this.checkEventObjectType(eventType);
        this.notify(this.resolveObserverMethods(this.buildEventResolvable(eventType, qualifiers)), event, metadata);
    }

    public void fireEvent(Object event, Resolvable resolvable) {
        this.checkEventObjectType(event);
        this.notify(this.resolveObserverMethods(resolvable), event, null);
    }

    protected Resolvable buildEventResolvable(Type eventType, Set<Annotation> qualifiers) {
        Set<Type> typeClosure = this.sharedObjectCache.getTypeClosureHolder(eventType).get();
        ResolvableBuilder resolvableBuilder = new ResolvableBuilder(this.resolver.getMetaAnnotationStore()).addTypes(typeClosure).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierUnchecked(QualifierInstance.ANY);
        if (qualifiers.isEmpty()) {
            resolvableBuilder.addQualifier(Default.Literal.INSTANCE);
        }
        return resolvableBuilder.create();
    }

    protected Resolvable buildEventResolvable(Type eventType, Annotation ... qualifiers) {
        return this.buildEventResolvable(eventType, Set.of(qualifiers));
    }

    public void clear() {
        this.resolver.clear();
        if (this.eventTypeCheckCache != null) {
            this.eventTypeCheckCache.clear();
        }
    }

    protected void checkEventObjectType(Object event) {
        this.checkEventObjectType(event.getClass());
    }

    public void checkEventObjectType(Type eventType) {
        RuntimeException exception;
        if (this.strict && (exception = this.eventTypeCheckCache.getValue(eventType)) != NO_EXCEPTION_MARKER) {
            throw exception;
        }
    }

    public <T> void notify(ResolvedObservers<T> observers, T event, EventMetadata metadata) {
        if (!observers.isMetadataRequired()) {
            metadata = null;
        }
        this.notifySyncObservers(observers.getImmediateSyncObservers(), event, metadata, ObserverExceptionHandler.IMMEDIATE_HANDLER);
        this.notifyTransactionObservers(observers.getTransactionObservers(), event, metadata, ObserverExceptionHandler.IMMEDIATE_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void notifySyncObservers(List<ObserverMethod<? super T>> observers, T event, EventMetadata metadata, ObserverExceptionHandler handler) {
        if (observers.isEmpty()) {
            return;
        }
        ThreadLocalStack.ThreadLocalStackReference<EventMetadata> stack = this.currentEventMetadata.pushIfNotNull(metadata);
        try {
            for (ObserverMethod<T> observerMethod : observers) {
                try {
                    Observers.notify(observerMethod, event, metadata);
                }
                catch (Throwable throwable) {
                    handler.handle(throwable);
                }
            }
        }
        finally {
            stack.pop();
        }
    }

    protected <T> void notifyTransactionObservers(List<ObserverMethod<? super T>> observers, T event, EventMetadata metadata, ObserverExceptionHandler handler) {
        this.notifySyncObservers(observers, event, metadata, ObserverExceptionHandler.IMMEDIATE_HANDLER);
    }

    public <T, U extends T> CompletionStage<U> notifyAsync(ResolvedObservers<T> observers, U event, EventMetadata metadata, NotificationOptions options) {
        if (!observers.isMetadataRequired()) {
            metadata = null;
        }
        return this.notifyAsyncObservers(observers.getAsyncObservers(), event, metadata, options.getExecutor(), options);
    }

    protected <T, U extends T> CompletionStage<U> notifyAsyncObservers(List<ObserverMethod<? super T>> observers, U event, EventMetadata metadata, Executor executor, NotificationOptions options) {
        CompletionStage<T> completableFuture;
        if (executor == null) {
            executor = this.asyncEventExecutor;
        }
        if (observers.isEmpty()) {
            return AsyncEventDeliveryStage.completed(event, executor);
        }
        WeldNotificationOptions.NotificationMode mode = this.initModeOption(options.get("weld.async.notification.mode"));
        Long timeout = this.initTimeoutOption(options.get("weld.async.notification.timeout"));
        Consumer<Runnable> securityContextActionConsumer = this.securityServices.getSecurityContextAssociator();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (observers.size() > 1 && WeldNotificationOptions.NotificationMode.PARALLEL.equals((Object)mode)) {
            CollectingExceptionHandler exceptionHandler = new CollectingExceptionHandler(new CopyOnWriteArrayList<Throwable>());
            ArrayList<CompletableFuture<T>> completableFutures = new ArrayList<CompletableFuture<T>>(observers.size());
            for (ObserverMethod<T> observerMethod : observers) {
                completableFutures.add(CompletableFuture.supplyAsync(this.createSupplier(tccl, securityContextActionConsumer, event, metadata, exceptionHandler, false, () -> this.notifyAsyncObserver(observer, event, metadata, exceptionHandler)), executor));
            }
            completableFuture = CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).thenApply(ignoredVoid -> {
                this.handleExceptions(exceptionHandler);
                return event;
            });
        } else {
            CollectingExceptionHandler exceptionHandler = new CollectingExceptionHandler();
            completableFuture = CompletableFuture.supplyAsync(this.createSupplier(tccl, securityContextActionConsumer, event, metadata, exceptionHandler, true, () -> {
                for (ObserverMethod observer : observers) {
                    this.notifyAsyncObserver(observer, event, metadata, exceptionHandler);
                }
            }), executor);
        }
        if (timeout != null) {
            completableFuture = CompletableFuture.anyOf(new CompletableFuture[]{completableFuture, this.startTimer(timeout)}).thenApply(ignoredObject -> event);
        }
        return new AsyncEventDeliveryStage<T>(completableFuture, executor);
    }

    private Long initTimeoutOption(Object timeoutOptionValue) {
        if (timeoutOptionValue != null) {
            if (this.timerExecutor == null) {
                throw EventLogger.LOG.noScheduledExecutorServicesProvided();
            }
            try {
                String inputValue = timeoutOptionValue.toString();
                return Long.parseLong(inputValue);
            }
            catch (NumberFormatException nfe) {
                throw EventLogger.LOG.invalidInputValueForTimeout(nfe);
            }
        }
        return null;
    }

    private WeldNotificationOptions.NotificationMode initModeOption(Object value) {
        if (value != null) {
            WeldNotificationOptions.NotificationMode mode = WeldNotificationOptions.NotificationMode.of(value);
            if (mode == null) {
                throw EventLogger.LOG.invalidNotificationMode(value);
            }
            return mode;
        }
        return null;
    }

    private <T> CompletableFuture<T> startTimer(Long timeout) {
        CompletableFuture timeoutFuture = new CompletableFuture();
        this.timerExecutor.schedule(() -> timeoutFuture.completeExceptionally(new TimeoutException()), (long)timeout, TimeUnit.MILLISECONDS);
        return timeoutFuture;
    }

    private <T, U extends T> void notifyAsyncObserver(ObserverMethod<? super T> observer, U event, EventMetadata metadata, ObserverExceptionHandler exceptionHandler) {
        try {
            Observers.notify(observer, event, metadata);
        }
        catch (Throwable e) {
            exceptionHandler.handle(e);
        }
    }

    private <T, U extends T> Supplier<T> createSupplier(ClassLoader threadContextClassLoader, Consumer<Runnable> securityContextActionConsumer, U event, EventMetadata metadata, ObserverExceptionHandler exceptionHandler, boolean handleExceptions, Runnable notifyAction) {
        return () -> {
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            ThreadLocalStack.ThreadLocalStackReference<EventMetadata> stack = this.currentEventMetadata.pushIfNotNull(metadata);
            RequestContext requestContext = this.requestContextHolder.get();
            securityContextActionConsumer.accept(() -> {
                try {
                    Thread.currentThread().setContextClassLoader(threadContextClassLoader);
                    requestContext.activate();
                    notifyAction.run();
                }
                finally {
                    stack.pop();
                    requestContext.invalidate();
                    requestContext.deactivate();
                    Thread.currentThread().setContextClassLoader(originalCl);
                }
            });
            if (handleExceptions) {
                this.handleExceptions(exceptionHandler);
            }
            return event;
        };
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="https://github.com/findbugsproject/findbugs/issues/79")
    private void handleExceptions(ObserverExceptionHandler handler) {
        List<Throwable> handledExceptions = handler.getHandledExceptions();
        if (!handledExceptions.isEmpty()) {
            CompletionException exception = null;
            exception = handledExceptions.size() == 1 ? new CompletionException(handledExceptions.get(0)) : new CompletionException(null);
            for (Throwable handledException : handledExceptions) {
                exception.addSuppressed(handledException);
            }
            throw exception;
        }
    }

    private static class EventTypeCheck
    implements Function<Type, RuntimeException> {
        private EventTypeCheck() {
        }

        @Override
        public RuntimeException apply(Type eventType) {
            Type resolvedType = Types.getCanonicalType(eventType);
            if (Types.containsTypeVariable(resolvedType)) {
                return UtilLogger.LOG.typeParameterNotAllowedInEventType(eventType);
            }
            Class resolvedClass = Reflections.getRawType(eventType);
            for (Class clazz : Observers.CONTAINER_LIFECYCLE_EVENT_CANONICAL_SUPERTYPES) {
                if (!clazz.isAssignableFrom(resolvedClass)) continue;
                return UtilLogger.LOG.eventTypeNotAllowed(eventType);
            }
            return NO_EXCEPTION_MARKER;
        }
    }

    protected static interface ObserverExceptionHandler {
        public static final ObserverExceptionHandler IMMEDIATE_HANDLER = throwable -> {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new ObserverException(throwable);
        };

        public void handle(Throwable var1);

        default public List<Throwable> getHandledExceptions() {
            return Collections.emptyList();
        }
    }

    static class CollectingExceptionHandler
    implements ObserverExceptionHandler {
        private List<Throwable> throwables;

        CollectingExceptionHandler() {
            this(new LinkedList<Throwable>());
        }

        CollectingExceptionHandler(List<Throwable> throwables) {
            this.throwables = throwables;
        }

        @Override
        public void handle(Throwable throwable) {
            this.throwables.add(throwable);
        }

        @Override
        public List<Throwable> getHandledExceptions() {
            return this.throwables;
        }
    }
}

