/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.ArrayData;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.CommaExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.NaryExpression;
import org.glassfish.rmic.tools.tree.Vset;

public class NewArrayExpression
extends NaryExpression {
    Expression init;

    public NewArrayExpression(long where, Expression right, Expression[] args) {
        super(41, where, Type.tError, right, args);
    }

    public NewArrayExpression(long where, Expression right, Expression[] args, Expression init) {
        this(where, right, args);
        this.init = init;
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        this.type = this.right.toType(env, ctx);
        boolean flag = this.init != null;
        for (int i = 0; i < this.args.length; ++i) {
            Expression dim = this.args[i];
            if (dim == null) {
                if (i == 0 && !flag) {
                    env.error(this.where, "array.dim.missing");
                }
                flag = true;
            } else {
                if (flag) {
                    env.error(dim.where, "invalid.array.dim");
                }
                vset = dim.checkValue(env, ctx, vset, exp);
                this.args[i] = this.convert(env, ctx, Type.tInt, dim);
            }
            this.type = Type.tArray(this.type);
        }
        if (this.init != null) {
            vset = this.init.checkInitializer(env, ctx, vset, this.type, exp);
            this.init = this.convert(env, ctx, this.type, this.init);
        }
        return vset;
    }

    @Override
    public Expression copyInline(Context ctx) {
        NewArrayExpression e = (NewArrayExpression)super.copyInline(ctx);
        if (this.init != null) {
            e.init = this.init.copyInline(ctx);
        }
        return e;
    }

    @Override
    public Expression inline(Environment env, Context ctx) {
        Expression e = null;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            e = e != null ? new CommaExpression(this.where, e, this.args[i]) : this.args[i];
        }
        if (this.init != null) {
            e = e != null ? new CommaExpression(this.where, e, this.init) : this.init;
        }
        return e != null ? e.inline(env, ctx) : null;
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        if (this.init != null) {
            return this.init.inlineValue(env, ctx);
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            this.args[i] = this.args[i].inlineValue(env, ctx);
        }
        return this;
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        int t = 0;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            this.args[i].codeValue(env, ctx, asm);
            ++t;
        }
        if (this.args.length > 1) {
            asm.add(this.where, 197, new ArrayData(this.type, t));
            return;
        }
        switch (this.type.getElementType().getTypeCode()) {
            case 0: {
                asm.add(this.where, 188, 4);
                break;
            }
            case 1: {
                asm.add(this.where, 188, 8);
                break;
            }
            case 3: {
                asm.add(this.where, 188, 9);
                break;
            }
            case 2: {
                asm.add(this.where, 188, 5);
                break;
            }
            case 4: {
                asm.add(this.where, 188, 10);
                break;
            }
            case 5: {
                asm.add(this.where, 188, 11);
                break;
            }
            case 6: {
                asm.add(this.where, 188, 6);
                break;
            }
            case 7: {
                asm.add(this.where, 188, 7);
                break;
            }
            case 9: {
                asm.add(this.where, 189, this.type.getElementType());
                break;
            }
            case 10: {
                asm.add(this.where, 189, env.getClassDeclaration(this.type.getElementType()));
                break;
            }
            default: {
                throw new CompilerError("codeValue");
            }
        }
    }
}

