/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.appclient;

import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.UsernamePasswordStore;
import com.sun.enterprise.security.appclient.integration.AppClientSecurityInfo;
import com.sun.enterprise.security.auth.login.LoginCallbackHandler;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.common.ClientSecurityContext;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.integration.AppClientSSL;
import com.sun.enterprise.security.ssl.SSLUtils;
import jakarta.inject.Inject;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.appclient.client.acc.config.MessageSecurityConfig;
import org.glassfish.appclient.client.acc.config.Security;
import org.glassfish.appclient.client.acc.config.Ssl;
import org.glassfish.appclient.client.acc.config.TargetServer;
import org.glassfish.enterprise.iiop.api.IIOPSSLUtil;
import org.glassfish.epicyro.config.factory.file.AuthConfigFileFactory;
import org.jvnet.hk2.annotations.Service;

@Service
public class AppClientSecurityInfoImpl
implements AppClientSecurityInfo {
    private static final System.Logger LOG = System.getLogger(AppClientSecurityInfoImpl.class.getName());
    private static final String DEFAULT_PARSER_CLASS = "com.sun.enterprise.security.appclient.ConfigXMLParser";
    private CallbackHandler callbackHandler;
    boolean isJWS;
    boolean useGUIAuth;
    private List<TargetServer> targetServers;
    private List<MessageSecurityConfig> msgSecConfigs;
    @Inject
    protected SSLUtils sslUtils;
    @Inject
    private SecurityServicesUtil securityServicesUtil;
    @Inject
    private Util util;
    @Inject
    private IIOPSSLUtil appClientSSLUtil;

    @Override
    public void initializeSecurity(List<TargetServer> tServers, List<MessageSecurityConfig> configs, CallbackHandler handler, String username, char[] password, boolean isJWS, boolean useGUIAuth) {
        this.isJWS = isJWS;
        this.useGUIAuth = useGUIAuth;
        this.callbackHandler = handler != null ? handler : new LoginCallbackHandler(useGUIAuth);
        this.targetServers = tServers;
        this.msgSecConfigs = configs;
        System.setProperty("config.parser", DEFAULT_PARSER_CLASS);
        this.util.setAppClientMsgSecConfigs(this.msgSecConfigs);
        try {
            String defaultFactory = java.security.Security.getProperty("authconfigprovider.factory");
            LOG.log(System.Logger.Level.DEBUG, "AuthConfigFactory obtained from java.security.Security.getProperty(\"authconfigprovider.factory\"): {0}", defaultFactory);
            if (defaultFactory == null) {
                java.security.Security.setProperty("authconfigprovider.factory", AuthConfigFileFactory.class.getName());
            }
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "SEC9001: ACC: Error in initializing Jakarta Authentication Default Factory", (Throwable)e);
        }
        this.setSSLData(this.getTargetServers());
        if (username != null || password != null) {
            UsernamePasswordStore.set((String)username, (char[])password);
        }
        this.securityServicesUtil.setCallbackHandler(this.callbackHandler);
        this.util.setCallbackHandler(this.callbackHandler);
    }

    @Override
    public int getCredentialEncoding(AppClientSecurityInfo.CredentialType type) {
        switch (type) {
            case USERNAME_PASSWORD: {
                return 1;
            }
            case CERTIFICATE: {
                return 2;
            }
            case ALL: {
                return 3;
            }
        }
        throw new RuntimeException("Unknown CredentialType");
    }

    @Override
    public Subject doClientLogin(AppClientSecurityInfo.CredentialType credType) {
        return LoginContextDriver.doClientLogin((int)this.getCredentialEncoding(credType), (CallbackHandler)this.callbackHandler);
    }

    private AppClientSSL convert(Ssl ssl) {
        AppClientSSL appSSL = new AppClientSSL();
        appSSL.setCertNickname(ssl.getCertNickname());
        appSSL.setSsl2Ciphers(ssl.getSsl2Ciphers());
        appSSL.setSsl2Enabled(ssl.isSsl2Enabled());
        appSSL.setSsl3Enabled(ssl.isSsl3Enabled());
        appSSL.setSsl3TlsCiphers(ssl.getSsl3TlsCiphers());
        appSSL.setTlsEnabled(ssl.isTlsEnabled());
        appSSL.setTlsRollbackEnabled(ssl.isTlsRollbackEnabled());
        return appSSL;
    }

    private void setSSLData(List<TargetServer> tServers) {
        try {
            TargetServer tServer = tServers.get(0);
            Security security = tServer.getSecurity();
            if (security == null) {
                LOG.log(System.Logger.Level.DEBUG, "No Security input set in ClientContainer.xml");
                return;
            }
            Ssl ssl = security.getSsl();
            if (ssl == null) {
                LOG.log(System.Logger.Level.DEBUG, "No SSL input set in ClientContainer.xml");
                return;
            }
            this.sslUtils.setAppclientSsl(this.convert(ssl));
            this.appClientSSLUtil.setAppClientSSL((Object)this.convert(ssl));
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.ERROR, "setSSLData failed.", (Throwable)ex);
        }
    }

    public List<TargetServer> getTargetServers() {
        return this.targetServers;
    }

    public List<MessageSecurityConfig> getMsgSecConfigs() {
        return this.msgSecConfigs;
    }

    @Override
    public void clearClientSecurityContext() {
        ClientSecurityContext.setCurrent(null);
    }

    @Override
    public boolean isLoginCancelled() {
        boolean isCancelled = false;
        if (this.callbackHandler instanceof LoginCallbackHandler) {
            isCancelled = ((LoginCallbackHandler)this.callbackHandler).getCancelStatus();
        }
        return isCancelled;
    }
}

