/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.PrincipalGroupFactory;
import com.sun.enterprise.security.SecurityContextProxy;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.auth.login.DistinguishedPrincipalCredential;
import com.sun.enterprise.security.common.AbstractSecurityContext;
import com.sun.enterprise.security.integration.AppServSecurityContext;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.UserNameAndPassword;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class SecurityContext
extends AbstractSecurityContext {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = SecurityLoggerInfo.getLogger();
    private static final ThreadLocal<Principal> sessionPrincipal = new ThreadLocal();
    private static InheritableThreadLocal<SecurityContext> currentSecurityContext = new InheritableThreadLocal();
    private static SecurityContext defaultSecurityContext = SecurityContext.generateDefaultSecurityContext();
    private boolean serverGeneratedSecurityContext;

    public SecurityContext(String userName, Subject subject) {
        Subject nonNullSubject = subject;
        if (nonNullSubject == null) {
            nonNullSubject = new Subject();
            _logger.warning("NCLS-SECURITY-05052");
        }
        this.initiator = new UserNameAndPassword(userName);
        nonNullSubject.getPrincipals().add(this.initiator);
        this.subject = nonNullSubject;
    }

    public SecurityContext(Subject subject) {
        Iterator<Principal> prinIter;
        DistinguishedPrincipalCredential distinguishedPrincipalCredential;
        if (subject == null) {
            subject = new Subject();
            _logger.warning("NCLS-SECURITY-05052");
        }
        this.subject = subject;
        Principal principal = null;
        for (Object object : subject.getPublicCredentials()) {
            if (!(object instanceof DistinguishedPrincipalCredential)) continue;
            distinguishedPrincipalCredential = (DistinguishedPrincipalCredential)object;
            principal = distinguishedPrincipalCredential.getPrincipal();
            break;
        }
        if (principal == null) {
            for (Principal principal2 : subject.getPrincipals()) {
                if (!(principal2 instanceof DistinguishedPrincipalCredential)) continue;
                distinguishedPrincipalCredential = (DistinguishedPrincipalCredential)((Object)principal2);
                principal = distinguishedPrincipalCredential.getPrincipal();
                break;
            }
        }
        if (principal == null && (prinIter = subject.getPrincipals().iterator()).hasNext()) {
            principal = prinIter.next();
        }
        this.initiator = principal;
        this.postConstruct();
    }

    private void initDefaultCallerPrincipal() {
        if (this.initiator == null) {
            this.initiator = SecurityContext.getDefaultCallerPrincipal();
        }
    }

    public SecurityContext(String userName, Subject subject, String realm) {
        PrincipalGroupFactory factory;
        Subject nonNullSubject = subject;
        if (nonNullSubject == null) {
            nonNullSubject = new Subject();
            _logger.warning("NCLS-SECURITY-05052");
        }
        if ((factory = (PrincipalGroupFactory)Globals.get(PrincipalGroupFactory.class)) != null) {
            this.initiator = factory.getPrincipalInstance(userName, realm);
        }
        nonNullSubject.getPrincipals().add(this.initiator);
        this.subject = nonNullSubject;
    }

    public SecurityContext() {
        _logger.log(Level.FINE, "Default CTOR of SecurityContext called");
        this.subject = new Subject();
        this.initiator = null;
        this.setServerGeneratedCredentials();
        this.subject.setReadOnly();
    }

    public static SecurityContext init() {
        SecurityContext securityContext = (SecurityContext)currentSecurityContext.get();
        if (securityContext == null) {
            securityContext = defaultSecurityContext;
        }
        return securityContext;
    }

    public static SecurityContext getDefaultSecurityContext() {
        return defaultSecurityContext;
    }

    public static Subject getDefaultSubject() {
        return SecurityContext.defaultSecurityContext.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Principal getDefaultCallerPrincipal() {
        Class<SecurityContext> clazz = SecurityContext.class;
        synchronized (SecurityContext.class) {
            SecurityService securityService;
            String guestUser;
            block9: {
                if (SecurityContext.defaultSecurityContext.initiator != null) return SecurityContext.defaultSecurityContext.initiator;
                guestUser = null;
                securityService = (SecurityService)SecurityServicesUtil.getInstance().getHabitat().getService(SecurityService.class, "default-instance-name", new Annotation[0]);
                if (securityService != null) break block9;
                Principal principal = null;
                if (guestUser != null) return principal;
                guestUser = "ANONYMOUS";
                // ** MonitorExit[var0] (shouldn't be in output)
                return principal;
            }
            try {
                try {
                    guestUser = securityService.getDefaultPrincipal();
                    if (guestUser == null) {
                        guestUser = "ANONYMOUS";
                    }
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "NCLS-SECURITY-05038", e);
                    if (guestUser == null) {
                        guestUser = "ANONYMOUS";
                    }
                }
            }
            catch (Throwable throwable) {
                if (guestUser != null) throw throwable;
                guestUser = "ANONYMOUS";
                throw throwable;
            }
            SecurityContext.defaultSecurityContext.initiator = new UserNameAndPassword(guestUser);
            // ** MonitorExit[var0] (shouldn't be in output)
            return SecurityContext.defaultSecurityContext.initiator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecurityContext generateDefaultSecurityContext() {
        Class<SecurityContext> clazz = SecurityContext.class;
        synchronized (SecurityContext.class) {
            try {
                // ** MonitorExit[var0] (shouldn't be in output)
                return new SecurityContext();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "NCLS-SECURITY-05036", e);
                // ** MonitorExit[var0] (shouldn't be in output)
            }
            return null;
        }
    }

    public static void reset(SecurityContext securityContext) {
        SecurityContext.setCurrent(securityContext);
    }

    public static SecurityContext getCurrent() {
        SecurityContext securityContext = (SecurityContext)currentSecurityContext.get();
        if (securityContext == null) {
            securityContext = defaultSecurityContext;
        }
        return securityContext;
    }

    public static void setCurrent(SecurityContext securityContext) {
        if (securityContext == null || securityContext == defaultSecurityContext) {
            currentSecurityContext.set(securityContext);
            return;
        }
        SecurityContext current = (SecurityContext)currentSecurityContext.get();
        if (securityContext == current) {
            return;
        }
        currentSecurityContext.set(securityContext);
    }

    public static void setUnauthenticatedContext() {
        _logger.entering(SecurityContext.class.getName(), "setCurrentSecurityContext");
        currentSecurityContext.set(defaultSecurityContext);
    }

    public boolean didServerGenerateCredentials() {
        return this.serverGeneratedSecurityContext;
    }

    private void setServerGeneratedCredentials() {
        this.serverGeneratedSecurityContext = true;
    }

    @Override
    public Principal getCallerPrincipal() {
        return this == defaultSecurityContext ? SecurityContext.getDefaultCallerPrincipal() : this.initiator;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "SecurityContext[Initiator: " + String.valueOf(this.initiator) + ", Subject " + String.valueOf(this.subject) + "]";
    }

    public Principal getSessionPrincipal() {
        return sessionPrincipal.get();
    }

    public void setSessionPrincipal(Principal sessionPrincipal) {
        if (sessionPrincipal != null) {
            SecurityContext.sessionPrincipal.set(sessionPrincipal);
        } else {
            SecurityContext.sessionPrincipal.remove();
        }
    }

    public Set<Principal> getPrincipalSet() {
        return this.subject.getPrincipals();
    }

    public void postConstruct() {
        this.initDefaultCallerPrincipal();
    }

    public AppServSecurityContext newInstance(String userName, Subject subject, String realm) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(this.getClass().getName(), "newInstance", new Object[]{userName, subject, realm});
        }
        return new SecurityContext(userName, subject, realm);
    }

    public AppServSecurityContext newInstance(String userName, Subject subject) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(this.getClass().getName(), "newInstance", new Object[]{userName, subject});
        }
        return new SecurityContext(userName, subject);
    }

    public void setCurrentSecurityContext(AppServSecurityContext context) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(this.getClass().getName(), "setCurrentSecurityContext", context);
        }
        if (context == null) {
            SecurityContext.setCurrent(null);
            return;
        }
        if (context instanceof SecurityContext) {
            SecurityContext.setCurrent((SecurityContext)context);
            return;
        }
        throw new IllegalArgumentException("Expected SecurityContext, found " + String.valueOf(context));
    }

    public AppServSecurityContext getCurrentSecurityContext() {
        return SecurityContext.getCurrent();
    }

    public void setUnauthenticatedSecurityContext() {
        SecurityContext.setUnauthenticatedContext();
    }

    public void setSecurityContextWithPrincipal(Principal principal) {
        SecurityContext ctx = this.getSecurityContextForPrincipal(principal);
        SecurityContext.setCurrent(ctx);
    }

    private SecurityContext getSecurityContextForPrincipal(Principal principal) {
        if (principal == null) {
            return null;
        }
        if (principal instanceof SecurityContextProxy) {
            SecurityContextProxy securityContextProxy = (SecurityContextProxy)((Object)principal);
            return securityContextProxy.getSecurityContext();
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(principal);
        return new SecurityContext(principal.getName(), subject);
    }
}

