/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.cdi;

import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.glassfish.soteria.cdi.CdiUtils;

public class DefaultIdentityStoreHandler
implements IdentityStoreHandler {
    private List<IdentityStore> authenticationIdentityStores;
    private List<IdentityStore> authorizationIdentityStores;

    public void init() {
        List<IdentityStore> identityStores = CdiUtils.getBeanReferencesByType(IdentityStore.class, false);
        this.authenticationIdentityStores = identityStores.stream().filter(i -> i.validationTypes().contains(IdentityStore.ValidationType.VALIDATE)).sorted(Comparator.comparing(IdentityStore::priority)).collect(Collectors.toList());
        this.authorizationIdentityStores = identityStores.stream().filter(i -> i.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS) && !i.validationTypes().contains(IdentityStore.ValidationType.VALIDATE)).sorted(Comparator.comparing(IdentityStore::priority)).collect(Collectors.toList());
    }

    public CredentialValidationResult validate(Credential credential) {
        CredentialValidationResult validationResult = null;
        IdentityStore identityStore = null;
        boolean isGotAnInvalidResult = false;
        for (IdentityStore authenticationIdentityStore : this.authenticationIdentityStores) {
            validationResult = authenticationIdentityStore.validate(credential);
            if (validationResult.getStatus() == CredentialValidationResult.Status.VALID) {
                identityStore = authenticationIdentityStore;
                break;
            }
            if (validationResult.getStatus() != CredentialValidationResult.Status.INVALID) continue;
            isGotAnInvalidResult = true;
        }
        if (validationResult == null || validationResult.getStatus() != CredentialValidationResult.Status.VALID) {
            if (isGotAnInvalidResult) {
                return CredentialValidationResult.INVALID_RESULT;
            }
            return CredentialValidationResult.NOT_VALIDATED_RESULT;
        }
        HashSet groups = new HashSet();
        if (identityStore.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) {
            groups.addAll(validationResult.getCallerGroups());
        }
        for (IdentityStore authorizationIdentityStore : this.authorizationIdentityStores) {
            groups.addAll(authorizationIdentityStore.getCallerGroups(validationResult));
        }
        return new CredentialValidationResult(validationResult.getIdentityStoreId(), validationResult.getCallerPrincipal(), validationResult.getCallerDn(), validationResult.getCallerUniqueId(), groups);
    }
}

