/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.cdi;

import jakarta.el.ELProcessor;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.el.ELAwareBeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.cdi.AnyAnnotationLiteral;

public class CdiUtils {
    public static <A extends Annotation> Optional<A> getAnnotation(BeanManager beanManager, Annotated annotated, Class<A> annotationType) {
        annotated.getAnnotation(annotationType);
        if (annotated.getAnnotations().isEmpty()) {
            return Optional.empty();
        }
        if (annotated.isAnnotationPresent(annotationType)) {
            return Optional.of(annotated.getAnnotation(annotationType));
        }
        LinkedList annotations = new LinkedList(annotated.getAnnotations());
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            if (annotation.annotationType().equals(annotationType)) {
                return Optional.of((Annotation)annotationType.cast(annotation));
            }
            if (!beanManager.isStereotype(annotation.annotationType())) continue;
            annotations.addAll(beanManager.getStereotypeDefinition(annotation.annotationType()));
        }
        return Optional.empty();
    }

    public static void addAnnotatedTypes(BeforeBeanDiscovery beforeBean, BeanManager beanManager, Class<?> ... types) {
        for (Class<?> type : types) {
            beforeBean.addAnnotatedType(beanManager.createAnnotatedType(type), "Soteria " + type.getName());
        }
    }

    public static <A extends Annotation> Optional<A> getAnnotation(BeanManager beanManager, Class<?> annotatedClass, Class<A> annotationType) {
        if (annotatedClass.isAnnotationPresent(annotationType)) {
            return Optional.of(annotatedClass.getAnnotation(annotationType));
        }
        LinkedList<Annotation> annotations = new LinkedList<Annotation>(Arrays.asList(annotatedClass.getAnnotations()));
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            if (annotation.annotationType().equals(annotationType)) {
                return Optional.of((Annotation)annotationType.cast(annotation));
            }
            if (!beanManager.isStereotype(annotation.annotationType())) continue;
            annotations.addAll(beanManager.getStereotypeDefinition(annotation.annotationType()));
        }
        return Optional.empty();
    }

    public static ELAwareBeanManager getBeanManager() throws IllegalStateException {
        try {
            return (ELAwareBeanManager)CdiUtils.jndiLookup("java:comp/BeanManager", "java:comp/env/BeanManager");
        }
        catch (NamingException e) {
            throw new IllegalStateException("The CDI Bean Manager is not available.", e);
        }
    }

    public static <T> T getBeanReference(Class<T> type, Annotation ... qualifiers) {
        return type.cast(CdiUtils.getBeanReferenceByType((BeanManager)CdiUtils.getBeanManager(), type, qualifiers));
    }

    public static <T> T getBeanReference(BeanManager beanManager, Class<T> type, Annotation ... qualifiers) {
        return type.cast(CdiUtils.getBeanReferenceByType(beanManager, type, qualifiers));
    }

    public static Object getBeanReferenceByType(BeanManager beanManager, Type type, Annotation ... qualifiers) {
        Object beanReference = null;
        Bean bean = beanManager.resolve(beanManager.getBeans(type, qualifiers));
        if (bean != null) {
            beanReference = beanManager.getReference(bean, type, beanManager.createCreationalContext((Contextual)bean));
        }
        return beanReference;
    }

    private static <T> T getContextualReference(Class<T> type, BeanManager beanManager, Set<Bean<?>> beans) {
        Object beanReference = null;
        Bean bean = beanManager.resolve(beans);
        if (bean != null) {
            beanReference = beanManager.getReference(bean, type, beanManager.createCreationalContext((Contextual)bean));
        }
        return (T)beanReference;
    }

    public static <T> List<T> getBeanReferencesByType(Class<T> type, boolean optional) {
        ELAwareBeanManager beanManager = CdiUtils.getBeanManager();
        Set<Bean<?>> beans = CdiUtils.getBeanDefinitions(type, optional, (BeanManager)beanManager);
        ArrayList<T> result = new ArrayList<T>(beans.size());
        for (Bean<?> bean : beans) {
            result.add(CdiUtils.getContextualReference(type, (BeanManager)beanManager, Collections.singleton(bean)));
        }
        return result;
    }

    public static <T> T getBeanReferenceByType(Class<T> type, boolean optional) {
        ELAwareBeanManager beanManager = CdiUtils.getBeanManager();
        return CdiUtils.getContextualReference(type, (BeanManager)beanManager, CdiUtils.getBeanDefinitions(type, optional, (BeanManager)beanManager));
    }

    public static ELProcessor getELProcessor(ELProcessor elProcessor) {
        if (elProcessor != null) {
            return elProcessor;
        }
        return CdiUtils.getELProcessor();
    }

    public static ELProcessor getELProcessor() {
        ELProcessor elProcessor = new ELProcessor();
        elProcessor.getELManager().addELResolver(CdiUtils.getBeanManager().getELResolver());
        return elProcessor;
    }

    private static <T> Set<Bean<?>> getBeanDefinitions(Class<T> type, boolean optional, BeanManager beanManager) {
        Set beans = beanManager.getBeans(type, new Annotation[]{new AnyAnnotationLiteral()});
        if (!Utils.isEmpty(beans)) {
            return beans;
        }
        if (optional) {
            return Collections.emptySet();
        }
        throw new IllegalStateException("Could not find beans for Type=" + type);
    }

    public static <T> T jndiLookup(String ... names) throws NamingException {
        InitialContext context = null;
        try {
            context = new InitialContext();
            NamingException exceptionCollector = new NamingException(String.join((CharSequence)", ", names));
            for (String name : names) {
                Object object;
                try {
                    Object found = context.lookup(name);
                    if (found == null) continue;
                    object = found;
                }
                catch (NamingException e) {
                    exceptionCollector.addSuppressed(e);
                }
                return (T)object;
            }
            throw exceptionCollector;
        }
        finally {
            CdiUtils.close(context);
        }
    }

    private static void close(InitialContext context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T extends Throwable> boolean is(Throwable exception, Class<T> type) {
        for (Throwable unwrappedException = exception; unwrappedException != null; unwrappedException = unwrappedException.getCause()) {
            if (!type.isInstance(unwrappedException)) continue;
            return true;
        }
        return false;
    }
}

