/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.ScopedRunner;
import com.sun.faces.util.Util;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectItem;
import jakarta.faces.component.UISelectItems;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SelectItemUtils {
    public static List<SelectItem> collectSelectItems(FacesContext context, UIComponent component) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UISelectItems) {
                SelectItemUtils.createSelectItems(context, child, ((UISelectItems)child).getValue(), SelectItem::new, items::add);
                continue;
            }
            if (!(child instanceof UISelectItem)) continue;
            items.add(SelectItemUtils.createSelectItem(child, null, SelectItem::new));
        }
        return items;
    }

    public static <S extends SelectItem> void createSelectItems(FacesContext context, UIComponent component, Object values, Supplier<S> supplier, Consumer<S> callback) {
        Map<String, Object> attributes = component.getAttributes();
        String var = Util.coalesce((String)attributes.get("var"), "item");
        Util.stream(values).forEach(value -> new ScopedRunner(context).with(var, value).invoke(() -> SelectItemUtils.lambda$createSelectItems$0(callback, component, attributes, value, (Supplier)supplier)));
    }

    public static <S extends SelectItem> S createSelectItem(UIComponent component, Object value, Supplier<S> supplier) {
        Map<String, Object> attributes = component.getAttributes();
        Object itemValue = SelectItemUtils.getItemValue(attributes, value);
        Object itemLabel = attributes.get("itemLabel");
        Object itemEscaped = Util.coalesce(attributes.get("itemEscaped"), attributes.get("itemLabelEscaped"));
        Object itemDisabled = attributes.get("itemDisabled");
        SelectItem selectItem = (SelectItem)supplier.get();
        selectItem.setValue(itemValue);
        selectItem.setLabel(String.valueOf(itemLabel != null ? itemLabel : selectItem.getValue()));
        selectItem.setEscape(itemEscaped == null || Boolean.parseBoolean(itemEscaped.toString()));
        selectItem.setDisabled(itemDisabled != null && Boolean.parseBoolean(itemDisabled.toString()));
        return (S)selectItem;
    }

    private static Object getItemValue(Map<String, Object> attributes, Object defaultValue) {
        Object itemValue = attributes.get("itemValue");
        return itemValue != null || attributes.containsKey("itemValue") ? itemValue : defaultValue;
    }

    private static /* synthetic */ void lambda$createSelectItems$0(Consumer callback, UIComponent component, Map attributes, Object value, Supplier supplier) {
        callback.accept(SelectItemUtils.createSelectItem(component, SelectItemUtils.getItemValue(attributes, value), supplier));
    }
}

