/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class ReturningPolicy
implements Serializable,
Cloneable {
    protected static final int INSERT = 0;
    protected static final int UPDATE = 1;
    protected static final int NUM_OPERATIONS = 2;
    protected static final int RETURN_ONLY = 0;
    protected static final int WRITE_RETURN = 1;
    protected static final int MAPPED = 2;
    protected static final int UNMAPPED = 3;
    protected static final int ALL = 4;
    protected static final int MAIN_SIZE = 5;
    protected ClassDescriptor descriptor;
    protected List<Info> infos = new ArrayList<Info>();
    protected Collection<DatabaseField>[][] main;
    protected Map<DatabaseTable, List<DatabaseField>>[] tableToFieldsForGenerationMap;
    protected boolean isUsedToSetPrimaryKey;
    protected Map<DatabaseField, DatabaseField> fieldsNotFromDescriptor_DefaultTable;
    protected Map<DatabaseField, DatabaseField> fieldsNotFromDescriptor_OtherTables;

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void fieldIsNotFromDescriptor(DatabaseField field) {
        if (field.getTable().equals(this.getDescriptor().getDefaultTable())) {
            if (this.fieldsNotFromDescriptor_DefaultTable == null) {
                this.fieldsNotFromDescriptor_DefaultTable = new HashMap<DatabaseField, DatabaseField>();
            }
            this.fieldsNotFromDescriptor_DefaultTable.put(field, field);
        } else {
            if (this.fieldsNotFromDescriptor_OtherTables == null) {
                this.fieldsNotFromDescriptor_OtherTables = new HashMap<DatabaseField, DatabaseField>();
            }
            this.fieldsNotFromDescriptor_OtherTables.put(field, field);
        }
    }

    public List<DatabaseField> getFieldsToGenerateInsert(DatabaseTable table) {
        return this.getVectorOfFieldsToGenerate(0, table);
    }

    public List<DatabaseField> getFieldsToGenerateUpdate(DatabaseTable table) {
        return this.getVectorOfFieldsToGenerate(1, table);
    }

    public List<Info> getFieldInfos() {
        return this.infos;
    }

    public void setFieldInfos(List<Info> infos) {
        this.infos = infos;
    }

    public boolean hasEqualFieldInfos(ReturningPolicy returningPolicyToCompare) {
        return this.hasEqualFieldInfos(returningPolicyToCompare.getFieldInfos());
    }

    public boolean hasEqualFieldInfos(List<Info> infosToCompare) {
        return ReturningPolicy.areCollectionsEqualAsSets(this.getFieldInfos(), infosToCompare);
    }

    public static boolean areCollectionsEqualAsSets(Collection<? extends Info> col1, Collection<? extends Info> col2) {
        if (col1 == col2) {
            return true;
        }
        if (col1.size() != col2.size()) {
            return false;
        }
        ArrayList<? extends Info> c1 = new ArrayList<Info>(col1);
        ArrayList<? extends Info> c2 = new ArrayList<Info>(col2);
        for (Info info : c1) {
            c2.remove(info);
        }
        return c2.isEmpty();
    }

    protected List<DatabaseField> getVectorOfFieldsToGenerate(int operation, DatabaseTable table) {
        List<DatabaseField> fieldsForGeneration;
        if (this.main[operation][4] == null) {
            return null;
        }
        if (this.tableToFieldsForGenerationMap == null) {
            this.tableToFieldsForGenerationMap = new HashMap[2];
        }
        if (this.tableToFieldsForGenerationMap[operation] == null) {
            this.tableToFieldsForGenerationMap[operation] = new HashMap<DatabaseTable, List<DatabaseField>>();
        }
        if ((fieldsForGeneration = this.tableToFieldsForGenerationMap[operation].get(table)) == null) {
            fieldsForGeneration = new ArrayList<DatabaseField>();
            for (DatabaseField field : this.main[operation][4]) {
                if (!field.getTable().equals(table)) continue;
                fieldsForGeneration.add(field);
            }
            this.tableToFieldsForGenerationMap[operation].put(table, fieldsForGeneration);
        }
        return fieldsForGeneration;
    }

    public Collection<DatabaseField> getFieldsToMergeInsert() {
        return this.main[0][2];
    }

    public Collection<DatabaseField> getFieldsToMergeUpdate() {
        return this.main[1][2];
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError("clone failed");
        }
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void addFieldForInsert(String qualifiedName) {
        this.addFieldForInsert(qualifiedName, null);
    }

    public void addFieldForInsert(String qualifiedName, Class<?> type) {
        this.addFieldForInsert(this.createField(qualifiedName, type));
    }

    public void addFieldForInsert(DatabaseField field) {
        this.addField(field, true, false, false);
    }

    public void addFieldForInsertReturnOnly(String qualifiedName) {
        this.addFieldForInsertReturnOnly(qualifiedName, null);
    }

    public void addFieldForInsertReturnOnly(String qualifiedName, Class<?> type) {
        this.addFieldForInsertReturnOnly(this.createField(qualifiedName, type));
    }

    public void addFieldForInsertReturnOnly(DatabaseField field) {
        this.addField(field, true, true, false);
    }

    public void addFieldForUpdate(String qualifiedName) {
        this.addFieldForUpdate(qualifiedName, null);
    }

    public void addFieldForUpdate(String qualifiedName, Class<?> type) {
        this.addFieldForUpdate(this.createField(qualifiedName, type));
    }

    public void addFieldForUpdate(DatabaseField field) {
        this.addField(field, false, false, true);
    }

    protected void addField(DatabaseField field, boolean isInsert, boolean isInsertModeReturnOnly, boolean isUpdate) {
        this.getFieldInfos().add(new Info(field, isInsert, isInsertModeReturnOnly, isUpdate));
    }

    static Info mergeInfos(Info info1, Info info2, AbstractSession session, ClassDescriptor descriptor) {
        boolean ok = true;
        DatabaseField fieldMerged = info1.getField();
        if (info2.getField().getType() != null) {
            if (info1.getField().getType() == null) {
                fieldMerged = info2.field;
            } else if (!info1.getField().getType().equals(info2.getField().getType())) {
                session.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldTypeConflict(info1.getField().getName(), info1.getField().getType().getName(), info2.getField().getType().getName(), descriptor));
                ok = false;
            }
        }
        boolean isInsertMerged = false;
        boolean isInsertModeReturnOnlyMerged = false;
        if (info1.isInsert() && !info2.isInsert()) {
            isInsertMerged = true;
            isInsertModeReturnOnlyMerged = info1.isInsertModeReturnOnly();
        } else if (!info1.isInsert() && info2.isInsert()) {
            isInsertMerged = true;
            isInsertModeReturnOnlyMerged = info2.isInsertModeReturnOnly();
        } else if (info1.isInsert() && info2.isInsert()) {
            isInsertMerged = true;
            isInsertModeReturnOnlyMerged = info1.isInsertModeReturnOnly();
            if (info1.isInsertModeReturnOnly() != info2.isInsertModeReturnOnly()) {
                session.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldInsertConflict(info1.getField().getName(), descriptor));
                ok = false;
            }
        }
        if (ok) {
            boolean isUpdateMerged = info1.isUpdate() || info2.isUpdate();
            return new Info(fieldMerged, isInsertMerged, isInsertModeReturnOnlyMerged, isUpdateMerged);
        }
        return null;
    }

    protected static boolean isThereATypeConflict(DatabaseField field1, DatabaseField field2) {
        return field1.getType() != null && field2.getType() != null && !field1.getType().equals(field2.getType());
    }

    protected DatabaseField createField(String qualifiedName, Class<?> type) {
        DatabaseField field = new DatabaseField(qualifiedName);
        field.setType(type);
        return field;
    }

    protected Collection<DatabaseField> createCollection() {
        return new HashSet<DatabaseField>();
    }

    protected void addFieldToMain(int operation, int state, DatabaseField field) {
        if (this.main[operation][state] == null) {
            this.main[operation][state] = this.createCollection();
        }
        this.main[operation][state].add(field);
    }

    protected void addCollectionToMain(int operation, int state, Collection<? extends DatabaseField> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (this.main[operation][state] == null) {
            this.main[operation][state] = this.createCollection();
        }
        this.main[operation][state].addAll(collection);
    }

    protected void addMappedFieldToMain(DatabaseField field, Info info) {
        for (int operation = 0; operation <= 1; ++operation) {
            for (int state = 0; state <= 1; ++state) {
                if (!info.is(operation, state)) continue;
                this.addFieldToMain(operation, state, field);
                this.addFieldToMain(operation, 2, field);
                this.addFieldToMain(operation, 4, field);
            }
        }
    }

    protected void addUnmappedFieldToMain(DatabaseField field, Info info) {
        for (int operation = 0; operation <= 1; ++operation) {
            if (!info.is(operation)) continue;
            this.addFieldToMain(operation, 3, field);
            this.addFieldToMain(operation, 4, field);
        }
    }

    protected Hashtable<DatabaseField, Info> removeDuplicateAndValidateInfos(AbstractSession session) {
        Hashtable<DatabaseField, Info> infoHashtable = new Hashtable<DatabaseField, Info>();
        for (int i = 0; i < this.infos.size(); ++i) {
            Info info1 = this.infos.get(i);
            info1 = (Info)info1.clone();
            DatabaseField descField = this.getDescriptor().buildField(info1.getField());
            if (info1.getField().getType() == null) {
                info1.setField(descField);
            } else {
                info1.getField().setName(descField.getName());
                info1.getField().setTableName(this.getDescriptor().getDefaultTable().getQualifiedNameDelimited(session.getPlatform()));
            }
            Info info2 = infoHashtable.get(info1.getField());
            if (info2 == null) {
                infoHashtable.put(info1.getField(), info1);
                continue;
            }
            Info infoMerged = ReturningPolicy.mergeInfos(info1, info2, session, this.getDescriptor());
            if (infoMerged != null) {
                infoHashtable.put(infoMerged.getField(), infoMerged);
                continue;
            }
            infoHashtable.put(info1.getField(), info1);
        }
        return infoHashtable;
    }

    public void initialize(AbstractSession session) {
        ClassDescriptor parentDescriptor;
        this.clearInitialization();
        this.main = new Collection[2][5];
        if (this.getDescriptor().isChildDescriptor() && (parentDescriptor = this.getDescriptor().getInheritancePolicy().getParentDescriptor()).hasReturningPolicy()) {
            this.copyMainFrom(parentDescriptor.getReturningPolicy());
        }
        if (!this.infos.isEmpty()) {
            Info info;
            Hashtable<DatabaseField, Info> infoHashtable = this.removeDuplicateAndValidateInfos(session);
            Hashtable infoHashtableUnmapped = (Hashtable)infoHashtable.clone();
            for (DatabaseField field : this.getDescriptor().getFields()) {
                info = (Info)infoHashtableUnmapped.get(field);
                if (info == null) continue;
                infoHashtableUnmapped.remove(field);
                if (!this.verifyFieldAndMapping(session, field)) continue;
                if (info.getField().getType() == null) {
                    this.addMappedFieldToMain(field, info);
                    continue;
                }
                this.addMappedFieldToMain(info.getField(), info);
                this.fieldIsNotFromDescriptor(info.getField());
            }
            if (!infoHashtableUnmapped.isEmpty()) {
                for (DatabaseField field : infoHashtableUnmapped.keySet()) {
                    info = (Info)infoHashtableUnmapped.get(field);
                    if (!ReturningPolicy.verifyField(session, field, this.getDescriptor())) continue;
                    if (field.getType() != null) {
                        this.addUnmappedFieldToMain(field, info);
                        this.fieldIsNotFromDescriptor(field);
                        session.log(1, "query", "added_unmapped_field_to_returning_policy", info.toString(), this.getDescriptor().getJavaClassName());
                        continue;
                    }
                    if (!this.getDescriptor().isReturnTypeRequiredForReturningPolicy()) continue;
                    session.getIntegrityChecker().handleError(DescriptorException.returningPolicyUnmappedFieldTypeNotSet(field.getName(), this.getDescriptor()));
                }
            }
        }
        this.initializeIsUsedToSetPrimaryKey();
    }

    protected void copyMainFrom(ReturningPolicy policy) {
        Collection<DatabaseField>[][] mainToCopy = policy.main;
        for (int operation = 0; operation <= 1; ++operation) {
            for (int state = 0; state < 5; ++state) {
                this.addCollectionToMain(operation, state, mainToCopy[operation][state]);
            }
        }
    }

    public boolean hasEqualMains(ReturningPolicy policy) {
        int operation;
        Collection<DatabaseField>[][] mainToCompare = policy.main;
        if (this.main == mainToCompare) {
            return true;
        }
        for (int operation2 = 0; operation2 <= 1; ++operation2) {
            for (int state = 0; state < 5; ++state) {
                if (this.main[operation2][state] == null && mainToCompare[operation2][state] != null) {
                    return false;
                }
                if (this.main[operation2][state] != null && mainToCompare[operation2][state] == null) {
                    return false;
                }
                if (this.main[operation2][state].equals(mainToCompare[operation2][state])) continue;
                return false;
            }
        }
        Hashtable<DatabaseField, DatabaseField> allFields = new Hashtable<DatabaseField, DatabaseField>();
        for (operation = 0; operation <= 1; ++operation) {
            if (this.main[operation][4] == null) continue;
            for (DatabaseField field : this.main[operation][4]) {
                allFields.put(field, field);
            }
        }
        for (operation = 0; operation <= 1; ++operation) {
            if (mainToCompare[operation][4] == null) continue;
            for (DatabaseField fieldToCompare : mainToCompare[operation][4]) {
                DatabaseField field = (DatabaseField)allFields.get(fieldToCompare);
                if (field.getType().equals(fieldToCompare.getType())) continue;
                return false;
            }
        }
        return true;
    }

    public void trimModifyRowForInsert(AbstractRecord modifyRow) {
        this.trimModifyRow(modifyRow, 0);
    }

    protected void trimModifyRow(AbstractRecord modifyRow, int operation) {
        if (modifyRow == null || modifyRow.isEmpty()) {
            return;
        }
        Collection<DatabaseField> fields = this.main[operation][0];
        if (fields == null || fields.isEmpty()) {
            return;
        }
        for (int i = modifyRow.size() - 1; i >= 0; --i) {
            DatabaseField field = modifyRow.getFields().get(i);
            if (!fields.contains(field)) continue;
            modifyRow.remove(field);
        }
    }

    public boolean isUsedToSetPrimaryKey() {
        return this.isUsedToSetPrimaryKey;
    }

    protected void clearInitialization() {
        this.main = null;
        this.tableToFieldsForGenerationMap = null;
        this.fieldsNotFromDescriptor_DefaultTable = null;
        this.fieldsNotFromDescriptor_OtherTables = null;
    }

    protected void initializeIsUsedToSetPrimaryKey() {
        this.isUsedToSetPrimaryKey = false;
        if (this.main[0][2] == null || this.main[0][2].isEmpty()) {
            return;
        }
        List<DatabaseField> primaryKeys = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeys.size() && !this.isUsedToSetPrimaryKey; ++index) {
            this.isUsedToSetPrimaryKey = this.main[0][2].contains(primaryKeys.get(index));
        }
    }

    protected boolean verifyFieldAndMapping(AbstractSession session, DatabaseField field) {
        DatabaseMapping mapping;
        boolean ok = true;
        ReturningPolicy.verifyField(session, field, this.getDescriptor());
        List<DatabaseMapping> readOnlyMappings = this.getDescriptor().getObjectBuilder().getReadOnlyMappingsForField(field);
        if (readOnlyMappings != null) {
            for (int j = 0; j < readOnlyMappings.size(); ++j) {
                mapping = readOnlyMappings.get(j);
                ok &= ReturningPolicy.verifyFieldAndMapping(session, field, this.getDescriptor(), mapping);
            }
        }
        if ((mapping = this.getDescriptor().getObjectBuilder().getMappingForField(field)) != null) {
            ok &= ReturningPolicy.verifyFieldAndMapping(session, field, this.getDescriptor(), mapping);
        }
        return ok;
    }

    protected static boolean verifyFieldAndMapping(AbstractSession session, DatabaseField field, ClassDescriptor descriptor, DatabaseMapping mapping) {
        ReturningPolicy.verifyField(session, field, descriptor);
        while (mapping.isAggregateObjectMapping()) {
            ClassDescriptor referenceDescriptor = mapping.getReferenceDescriptor();
            mapping = referenceDescriptor.getObjectBuilder().getMappingForField(field);
            ReturningPolicy.verifyFieldAndMapping(session, field, referenceDescriptor, mapping);
        }
        if (!mapping.isDirectToFieldMapping() && !mapping.isTransformationMapping()) {
            String mappingTypeName = mapping.getClass().getSimpleName();
            session.getIntegrityChecker().handleError(DescriptorException.returningPolicyMappingNotSupported(field.getName(), mappingTypeName, mapping));
            return false;
        }
        return true;
    }

    protected static boolean verifyField(AbstractSession session, DatabaseField field, ClassDescriptor descriptor) {
        VersionLockingPolicy versionLockingPolicy;
        OptimisticLockingPolicy optimisticLockingPolicy;
        boolean ok = true;
        if (field.equals(descriptor.getSequenceNumberField())) {
            ok = false;
            session.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldNotSupported(field.getName(), descriptor));
        } else if (descriptor.hasInheritance() && field.equals(descriptor.getInheritancePolicy().getClassIndicatorField())) {
            ok = false;
            session.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldNotSupported(field.getName(), descriptor));
        } else if (descriptor.usesOptimisticLocking() && (optimisticLockingPolicy = descriptor.getOptimisticLockingPolicy()) instanceof VersionLockingPolicy && field.equals((versionLockingPolicy = (VersionLockingPolicy)optimisticLockingPolicy).getWriteLockField())) {
            ok = false;
            session.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldNotSupported(field.getName(), descriptor));
        }
        return ok;
    }

    public void validationAfterDescriptorInitialization(AbstractSession session) {
        Hashtable<DatabaseField, DatabaseField> mapped = new Hashtable<DatabaseField, DatabaseField>();
        for (int operation = 0; operation <= 1; ++operation) {
            if (this.main[operation][2] == null || this.main[operation][2].isEmpty()) continue;
            for (DatabaseField field : this.main[operation][2]) {
                mapped.put(field, field);
            }
        }
        if (!mapped.isEmpty()) {
            for (DatabaseField fieldInDescriptor : this.getDescriptor().getFields()) {
                DatabaseField fieldInMain = (DatabaseField)mapped.get(fieldInDescriptor);
                if (fieldInMain == null) continue;
                if (fieldInMain.getType() == null) {
                    if (!this.getDescriptor().isReturnTypeRequiredForReturningPolicy()) continue;
                    session.getIntegrityChecker().handleError(DescriptorException.returningPolicyMappedFieldTypeNotSet(fieldInMain.getName(), this.getDescriptor()));
                    continue;
                }
                if (!ReturningPolicy.isThereATypeConflict(fieldInMain, fieldInDescriptor)) continue;
                session.getIntegrityChecker().handleError(DescriptorException.returningPolicyAndDescriptorFieldTypeConflict(fieldInMain.getName(), fieldInMain.getType().getName(), fieldInDescriptor.getType().getName(), this.getDescriptor()));
            }
        }
        if (!(session.getDatasourcePlatform() instanceof DatabasePlatform)) {
            return;
        }
        WriteObjectQuery[] query = new WriteObjectQuery[]{this.getDescriptor().getQueryManager().getInsertQuery(), this.getDescriptor().getQueryManager().getUpdateQuery()};
        String[] queryTypeName = new String[]{"InsertObjectQuery", "UpdateObjectQuery"};
        for (int operation = 0; operation <= 1; ++operation) {
            if (this.main[operation][4] == null || this.main[operation][4].isEmpty()) continue;
            if (query[operation] == null || query[operation].getDatasourceCall() == null) {
                if (session.getPlatform().canBuildCallWithReturning()) continue;
                session.getIntegrityChecker().handleError(DescriptorException.noCustomQueryForReturningPolicy(queryTypeName[operation], session.getPlatform().getClass().getSimpleName(), this.getDescriptor()));
                continue;
            }
            if (!(query[operation].getDatasourceCall() instanceof StoredProcedureCall)) continue;
            DatabaseCall customCall = (DatabaseCall)query[operation].getDatasourceCall();
            Iterator iterator = customCall.getOutputRowFields().iterator();
            Collection<DatabaseField> notFoundInOutputRow = this.createCollection();
            notFoundInOutputRow.addAll(this.main[operation][4]);
            while (iterator.hasNext()) {
                notFoundInOutputRow.remove(iterator.next());
            }
            if (notFoundInOutputRow.isEmpty()) continue;
            for (DatabaseField field : notFoundInOutputRow) {
                session.getIntegrityChecker().handleError(DescriptorException.customQueryAndReturningPolicyFieldConflict(field.getName(), queryTypeName[operation], this.getDescriptor()));
            }
        }
    }

    public DatabaseField getField(DatabaseField field) {
        DatabaseField foundField = null;
        if (this.fieldsNotFromDescriptor_DefaultTable != null) {
            foundField = this.fieldsNotFromDescriptor_DefaultTable.get(field);
        }
        if (foundField == null && this.fieldsNotFromDescriptor_OtherTables != null) {
            foundField = this.fieldsNotFromDescriptor_OtherTables.get(field);
        }
        return foundField;
    }

    public static class Info
    implements Cloneable {
        private DatabaseField field;
        private boolean isInsert;
        private boolean isInsertModeReturnOnly;
        private boolean isUpdate;
        private Class<?> referenceClass;
        private String referenceClassName;

        Info() {
        }

        Info(DatabaseField field, boolean isInsert, boolean isInsertModeReturnOnly, boolean isUpdate) {
            this.field = field;
            if (field != null && field.getType() != null) {
                this.setReferenceClass(field.getType());
            }
            this.isInsert = isInsert;
            this.isInsertModeReturnOnly = isInsertModeReturnOnly;
            this.isUpdate = isUpdate;
        }

        public DatabaseField getField() {
            return this.field;
        }

        public void setField(DatabaseField field) {
            this.field = field;
            if (field.getType() == null && this.referenceClass != null) {
                field.setType(this.referenceClass);
            }
        }

        public boolean isInsert() {
            return this.isInsert;
        }

        public void setIsInsert(boolean isInsert) {
            this.isInsert = isInsert;
        }

        public boolean isInsertModeReturnOnly() {
            return this.isInsertModeReturnOnly;
        }

        public void setIsInsertModeReturnOnly(boolean isInsertModeReturnOnly) {
            this.isInsertModeReturnOnly = isInsertModeReturnOnly;
        }

        public boolean isUpdate() {
            return this.isUpdate;
        }

        public void setIsUpdate(boolean isUpdate) {
            this.isUpdate = isUpdate;
        }

        public Class<?> getReferenceClass() {
            return this.referenceClass;
        }

        public void setReferenceClass(Class<?> referenceClass) {
            this.referenceClass = referenceClass;
            if (referenceClass != null) {
                this.referenceClassName = referenceClass.getName();
            }
        }

        public String getReferenceClassName() {
            return this.referenceClassName;
        }

        public void setReferenceClassName(String referenceClassName) {
            this.referenceClassName = referenceClassName;
        }

        boolean is(int operation, int stateToCheck) {
            if (operation == 0) {
                if (this.isInsert) {
                    if (stateToCheck == 0) {
                        return this.isInsertModeReturnOnly;
                    }
                    return !this.isInsertModeReturnOnly;
                }
            } else if (this.isUpdate) {
                return stateToCheck == 1;
            }
            return false;
        }

        boolean is(int operation) {
            if (operation == 0) {
                return this.isInsert;
            }
            return this.isUpdate;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                throw new InternalError("clone failed");
            }
        }

        public boolean equals(Object objectToCompare) {
            if (objectToCompare instanceof Info) {
                return this.equals((Info)objectToCompare);
            }
            return false;
        }

        boolean equals(Info infoToCompare) {
            if (this == infoToCompare) {
                return true;
            }
            if (!this.getField().equals(infoToCompare.getField())) {
                return false;
            }
            if (this.getField().getType() == null && infoToCompare.getField().getType() != null) {
                return false;
            }
            if (this.getField().getType() != null && !this.getField().getType().equals(infoToCompare.getField().getType())) {
                return false;
            }
            if (this.isInsert() != infoToCompare.isInsert()) {
                return false;
            }
            if (this.isInsertModeReturnOnly() != infoToCompare.isInsertModeReturnOnly()) {
                return false;
            }
            return this.isUpdate() == infoToCompare.isUpdate();
        }

        public int hashCode() {
            DatabaseField field = this.getField();
            Class<?> type = field != null ? field.getType() : null;
            boolean isInsert = this.isInsert();
            boolean isInsertModeReturnOnly = this.isInsertModeReturnOnly();
            boolean isUpdate = this.isUpdate();
            int result = field != null ? field.hashCode() : 0;
            result = 31 * result + (type != null ? type.hashCode() : 0);
            result = 31 * result + (isInsert ? 1 : 0);
            result = 31 * result + (isInsertModeReturnOnly ? 1 : 0);
            result = 31 * result + (isUpdate ? 1 : 0);
            return result;
        }
    }
}

