/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

class NewInvocationNode
extends MethodCallNode {
    private boolean singleInstantiation = false;
    private boolean delimitedIdentifier;
    private boolean isBuiltinVTI = false;

    NewInvocationNode(String string, List<ValueNode> list, boolean bl, ContextManager contextManager) throws StandardException {
        super("<init>", contextManager);
        this.addParms(list);
        this.javaClassName = string;
        this.delimitedIdentifier = bl;
    }

    NewInvocationNode(TableName tableName, TableDescriptor tableDescriptor, List<ValueNode> list, boolean bl, ContextManager contextManager) throws StandardException {
        super("<init>", contextManager);
        boolean bl2;
        this.addParms(list);
        TableName tableName2 = tableName;
        TableDescriptor tableDescriptor2 = tableDescriptor;
        boolean bl3 = bl2 = tableName != null;
        if (bl2) {
            tableDescriptor2 = new TableDescriptor(this.getDataDictionary(), tableName2.getTableName(), this.getSchemaDescriptor(tableName2.getSchemaName()), 5, 'R');
        }
        this.javaClassName = this.getDataDictionary().getVTIClass(tableDescriptor2, bl2);
        boolean bl4 = this.isBuiltinVTI = this.getDataDictionary().getBuiltinVTIClass(tableDescriptor2, bl2) != null;
        if (this.javaClassName == null) {
            if (!bl2) {
                tableName2 = this.makeTableName(tableDescriptor2.getSchemaName(), tableDescriptor2.getDescriptorName());
            }
            throw StandardException.newException(bl2 ? "42Y03.S.0" : "42X05", tableName2.getFullTableName());
        }
        this.delimitedIdentifier = bl;
    }

    boolean isBuiltinVTI() {
        return this.isBuiltinVTI;
    }

    void setSingleInstantiation() {
        this.singleInstantiation = true;
    }

    @Override
    JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        TypeDescriptor typeDescriptor;
        Object object;
        this.bindParameters(fromList, subqueryList, list);
        this.verifyClassExist(this.javaClassName);
        String[] stringArray = this.getObjectSignature();
        boolean[] blArray = this.getIsParam();
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        try {
            this.method = classInspector.findPublicConstructor(this.javaClassName, stringArray, null, blArray);
            if (this.method == null) {
                object = this.getPrimitiveSignature(false);
                this.method = classInspector.findPublicConstructor(this.javaClassName, stringArray, (String[])object, blArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.method = null;
        }
        if (this.method == null) {
            object = "";
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    object = (String)object + ", ";
                }
                object = (String)object + (stringArray[i].length() != 0 ? stringArray[i] : MessageService.getTextMessage("42Z01.U", new Object[0]));
            }
            throw StandardException.newException("42X75", this.javaClassName, object);
        }
        this.methodParameterTypes = classInspector.getParameterTypes(this.method);
        for (int i = 0; i < this.methodParameterTypes.length; ++i) {
            if (!ClassInspector.primitiveType(this.methodParameterTypes[i])) continue;
            this.methodParms[i].castToPrimitive(true);
        }
        if (this.someParametersAreNull()) {
            this.setNullParameterInfo(this.methodParameterTypes);
        }
        this.setJavaTypeName(this.javaClassName);
        if (this.routineInfo != null && (typeDescriptor = this.routineInfo.getReturnType()) != null) {
            this.setCollationType(typeDescriptor.getCollationType());
        }
        return this;
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = true;
        bl2 = bl2 && super.categorize(jBitSet, bl);
        return bl2;
    }

    protected boolean assignableTo(String string) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        return classInspector.assignableTo(this.javaClassName, string);
    }

    protected Member findPublicMethod(String string, boolean bl) throws StandardException {
        Member member;
        String[] stringArray = this.getObjectSignature();
        boolean[] blArray = this.getIsParam();
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        try {
            member = classInspector.findPublicMethod(this.javaClassName, string, stringArray, null, blArray, bl, false, this.hasVarargs());
            if (member == null) {
                String[] stringArray2 = this.getPrimitiveSignature(false);
                member = classInspector.findPublicMethod(this.javaClassName, string, stringArray, stringArray2, blArray, bl, false, this.hasVarargs());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        return member;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        LocalField localField = null;
        if (this.singleInstantiation) {
            localField = expressionClassBuilder.newFieldDeclaration(2, this.javaClassName);
            methodBuilder.getField(localField);
            methodBuilder.conditionalIfNull();
        }
        methodBuilder.pushNewStart(this.javaClassName);
        int n = this.generateParameters(expressionClassBuilder, methodBuilder);
        methodBuilder.pushNewComplete(n);
        if (this.singleInstantiation) {
            methodBuilder.putField(localField);
            methodBuilder.startElseCode();
            methodBuilder.getField(localField);
            methodBuilder.completeConditional();
        }
    }
}

