/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.services;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.deployment.ResourceDescriptor;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class CommonResourceProxy
implements NamingObjectProxy.InitializationNamingObjectProxy,
Serializable {
    private static final System.Logger LOG = System.getLogger(CommonResourceProxy.class.getName());
    @Inject
    protected transient ServiceLocator serviceLocator;
    protected ResourceDescriptor desc;
    protected SimpleJndiName actualResourceName;

    public synchronized <T> T create(Context context) throws NamingException {
        if (this.actualResourceName == null) {
            this.actualResourceName = ConnectorsUtil.deriveResourceName((String)this.desc.getResourceId(), (SimpleJndiName)this.desc.getJndiName(), (JavaEEResourceType)this.desc.getResourceType());
            LOG.log(System.Logger.Level.DEBUG, "Deploying resource for actualResourceName={0} and descriptor.jndiName={1}", this.actualResourceName, this.desc.getJndiName());
            try {
                if (this.serviceLocator == null) {
                    this.serviceLocator = Globals.getDefaultHabitat();
                    if (this.serviceLocator == null) {
                        throw new NamingException("Unable to create resource [" + String.valueOf(this.desc.getJndiName()) + " ] as habitat is null");
                    }
                }
                this.getResourceDeployer(this.desc).deployResource((Object)this.desc);
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Unable to create resource [" + String.valueOf(this.desc.getJndiName()) + " ]");
                ne.initCause(e);
                throw ne;
            }
        }
        return (T)context.lookup(this.actualResourceName.toString());
    }

    protected ResourceDeployer getResourceDeployer(Object resource) {
        return ((ResourceManagerFactory)this.serviceLocator.getService(ResourceManagerFactory.class, new Annotation[0])).getResourceDeployer(resource);
    }

    public synchronized void setDescriptor(ResourceDescriptor desc) {
        this.desc = desc;
    }

    public String toString() {
        return super.toString() + "[actualResourceName=" + String.valueOf(this.actualResourceName) + ", desc.jndiName=" + String.valueOf(this.desc == null ? null : this.desc.getJndiName()) + "]";
    }
}

