/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jms.ra.ManagedConnection;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.EISSystemException;

public class LocalTransaction
implements jakarta.resource.spi.LocalTransaction {
    private ManagedConnection mc = null;
    private ConnectionImpl xac = null;
    private long transactionID = -1L;
    protected boolean started = false;
    protected boolean active = false;

    public LocalTransaction(ManagedConnection mc, ConnectionImpl xac) {
        this.mc = mc;
        this.xac = xac;
    }

    public synchronized void begin() throws ResourceException {
        try {
            if (this.xac._isClosed()) {
                EISSystemException re = new EISSystemException("MQRA:LT:startTransaction exception:Connection is closed");
                throw re;
            }
            this.transactionID = this.xac.getProtocolHandler().startTransaction(this.transactionID, -1, null);
        }
        catch (Exception ex) {
            EISSystemException re = new EISSystemException("MQRA:LT:startTransaction exception:" + ex.getMessage());
            re.initCause((Throwable)ex);
            throw re;
        }
        this.started = true;
        this.active = true;
        this.mc.setLTActive(true);
    }

    public synchronized void commit() throws ResourceException {
        block6: {
            try {
                if (!this.xac._isClosed()) {
                    this.xac.getProtocolHandler().commit(this.transactionID, -1, null);
                    break block6;
                }
                EISSystemException re = new EISSystemException("MQRA:LT:commitTransaction exception:Connection is closed");
                throw re;
            }
            catch (Exception ex) {
                EISSystemException re = new EISSystemException("MQRA:LT:commit exception:" + ex.getMessage());
                re.initCause((Throwable)ex);
                throw re;
            }
            finally {
                this.mc.setLTActive(false);
                this.started = false;
                this.active = false;
            }
        }
    }

    public synchronized void rollback() throws ResourceException {
        block6: {
            try {
                if (!this.xac._isClosed()) {
                    this.xac.getProtocolHandler().rollback(this.transactionID, null);
                    break block6;
                }
                EISSystemException re = new EISSystemException("MQRA:LT:rollbackTransaction exception:Connection is closed");
                throw re;
            }
            catch (Exception ex) {
                EISSystemException re = new EISSystemException("MQRA:LT:rollback exception:" + ex.getMessage());
                re.initCause((Throwable)ex);
                throw re;
            }
            finally {
                this.mc.setLTActive(false);
                this.started = false;
                this.active = false;
            }
        }
    }

    public synchronized long getTransactionID() {
        return this.transactionID;
    }

    public boolean started() {
        return this.started;
    }

    public synchronized boolean isActive() {
        return this.active;
    }
}

