/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.security;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.krazo.KrazoConfig;
import org.eclipse.krazo.jaxrs.JaxRsContext;
import org.eclipse.krazo.security.CsrfToken;
import org.eclipse.krazo.security.CsrfTokenStrategy;

@ApplicationScoped
public class CsrfTokenManager {
    private static final Logger log = Logger.getLogger(CsrfTokenManager.class.getName());
    private CsrfTokenStrategy tokenStrategy;
    @Inject
    private HttpServletRequest request;
    @Inject
    @JaxRsContext
    private HttpServletResponse response;
    @Inject
    private KrazoConfig krazoConfig;

    @PostConstruct
    public void init() {
        this.tokenStrategy = this.krazoConfig.getCsrfTokenStrategy();
        log.log(Level.FINE, "Configured strategy for CSRF tokens: {0}", new Object[]{this.tokenStrategy.getClass().getName()});
    }

    public Optional<CsrfToken> getToken() {
        return this.tokenStrategy.getToken(this.request, this.response, false);
    }

    public CsrfToken getOrCreateToken() {
        return this.tokenStrategy.getToken(this.request, this.response, true).orElseThrow(() -> new IllegalStateException("Strategy did not create a token"));
    }
}

