/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.lang.model.tck;

import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import org.jboss.cdi.lang.model.tck.AnnReceiver1;
import org.jboss.cdi.lang.model.tck.AnnReceiver2;
import org.jboss.cdi.lang.model.tck.LangModelUtils;
import org.jboss.cdi.lang.model.tck.LangModelVerifier;
import org.jboss.cdi.lang.model.tck.ReceiverOnClass;
import org.jboss.cdi.lang.model.tck.ReceiverOnGenericClass;

public class AnnotatedReceiverTypes<T> {
    ReceiverOnGenericClass receiverOnGenericClass;
    ReceiverOnClass receiverOnClass;

    public static void verify(ClassInfo clazz) {
        ClassInfo receiverOnGenericClass = LangModelUtils.classOfField(clazz, "receiverOnGenericClass");
        AnnotatedReceiverTypes.verifyMethodWithReceiverOnGenericClass(receiverOnGenericClass);
        AnnotatedReceiverTypes.verifyMethodWithoutReceiver(receiverOnGenericClass);
        AnnotatedReceiverTypes.verifyStaticMethod(receiverOnGenericClass);
        AnnotatedReceiverTypes.verifyConstructor(receiverOnGenericClass);
        ClassInfo receiverOnClass = LangModelUtils.classOfField(clazz, "receiverOnClass");
        AnnotatedReceiverTypes.verifyMethodWithReceiverOnClass(receiverOnClass);
        AnnotatedReceiverTypes.verifyMethodWithoutReceiver(receiverOnClass);
        AnnotatedReceiverTypes.verifyStaticMethod(receiverOnClass);
        AnnotatedReceiverTypes.verifyConstructor(receiverOnClass);
    }

    private static void verifyMethodWithReceiverOnGenericClass(ClassInfo clazz) {
        MethodInfo method = LangModelUtils.singleMethod(clazz, "methodWithReceiver");
        assert (method.receiverType() != null);
        assert (method.receiverType().isClass() || method.receiverType().isParameterizedType());
        if (method.receiverType().isClass()) {
            assert (method.receiverType().asClass().annotations().size() == 1);
            assert (method.receiverType().asClass().hasAnnotation(AnnReceiver1.class));
            assert (method.receiverType().asClass().declaration().name().equals("org.jboss.cdi.lang.model.tck.ReceiverOnGenericClass"));
        } else if (method.receiverType().isParameterizedType()) {
            if (LangModelVerifier.RUN_TYPE_ANNOTATION_TESTS) {
                assert (method.receiverType().asParameterizedType().annotations().size() == 1);
                assert (method.receiverType().asParameterizedType().hasAnnotation(AnnReceiver1.class));
            }
            assert (method.receiverType().asParameterizedType().declaration().name().equals("org.jboss.cdi.lang.model.tck.ReceiverOnGenericClass"));
        }
    }

    private static void verifyMethodWithReceiverOnClass(ClassInfo clazz) {
        MethodInfo method = LangModelUtils.singleMethod(clazz, "methodWithReceiver");
        assert (method.receiverType() != null);
        assert (method.receiverType().isClass());
        if (LangModelVerifier.RUN_TYPE_ANNOTATION_TESTS) {
            assert (method.receiverType().asClass().annotations().size() == 1);
            assert (method.receiverType().asClass().hasAnnotation(AnnReceiver2.class));
        }
        assert (method.receiverType().asClass().declaration().name().equals("org.jboss.cdi.lang.model.tck.ReceiverOnClass"));
    }

    private static void verifyMethodWithoutReceiver(ClassInfo clazz) {
        MethodInfo method = LangModelUtils.singleMethod(clazz, "methodWithoutReceiver");
        assert (method.receiverType() != null);
        assert (method.receiverType().isClass() || method.receiverType().isParameterizedType());
        if (method.receiverType().isClass()) {
            assert (method.receiverType().asClass().annotations().isEmpty());
            assert (method.receiverType().asClass().declaration().equals(clazz));
        } else if (method.receiverType().isParameterizedType()) {
            assert (method.receiverType().asParameterizedType().annotations().isEmpty());
            assert (method.receiverType().asParameterizedType().declaration().equals(clazz));
        }
    }

    private static void verifyStaticMethod(ClassInfo clazz) {
        MethodInfo method = LangModelUtils.singleMethod(clazz, "staticMethod");
        assert (method.receiverType() == null);
    }

    private static void verifyConstructor(ClassInfo clazz) {
        assert (clazz.constructors().size() == 1);
        MethodInfo method = (MethodInfo)clazz.constructors().iterator().next();
        assert (method.receiverType() == null);
    }
}

