/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.invokers.lookup;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.InvokerFactory;
import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.build.compatible.spi.Synthesis;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.invoke.Invoker;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderCreator;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderExtensionBase;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.1")
public class ArgumentLookupBeanManagerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ArgumentLookupBeanManagerTest.class)).withClasses(MyService.class, MyDependency.class)).withBuildCompatibleExtension(TestExtension.class)).withClasses(InvokerHolder.class, InvokerHolderCreator.class, InvokerHolderExtensionBase.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="configuring_lookups", id="a"), @SpecAssertion(section="configuring_lookups", id="de"), @SpecAssertion(section="configuring_lookups", id="i")})
    public void test(MyService service, InvokerHolder invokers) throws Exception {
        Invoker invoker = invokers.get("hello");
        Assert.assertEquals((String)"foobar0", (String)((String)invoker.invoke((Object)service, new Object[]{null})));
        Assert.assertEquals((String)"foobar1", (String)((String)invoker.invoke((Object)service, new Object[]{null})));
        Assert.assertEquals(MyService.observed, List.of("foo", "bar", "foo", "bar"));
        Assert.assertEquals((int)2, (int)MyDependency.CREATED);
        Assert.assertEquals((int)2, (int)MyDependency.DESTROYED);
    }

    @ApplicationScoped
    static class MyService {
        static final List<String> observed = new ArrayList<String>();

        MyService() {
        }

        public String hello(BeanManager beanManager) {
            Instance instance = beanManager.createInstance();
            MyDependency dependency = (MyDependency)instance.select(MyDependency.class, new Annotation[0]).get();
            int id = dependency.getId();
            instance.destroy((Object)dependency);
            beanManager.getEvent().select((TypeLiteral)new TypeLiteral<List<String>>(){}, new Annotation[0]).fire(List.of("foo", "bar"));
            return "foobar" + id;
        }

        public void observe(@Observes List<String> event) {
            observed.addAll(event);
        }
    }

    @Dependent
    static class MyDependency {
        static int CREATED = 0;
        static int DESTROYED = 0;
        private int id;

        MyDependency() {
        }

        @PostConstruct
        public void init() {
            this.id = CREATED++;
        }

        @PreDestroy
        public void destroy() {
            ++DESTROYED;
        }

        public int getId() {
            return this.id;
        }
    }

    public static class TestExtension
    extends InvokerHolderExtensionBase
    implements BuildCompatibleExtension {
        @Registration(types={MyService.class})
        public void myServiceRegistration(BeanInfo bean, InvokerFactory invokers) {
            this.registerInvokers(bean, invokers, Set.of("hello"), builder -> builder.withArgumentLookup(0));
        }

        @Synthesis
        public void synthesis(SyntheticComponents syn) {
            this.synthesizeInvokerHolder(syn);
        }
    }
}

