/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction.ui;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edapt.common.ui.ModelSash;
import org.eclipse.emf.edapt.history.Change;
import org.eclipse.emf.edapt.history.Release;
import org.eclipse.emf.edapt.history.reconstruction.CompositeMapping;
import org.eclipse.emf.edapt.history.reconstruction.EcoreForwardReconstructor;
import org.eclipse.emf.edapt.history.reconstruction.HistoryComparer;
import org.eclipse.emf.edapt.history.reconstruction.MappingBase;
import org.eclipse.emf.edapt.history.reconstruction.ui.DiffSelectionAdapter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;

public class ComparisonView
extends ViewPart {
    public static final String ID = ComparisonView.class.getName();
    private ModelSash beforeSash;
    private ModelSash differenceSash;
    private ModelSash afterSash;
    private HistoryComparer comparer;
    private DiffSelectionAdapter adapter;

    public void createPartControl(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        this.beforeSash = new ModelSash((Composite)sash, 0);
        this.differenceSash = new ModelSash((Composite)sash, 0);
        this.afterSash = new ModelSash((Composite)sash, 0);
        this.beforeSash.getStructureViewer().expandToLevel(3);
        this.afterSash.getStructureViewer().expandToLevel(3);
        this.adapter = new DiffSelectionAdapter(this.beforeSash, this.afterSash);
        this.differenceSash.getStructureViewer().getTree().addSelectionListener((SelectionListener)this.adapter);
        this.beforeSash.getStructureViewer().getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object data = ((TreeItem)e.item).getData();
                if (data instanceof EObject) {
                    EObject source = (EObject)data;
                    EObject target = ComparisonView.this.adapter.getMapping().getTarget(source);
                    ComparisonView.this.adapter.selectTarget(target);
                }
            }
        });
        this.afterSash.getStructureViewer().getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object data = ((TreeItem)e.item).getData();
                if (data instanceof EObject) {
                    EObject target = (EObject)data;
                    EObject source = ComparisonView.this.adapter.getMapping().getSource(target);
                    ComparisonView.this.adapter.selectSource(source);
                }
            }
        });
        sash.setWeights(new int[]{1, 1, 1});
    }

    public void setFocus() {
    }

    public void setChange(Change from, Change to) {
        EcoreForwardReconstructor beforeReconstructor = new EcoreForwardReconstructor(URI.createURI((String)"before"));
        beforeReconstructor.reconstruct(from, true);
        EcoreForwardReconstructor afterReconstructor = new EcoreForwardReconstructor(URI.createURI((String)"after"));
        afterReconstructor.reconstruct(to, false);
        this.comparer = new HistoryComparer(beforeReconstructor, afterReconstructor);
        this.show();
    }

    private void show() {
        this.beforeSash.getStructureViewer().setInput((Object)this.comparer.getSourceReconstructor().getResourceSet());
        this.beforeSash.getStructureViewer().expandToLevel(3);
        this.afterSash.getStructureViewer().setInput((Object)this.comparer.getTargetReconstructor().getResourceSet());
        this.afterSash.getStructureViewer().expandToLevel(3);
        ComparisonResourceSetSnapshot comparison = this.comparer.compare();
        CompositeMapping mapping = new CompositeMapping((MappingBase)this.comparer.getSourceReconstructor().getMapping(), (MappingBase)this.comparer.getTargetReconstructor().getMapping());
        this.adapter.setMapping((MappingBase)mapping);
        this.differenceSash.getStructureViewer().setInput((Object)comparison.getDiffResourceSet());
        this.differenceSash.getStructureViewer().expandToLevel(3);
    }

    public void setRelease(Release from, Release to) {
        EcoreForwardReconstructor beforeReconstructor = new EcoreForwardReconstructor(URI.createURI((String)"before"));
        beforeReconstructor.reconstruct(from, true);
        EcoreForwardReconstructor afterReconstructor = new EcoreForwardReconstructor(URI.createURI((String)"after"));
        afterReconstructor.reconstruct(to, false);
        this.comparer = new HistoryComparer(beforeReconstructor, afterReconstructor);
        this.show();
    }
}

