/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction.ui;

import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.edapt.common.ui.ModelDialog;
import org.eclipse.emf.edapt.common.ui.SelectionUtils;
import org.eclipse.emf.edapt.history.History;
import org.eclipse.emf.edapt.history.reconstruction.IntegrityChecker;
import org.eclipse.emf.edapt.history.reconstruction.RepairHistoryIntegrityCommand;
import org.eclipse.emf.edapt.history.reconstruction.RepairMetamodelIntegrityCommand;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CheckIntegrityHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        History history = (History)SelectionUtils.getSelectedElement((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        IEditingDomainProvider editor = (IEditingDomainProvider)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IntegrityChecker checker = new IntegrityChecker(history);
        if (checker.check()) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Integrity check of history succeeded", (String)"Integrity check of history succeeded");
        } else {
            String title = "Integrity check of history failed";
            String message = "This dialog shows the differences between the current metamodel versionand the one reconstructed from the history";
            ModelDialog diffDialog = new ModelDialog((Object)checker.getDiffModel(), title, message);
            if (diffDialog.open() == 0) {
                CommandStack commandStack = editor.getEditingDomain().getCommandStack();
                RepairMetamodelIntegrityCommand metamodelCommand = new RepairMetamodelIntegrityCommand((Collection)history.getRootPackages(), checker.getDiffModel());
                commandStack.execute((Command)metamodelCommand);
                RepairHistoryIntegrityCommand integrityCommand = new RepairHistoryIntegrityCommand(metamodelCommand);
                commandStack.execute((Command)integrityCommand);
            }
        }
        return null;
    }
}

