/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.merge.EMFCompareEObjectCopier;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.common.LoggingUtils;
import org.eclipse.emf.edapt.common.ResourceUtils;
import org.eclipse.emf.edapt.common.ui.ModelSash;
import org.eclipse.emf.edapt.common.ui.PartAdapter;
import org.eclipse.emf.edapt.common.ui.StructureTreeViewer;
import org.eclipse.emf.edapt.history.HistoryFactory;
import org.eclipse.emf.edapt.history.NoChange;
import org.eclipse.emf.edapt.history.Release;
import org.eclipse.emf.edapt.history.instantiation.BreakingSwitch;
import org.eclipse.emf.edapt.history.presentation.HistoryEditorPlugin;
import org.eclipse.emf.edapt.history.reconstruction.DiffModelFilterUtils;
import org.eclipse.emf.edapt.history.reconstruction.DiffModelOrderFilter;
import org.eclipse.emf.edapt.history.reconstruction.DiffModelResourceFilter;
import org.eclipse.emf.edapt.history.reconstruction.IDiffModelFilter;
import org.eclipse.emf.edapt.history.reconstruction.Mapping;
import org.eclipse.emf.edapt.history.reconstruction.MappingBase;
import org.eclipse.emf.edapt.history.reconstruction.ModelAssert;
import org.eclipse.emf.edapt.history.reconstruction.ui.DiffSelectionAdapter;
import org.eclipse.emf.edapt.history.recorder.ui.EcoreEditorDetector;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ConvergenceView
extends ViewPart
implements CommandStackListener,
ISelectionChangedListener {
    public static final String ID = ConvergenceView.class.getName();
    private ModelSash differenceSash;
    private ModelSash targetSash;
    private EcoreEditor editor;
    private Resource sourceResource;
    private Resource targetResource;
    private DiffSelectionAdapter selectionAdapter;
    private Mapping mapping;
    private boolean selecting = false;
    private Set<DiffElement> breakingChanges;
    private boolean synchronization = true;
    private boolean refresh;
    private final IPartListener partListener = new PartAdapter(){

        public void partClosed(IWorkbenchPart part) {
            if (ConvergenceView.this.editor == part) {
                ConvergenceView.this.differenceSash.getStructureViewer().setInput(null);
                ConvergenceView.this.targetSash.getStructureViewer().setInput(null);
                ConvergenceView.this.detachOldEditor();
            }
        }
    };

    public void createPartControl(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        this.differenceSash = new ModelSash((Composite)sash, 0);
        StructureTreeViewer differenceViewer = this.differenceSash.getStructureViewer();
        differenceViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)differenceViewer.getLabelProvider(), (ILabelDecorator)new Decorator()));
        this.targetSash = new ModelSash((Composite)sash, 0);
        this.targetSash.getStructureViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection;
                if (ConvergenceView.this.selecting) {
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof EObject) {
                    EObject element = (EObject)selection.getFirstElement();
                    EObject source = ConvergenceView.this.mapping.getSource(element);
                    if (source != null) {
                        ConvergenceView.this.selecting = true;
                        ConvergenceView.this.editor.setSelectionToViewer(Collections.singleton(source));
                        ConvergenceView.this.selecting = false;
                    }
                }
            }
        });
        differenceViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection;
                if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof DiffElement) {
                    final DiffElement element = (DiffElement)selection.getFirstElement();
                    ConvergenceView.this.editor.getEditingDomain().getCommandStack().execute((Command)new ChangeCommand((Notifier)ConvergenceView.this.editor.getEditingDomain().getResourceSet()){

                        protected void doExecute() {
                            ConvergenceView.this.fixCopier();
                            MergeService.merge((DiffElement)element, (boolean)true);
                        }
                    });
                }
            }
        });
        this.getSite().getPage().addPartListener(this.partListener);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new Action("Sync", 2){
            {
                this.setChecked(true);
                this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
                this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED_DISABLED"));
            }

            public void run() {
                ConvergenceView.this.setSynchronization(this.isChecked());
            }
        });
    }

    public void setFocus() {
        if (!this.differenceSash.isDisposed()) {
            this.differenceSash.setFocus();
        }
    }

    public void init(URI targetURI, EcoreEditor editor) {
        this.detachOldEditor();
        this.attachNewEditor(targetURI, editor);
    }

    private void detachOldEditor() {
        if (this.editor != null) {
            this.editor.getEditingDomain().getCommandStack().removeCommandStackListener((CommandStackListener)this);
            this.editor.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (!this.differenceSash.getStructureViewer().getTree().isDisposed()) {
                this.differenceSash.getStructureViewer().getTree().removeSelectionListener((SelectionListener)this.selectionAdapter);
            }
            this.editor = null;
            this.breakingChanges = null;
        }
    }

    private void attachNewEditor(URI targetURI, EcoreEditor editor) {
        try {
            this.sourceResource = (Resource)editor.getEditingDomain().getResourceSet().getResources().get(0);
            ResourceSet resourceSet = ResourceUtils.loadResourceSet((URI)targetURI);
            this.targetResource = (Resource)resourceSet.getResources().get(0);
            this.editor = editor;
            this.editor.getEditingDomain().getCommandStack().addCommandStackListener((CommandStackListener)this);
            this.selectionAdapter = new DiffSelectionAdapter(editor.getViewer(), null, (Viewer)this.targetSash.getStructureViewer(), this.targetSash.getPropertiesViewer()){

                public void widgetSelected(SelectionEvent e) {
                    ConvergenceView.this.selecting = true;
                    super.widgetSelected(e);
                    ConvergenceView.this.selecting = false;
                }
            };
            this.differenceSash.getStructureViewer().getTree().addSelectionListener((SelectionListener)this.selectionAdapter);
            this.editor.addSelectionChangedListener((ISelectionChangedListener)this);
            this.refresh();
            this.targetSash.getStructureViewer().setInput((Object)this.targetResource);
            this.targetSash.getStructureViewer().expandToLevel(2);
        }
        catch (IOException e) {
            LoggingUtils.logError((Plugin)HistoryEditorPlugin.getPlugin(), (Throwable)e);
        }
    }

    public void commandStackChanged(EventObject event) {
        if (!this.refresh && this.synchronization) {
            this.refresh();
        }
    }

    private void refresh() {
        try {
            try {
                URI targetURI;
                Integer number;
                this.refresh = true;
                ComparisonResourceSnapshot snapshot = this.compare();
                if (ModelAssert.numberOfChanges((DiffModel)snapshot.getDiff()) == 0 && this.targetResource != null && (number = this.extractNumber(targetURI = this.targetResource.getURI())) != null) {
                    this.addMarker(number + 1);
                    String name = targetURI.lastSegment().replace(number.toString(), "" + (number + 1));
                    try {
                        targetURI = targetURI.trimSegments(1).appendSegment(name);
                        ResourceSet resourceSet = ResourceUtils.loadResourceSet((URI)targetURI);
                        this.targetResource = (Resource)resourceSet.getResources().get(0);
                        this.targetSash.getStructureViewer().setInput((Object)this.targetResource);
                        this.targetSash.getStructureViewer().expandToLevel(2);
                        snapshot = this.compare();
                    }
                    catch (IOException iOException) {}
                }
                this.initMapping(snapshot.getMatch());
                this.calculateBreaking(snapshot.getDiff());
                this.differenceSash.getStructureViewer().setInput((Object)snapshot.getDiff());
                this.differenceSash.getStructureViewer().expandToLevel(3);
            }
            catch (InterruptedException e) {
                LoggingUtils.logError((Plugin)HistoryEditorPlugin.getPlugin(), (Throwable)e);
                this.refresh = false;
            }
        }
        finally {
            this.refresh = false;
        }
    }

    private ComparisonResourceSnapshot compare() throws InterruptedException {
        ComparisonResourceSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
        MatchModel match = MatchService.doResourceMatch((Resource)this.targetResource, (Resource)this.sourceResource, null);
        DiffModel diff = DiffService.doDiff((MatchModel)match);
        IDiffModelFilter filter = DiffModelFilterUtils.and((IDiffModelFilter[])new IDiffModelFilter[]{DiffModelOrderFilter.INSTANCE, DiffModelResourceFilter.INSTANCE});
        DiffModelFilterUtils.filter((DiffModel)diff, (IDiffModelFilter)filter);
        snapshot.setMatch(match);
        snapshot.setDiff(diff);
        return snapshot;
    }

    private void addMarker(final Integer number) {
        final Release release = EcoreEditorDetector.getInstance().getListener(this.editor).getHistory().getLastRelease();
        ChangeCommand command = new ChangeCommand((Notifier)release){

            protected void doExecute() {
                NoChange marker = HistoryFactory.eINSTANCE.createNoChange();
                marker.setDescription(number.toString());
                release.getChanges().add((Object)marker);
            }
        };
        this.editor.getEditingDomain().getCommandStack().execute((Command)command);
    }

    private void initMapping(MatchModel match) {
        this.mapping = new Mapping();
        TreeIterator i = match.eAllContents();
        while (i.hasNext()) {
            EObject element = (EObject)i.next();
            if (!(element instanceof Match2Elements)) continue;
            Match2Elements match2Elements = (Match2Elements)element;
            this.mapping.map(match2Elements.getRightElement(), match2Elements.getLeftElement());
        }
        this.selectionAdapter.setMapping((MappingBase)this.mapping);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        this.detachOldEditor();
        super.dispose();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        EObject element;
        EObject target;
        IStructuredSelection selection;
        if (this.selecting) {
            return;
        }
        if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof EObject && (target = this.mapping.getTarget(element = (EObject)selection.getFirstElement())) != null) {
            this.selecting = true;
            this.targetSash.getStructureViewer().setSelection((ISelection)new StructuredSelection((Object)target), true);
            this.selecting = false;
        }
    }

    public void calculateBreaking(DiffModel model) {
        this.breakingChanges = new HashSet<DiffElement>();
        BreakingSwitch s = new BreakingSwitch();
        TreeIterator i = model.eAllContents();
        while (i.hasNext()) {
            DiffElement element;
            boolean breaking;
            EObject eObject = (EObject)i.next();
            if (!(eObject instanceof DiffElement) || !(breaking = ((Boolean)s.doSwitch((EObject)(element = (DiffElement)eObject))).booleanValue())) continue;
            this.breakingChanges.add(element);
        }
        for (DiffElement change : new HashSet<DiffElement>(this.breakingChanges)) {
            while (change.eContainer() != null && change.eContainer() instanceof DiffElement) {
                change = (DiffElement)change.eContainer();
                this.breakingChanges.add(change);
            }
        }
    }

    private Integer extractNumber(URI targetURI) {
        String name = targetURI.trimFileExtension().lastSegment();
        int index = name.indexOf(95);
        if (index >= 0 && (index = (name = name.substring(index + 1)).indexOf(46)) >= 0) {
            name = name.substring(index + 1);
            try {
                return Integer.parseInt(name);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private void setSynchronization(boolean synchronization) {
        this.synchronization = synchronization;
        if (synchronization) {
            this.refresh();
        }
    }

    public ModelSash getDifferenceSash() {
        return this.differenceSash;
    }

    private void fixCopier() {
        try {
            DiffModel diff = (DiffModel)this.differenceSash.getStructureViewer().getInput();
            Field field = MergeService.class.getDeclaredField("copier");
            field.setAccessible(true);
            field.set(null, new EMFCompareEObjectCopier(diff){

                public EObject get(Object key) {
                    EObject value = (EObject)super.get(key);
                    if (value == null) {
                        if (key instanceof EDataType) {
                            EDataType type = (EDataType)key;
                            EPackage ePackage = type.getEPackage();
                            if (ePackage == EcorePackage.eINSTANCE) {
                                value = type;
                            }
                        } else if (key instanceof EObject) {
                            value = ConvergenceView.this.mapping.getSource((EObject)key);
                        }
                    }
                    return value;
                }
            });
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    public class Decorator
    implements ILabelDecorator,
    IColorDecorator {
        private final Color red = new Color((Device)Display.getDefault(), 255, 0, 0);

        public Color decorateBackground(Object element) {
            return null;
        }

        public Color decorateForeground(Object element) {
            if (ConvergenceView.this.breakingChanges.contains(element)) {
                return this.red;
            }
            return null;
        }

        public Image decorateImage(Image image, Object element) {
            return null;
        }

        public String decorateText(String text, Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.red.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

