/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;

public class ExtendedFeatureEditorDialog
extends AbstractElementListSelectionDialog {
    private TableViewer featureTableViewer;
    protected List listValues = new ArrayList();
    protected ILabelProvider labelProvider;
    protected IContentProvider contentProvider;
    protected Object object;
    protected EClassifier eClassifier;
    protected String displayName;
    protected ItemProvider values;
    protected Collection choiceOfValues;

    protected void handleDefaultSelected() {
        this.addSelectedElements();
    }

    public ExtendedFeatureEditorDialog(Shell parent, ILabelProvider labelProvider, Object object, EClassifier eClassifier, List currentValues, String displayName, Collection choiceOfValues) {
        super(parent, labelProvider);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.labelProvider = labelProvider;
        this.object = object;
        this.eClassifier = eClassifier;
        this.displayName = displayName;
        this.choiceOfValues = choiceOfValues;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory((Collection)Collections.EMPTY_LIST);
        this.values = new ItemProvider((AdapterFactory)adapterFactory, (Collection)currentValues);
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
    }

    public ExtendedFeatureEditorDialog(Shell parent, ILabelProvider labelProvider, EObject eObject, EStructuralFeature eStructuralFeature, String displayName, Collection choiceOfValues) {
        this(parent, labelProvider, eObject, eStructuralFeature.getEType(), (List)eObject.eGet(eStructuralFeature), displayName, choiceOfValues);
    }

    protected void computeResult() {
        this.setResult((List)this.values.getChildren());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_FeatureEditorDialog_title", new Object[]{this.displayName, this.labelProvider.getText(this.object)}));
        shell.setImage(this.labelProvider.getImage(this.object));
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 3;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        Composite choiceComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        choiceComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        choiceComposite.setLayout((Layout)layout);
        Label choiceLabel = this.createMessageArea(choiceComposite);
        choiceLabel.setText("Select the features to add (? = any character, * = any String)");
        this.createFilterText(choiceComposite);
        this.createFilteredList(choiceComposite);
        this.fFilteredList.setElements(this.choiceOfValues.toArray());
        Composite controlButtons = new Composite(contents, 0);
        GridData controlButtonsGridData = new GridData();
        controlButtonsGridData.verticalAlignment = 4;
        controlButtonsGridData.horizontalAlignment = 4;
        controlButtons.setLayoutData((Object)controlButtonsGridData);
        GridLayout controlsButtonGridLayout = new GridLayout();
        controlButtons.setLayout((Layout)controlsButtonGridLayout);
        new Label(controlButtons, 0);
        Button addButton = new Button(controlButtons, 8);
        addButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Add_label"));
        GridData addButtonGridData = new GridData();
        addButtonGridData.verticalAlignment = 4;
        addButtonGridData.horizontalAlignment = 4;
        addButton.setLayoutData((Object)addButtonGridData);
        Button removeButton = new Button(controlButtons, 8);
        removeButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Remove_label"));
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.verticalAlignment = 4;
        removeButtonGridData.horizontalAlignment = 4;
        removeButton.setLayoutData((Object)removeButtonGridData);
        Label spaceLabel = new Label(controlButtons, 0);
        GridData spaceLabelGridData = new GridData();
        spaceLabelGridData.verticalSpan = 2;
        spaceLabel.setLayoutData((Object)spaceLabelGridData);
        Button upButton = new Button(controlButtons, 8);
        upButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Up_label"));
        GridData upButtonGridData = new GridData();
        upButtonGridData.verticalAlignment = 4;
        upButtonGridData.horizontalAlignment = 4;
        upButton.setLayoutData((Object)upButtonGridData);
        Button downButton = new Button(controlButtons, 8);
        downButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Down_label"));
        GridData downButtonGridData = new GridData();
        downButtonGridData.verticalAlignment = 4;
        downButtonGridData.horizontalAlignment = 4;
        downButton.setLayoutData((Object)downButtonGridData);
        Composite featureComposite = new Composite(contents, 0);
        data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        featureComposite.setLayoutData((Object)data);
        layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        featureComposite.setLayout((Layout)layout);
        Label featureLabel = new Label(featureComposite, 0);
        featureLabel.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Feature_label"));
        GridData featureLabelGridData = new GridData();
        featureLabelGridData.horizontalSpan = 2;
        featureLabelGridData.horizontalAlignment = 4;
        featureLabelGridData.verticalAlignment = 4;
        featureLabel.setLayoutData((Object)featureLabelGridData);
        Table featureTable = new Table(featureComposite, 2050);
        GridData featureTableGridData = new GridData();
        featureTableGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        featureTableGridData.heightHint = Display.getCurrent().getBounds().height / 3;
        featureTableGridData.verticalAlignment = 4;
        featureTableGridData.horizontalAlignment = 4;
        featureTableGridData.grabExcessHorizontalSpace = true;
        featureTableGridData.grabExcessVerticalSpace = true;
        featureTable.setLayoutData((Object)featureTableGridData);
        this.featureTableViewer = new TableViewer(featureTable);
        this.featureTableViewer.setContentProvider(this.contentProvider);
        this.featureTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.featureTableViewer.setInput((Object)this.values);
        if (!this.values.getChildren().isEmpty()) {
            this.featureTableViewer.setSelection((ISelection)new StructuredSelection(this.values.getChildren().get(0)));
        }
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ExtendedFeatureEditorDialog.this.featureTableViewer.getSelection();
                int minIndex = 0;
                for (Object value : selection) {
                    int index = ExtendedFeatureEditorDialog.this.values.getChildren().indexOf(value);
                    ExtendedFeatureEditorDialog.this.values.getChildren().move(Math.max(index - 1, minIndex++), value);
                }
            }
        });
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ExtendedFeatureEditorDialog.this.featureTableViewer.getSelection();
                int maxIndex = ExtendedFeatureEditorDialog.this.values.getChildren().size() - selection.size();
                for (Object value : selection) {
                    int index = ExtendedFeatureEditorDialog.this.values.getChildren().indexOf(value);
                    ExtendedFeatureEditorDialog.this.values.getChildren().move(Math.min(index + 1, maxIndex++), value);
                }
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExtendedFeatureEditorDialog.this.addSelectedElements();
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExtendedFeatureEditorDialog.this.removeSelectedElements();
            }
        });
        featureTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ExtendedFeatureEditorDialog.this.removeSelectedElements();
            }
        });
        return contents;
    }

    public boolean close() {
        this.contentProvider.dispose();
        return super.close();
    }

    private void addSelectedElements() {
        if (this.getSelectedElements() != null) {
            Object[] selection;
            Object[] aobj = selection = this.getSelectedElements();
            int i = 0;
            int j = aobj.length;
            while (i < j) {
                Object item = aobj[i];
                if (!this.values.getChildren().contains(item)) {
                    this.values.getChildren().add(item);
                }
                ++i;
            }
        }
        if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(true);
        }
    }

    private void removeSelectedElements() {
        IStructuredSelection selection = (IStructuredSelection)this.featureTableViewer.getSelection();
        Object firstValue = null;
        for (Object value : selection) {
            if (firstValue == null) {
                firstValue = value;
            }
            this.values.getChildren().remove(value);
        }
        if (!this.values.getChildren().isEmpty()) {
            this.featureTableViewer.setSelection((ISelection)new StructuredSelection(this.values.getChildren().get(0)));
        }
        if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(true);
        }
    }
}

