/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import java.io.IOException;
import java.util.Collections;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edapt.common.ResourceUtils;
import org.eclipse.emf.edapt.history.reconstruction.DiffModelFilterUtils;
import org.eclipse.emf.edapt.history.reconstruction.DiffModelOrderFilter;
import org.eclipse.emf.edapt.history.reconstruction.DiffModelResourceFilter;
import org.eclipse.emf.edapt.history.reconstruction.IDiffModelFilter;

public class ModelAssert {
    public static void assertEquals(EObject expected, EObject actual, String message) {
        boolean empty;
        DiffModel diff = ModelAssert.diff(expected, actual);
        boolean bl = empty = ModelAssert.numberOfChanges(diff) == 0;
        if (!empty) {
            if (message == null) {
                message = "models are not equal";
            }
            ModelAssert.saveDiffModel(expected, diff);
            throw new AssertionFailedError(message);
        }
    }

    private static void saveDiffModel(EObject expected, DiffModel diff) {
        try {
            URI expectedURI = expected.eResource().getURI();
            String name = String.valueOf(expectedURI.trimFileExtension().lastSegment()) + "_diff.xmi";
            URI uri = expectedURI.trimSegments(1).appendFragment(name);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(uri);
            resource.getContents().add((Object)diff);
            ResourceUtils.saveResourceSet((ResourceSet)resourceSet);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void assertEquals(EObject expected, EObject actual) {
        ModelAssert.assertEquals(expected, actual, null);
    }

    public static void assertDifference(EObject expected, EObject actual, int expectedNumber, String message) {
        boolean same;
        DiffModel diff = ModelAssert.diff(expected, actual);
        int actualNumber = ModelAssert.numberOfChanges(diff);
        boolean bl = same = actualNumber == expectedNumber;
        if (!same) {
            if (message == null) {
                message = String.valueOf(expectedNumber) + " differences expected, but " + actualNumber + " encountered";
            }
            ModelAssert.saveDiffModel(expected, diff);
            throw new AssertionFailedError(message);
        }
    }

    public static void assertDifference(EObject expected, EObject actual, int expectedNumber) {
        ModelAssert.assertDifference(expected, actual, expectedNumber, null);
    }

    private static DiffModel diff(EObject expected, EObject actual) {
        try {
            MatchModel match = MatchService.doMatch((EObject)expected, (EObject)actual, Collections.emptyMap());
            DiffModel diff = DiffService.doDiff((MatchModel)match, (boolean)false);
            IDiffModelFilter filter = DiffModelFilterUtils.and(DiffModelOrderFilter.INSTANCE, DiffModelResourceFilter.INSTANCE);
            DiffModelFilterUtils.filter(diff, filter);
            return diff;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public static int numberOfChanges(DiffModel diff) {
        int number = 0;
        TreeIterator i = diff.eAllContents();
        while (i.hasNext()) {
            EObject element = (EObject)i.next();
            if (!(element instanceof DiffElement) || element instanceof DiffGroup) continue;
            ++number;
        }
        return number;
    }

    public static int numberOfChanges(DiffResourceSet diff) {
        int number = 0;
        TreeIterator i = diff.eAllContents();
        while (i.hasNext()) {
            EObject element = (EObject)i.next();
            if (!(element instanceof DiffElement) || element instanceof DiffGroup) continue;
            ++number;
        }
        return number;
    }
}

