/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edapt.common.ui.AutoColumnSizeTableViewer;
import org.eclipse.emf.edapt.common.ui.IValueValidator;
import org.eclipse.emf.edapt.common.ui.MultiValueSelectionDialog;
import org.eclipse.emf.edapt.common.ui.SingleValueSelectionDialog;
import org.eclipse.emf.edapt.declaration.Parameter;
import org.eclipse.emf.edapt.history.OperationInstance;
import org.eclipse.emf.edapt.history.ParameterInstance;
import org.eclipse.emf.edapt.history.instantiation.ui.OperationSash;
import org.eclipse.emf.edapt.history.instantiation.ui.ParameterValueValidator;
import org.eclipse.emf.edapt.history.instantiation.ui.TableItemPopupDialog;
import org.eclipse.emf.edapt.history.provider.HistoryEditPlugin;
import org.eclipse.emf.edapt.history.provider.HistoryItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterViewer
extends AutoColumnSizeTableViewer {
    private static final String NAME_COLUMN_PROPERTY = "Name";
    private static final String VALUE_COLUMN_PROPERTY = "Value";
    private final OperationSash operationSash;
    private Image parameterImage;
    private ILabelProvider cellLabelProvider;
    private AdapterFactoryLabelProvider dialogLabelProvider;

    public ParameterViewer(Composite parent, OperationSash operationSash) {
        super(parent, 68354);
        this.operationSash = operationSash;
        this.init();
    }

    private void init() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new HistoryItemProviderAdapterFactory());
        this.dialogLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        this.cellLabelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof Collection) {
                    Collection collection = (Collection)element;
                    if (!collection.isEmpty()) {
                        return ParameterViewer.this.dialogLabelProvider.getImage(collection.iterator().next());
                    }
                } else if (element != null) {
                    return ParameterViewer.this.dialogLabelProvider.getImage(element);
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof Collection) {
                    String label = "";
                    Collection c = (Collection)element;
                    Iterator i = c.iterator();
                    while (i.hasNext()) {
                        label = String.valueOf(label) + ParameterViewer.this.dialogLabelProvider.getText(i.next());
                        if (!i.hasNext()) continue;
                        label = String.valueOf(label) + ", ";
                    }
                    return label;
                }
                return ParameterViewer.this.dialogLabelProvider.getText(element);
            }
        };
        URL url = (URL)HistoryEditPlugin.INSTANCE.getImage("full/obj16/ParameterInstance");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        this.parameterImage = imageDescriptor.createImage();
        final Table parameterTable = this.getTable();
        parameterTable.setHeaderVisible(true);
        TableColumn parameterNameColumn = new TableColumn(parameterTable, 0);
        parameterNameColumn.setWidth(100);
        parameterNameColumn.setText(NAME_COLUMN_PROPERTY);
        parameterNameColumn.setResizable(false);
        TableColumn parameterValueColumn = new TableColumn(parameterTable, 0);
        parameterValueColumn.setWidth(100);
        parameterValueColumn.setText(VALUE_COLUMN_PROPERTY);
        parameterValueColumn.setResizable(false);
        this.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                OperationInstance operationInstance = (OperationInstance)inputElement;
                return operationInstance.getParameters().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                ParameterInstance parameterInstance = (ParameterInstance)element;
                switch (columnIndex) {
                    case 0: {
                        return ParameterViewer.this.parameterImage;
                    }
                    case 1: {
                        return ParameterViewer.this.cellLabelProvider.getImage(parameterInstance.getValue());
                    }
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                ParameterInstance parameterInstance = (ParameterInstance)element;
                switch (columnIndex) {
                    case 0: {
                        return parameterInstance.getName();
                    }
                    case 1: {
                        Object value = parameterInstance.getValue();
                        return ParameterViewer.this.cellLabelProvider.getText(value);
                    }
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.setColumnProperties(new String[]{NAME_COLUMN_PROPERTY, VALUE_COLUMN_PROPERTY});
        final CellEditor[] cellEditors = new CellEditor[2];
        cellEditors[1] = new TextCellEditor((Composite)this.getTable());
        this.setCellEditors(cellEditors);
        this.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (ParameterViewer.NAME_COLUMN_PROPERTY.equals(property)) {
                    return false;
                }
                ParameterInstance parameterInstance = (ParameterInstance)element;
                Parameter parameter = parameterInstance.getParameter();
                if (parameter.isMain()) {
                    return false;
                }
                cellEditors[1] = ParameterViewer.this.getCellEditor(parameterInstance);
                return true;
            }

            public Object getValue(Object element, String property) {
                ParameterInstance parameterInstance = (ParameterInstance)element;
                return parameterInstance.getValue();
            }

            public void modify(Object element, String property, Object value) {
                ParameterInstance parameterInstance = (ParameterInstance)(element = ((TableItem)element).getData());
                Parameter parameter = parameterInstance.getParameter();
                if (parameter.isMany()) {
                    if (parameter.getClassifier() instanceof EClass) {
                        if (!(value instanceof Object[])) {
                            return;
                        }
                        Object[] values = (Object[])value;
                        parameterInstance.setValue(Arrays.asList(values));
                    } else {
                        parameterInstance.setValue(value);
                    }
                } else if (parameter.getClassifier() instanceof EClass) {
                    if (!(value instanceof Object[])) {
                        return;
                    }
                    Object[] values = (Object[])value;
                    if (values.length == 0) {
                        parameterInstance.setValue(null);
                    } else {
                        parameterInstance.setValue(values[0]);
                    }
                } else {
                    parameterInstance.setValue(value);
                }
                ParameterViewer.this.refresh(true);
                ParameterViewer.this.operationSash.updateConstraints((OperationInstance)parameterInstance.eContainer());
            }
        });
        parameterTable.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                if (parameterTable.getSelectionCount() > 0) {
                    TableItem tableItem = parameterTable.getSelection()[0];
                    ParameterViewer.this.showDescription(tableItem);
                }
            }
        });
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (parameterTable.getSelectionCount() > 0) {
                    TableItem tableItem = parameterTable.getSelection()[0];
                    ParameterViewer.this.showDescription(tableItem);
                }
            }
        });
    }

    private void showDescription(TableItem tableItem) {
        ParameterInstance parameterInstance = (ParameterInstance)tableItem.getData();
        Parameter parameter = parameterInstance.getParameter();
        TableItemPopupDialog dialog = new TableItemPopupDialog(tableItem, parameter.getName(), parameter.getDescription());
        dialog.open();
    }

    protected CellEditor getCellEditor(final ParameterInstance parameterInstance) {
        final Parameter parameter = parameterInstance.getParameter();
        if (parameter.isMany()) {
            if (parameter.getClassifier() instanceof EClass) {
                return new ExtendedDialogCellEditor((Composite)this.getTable(), this.cellLabelProvider){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        ParameterValueValidator selection = new ParameterValueValidator(parameterInstance, ParameterViewer.this.operationSash.getHelper().getExtent());
                        List values = (List)parameterInstance.getValue();
                        MultiValueSelectionDialog dialog = new MultiValueSelectionDialog(cellEditorWindow.getShell(), ParameterViewer.this.parameterImage, ParameterViewer.getEditorTitle(parameter), values, ParameterViewer.this.getRootPackages(), ParameterViewer.this.dialogLabelProvider, (IValueValidator)selection);
                        dialog.open();
                        return dialog.getResult();
                    }
                };
            }
            if (parameter.getClassifier() instanceof EDataType) {
                return new ExtendedDialogCellEditor((Composite)this.getTable(), this.cellLabelProvider){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        EDataType type = (EDataType)parameter.getClassifier();
                        List values = (List)parameterInstance.getValue();
                        FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), (ILabelProvider)ParameterViewer.this.dialogLabelProvider, (Object)parameterInstance, (EClassifier)type, values, ParameterViewer.getEditorTitle(parameterInstance.getParameter()), null);
                        dialog.open();
                        return dialog.getResult();
                    }
                };
            }
        } else {
            if (parameter.getClassifier() instanceof EClass) {
                return new ExtendedDialogCellEditor((Composite)this.getTable(), this.cellLabelProvider){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        ParameterValueValidator selection = new ParameterValueValidator(parameterInstance, ParameterViewer.this.operationSash.getHelper().getExtent());
                        SingleValueSelectionDialog dialog = new SingleValueSelectionDialog(cellEditorWindow.getShell(), ParameterViewer.this.parameterImage, ParameterViewer.getEditorTitle(parameter), parameterInstance.getValue(), ParameterViewer.this.getRootPackages(), ParameterViewer.this.dialogLabelProvider, (IValueValidator)selection);
                        dialog.open();
                        return dialog.getResult();
                    }
                };
            }
            if (parameter.getClassifier() instanceof EDataType) {
                EDataType dataType = (EDataType)parameter.getClassifier();
                if (dataType.getInstanceClass() == Boolean.class || dataType.getInstanceClass() == Boolean.TYPE) {
                    List<Object> values = Arrays.asList(Boolean.FALSE, Boolean.TRUE);
                    return new ExtendedComboBoxCellEditor((Composite)this.getTable(), values, (ILabelProvider)this.dialogLabelProvider, false);
                }
                return new PropertyDescriptor.EDataTypeCellEditor((EDataType)parameter.getClassifier(), (Composite)this.getTable());
            }
        }
        return null;
    }

    private Collection<EPackage> getRootPackages() {
        ArrayList<EPackage> rootPackages = new ArrayList<EPackage>();
        rootPackages.addAll(this.operationSash.getHelper().getExtent().getRootPackages());
        rootPackages.add((EPackage)EcorePackage.eINSTANCE);
        return rootPackages;
    }

    public static String getEditorTitle(Parameter parameter) {
        String result = "Parameter ";
        result = String.valueOf(result) + parameter.getName();
        result = String.valueOf(result) + " : ";
        result = parameter.isMany() ? String.valueOf(result) + "List<" + parameter.getClassifierName() + ">" : String.valueOf(result) + parameter.getClassifierName();
        return result;
    }
}

