/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation;

import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.common.LoggingUtils;
import org.eclipse.emf.edapt.common.MetamodelExtent;
import org.eclipse.emf.edapt.common.MetamodelUtils;
import org.eclipse.emf.edapt.history.HistoryFactory;
import org.eclipse.emf.edapt.history.OperationChange;
import org.eclipse.emf.edapt.history.OperationInstance;
import org.eclipse.emf.edapt.history.PrimitiveChange;
import org.eclipse.emf.edapt.history.Release;
import org.eclipse.emf.edapt.history.instantiation.ExecuteCommand;
import org.eclipse.emf.edapt.history.provider.HistoryEditPlugin;
import org.eclipse.emf.edapt.history.reconstruction.EcoreForwardReconstructor;
import org.eclipse.emf.edit.command.ChangeCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceCommand
extends ChangeCommand {
    private final List<PrimitiveChange> changes;
    private final OperationInstance operation;

    public ReplaceCommand(List<PrimitiveChange> changes, OperationInstance operation) {
        super((Notifier)changes.get(0).eContainer());
        this.changes = changes;
        this.operation = operation;
    }

    protected boolean prepare() {
        return false;
    }

    private void tryOperation(OperationInstance operation, EcoreForwardReconstructor current, EcoreForwardReconstructor replaced) {
        OperationInstance replacedOperation = (OperationInstance)replaced.getMapping().copyResolveTarget((EObject)operation);
        MetamodelExtent extent = new MetamodelExtent(MetamodelUtils.getAllRootPackages((ResourceSet)replaced.getResourceSet()));
        ChangeRecorder recorder = new ChangeRecorder(extent.getRootPackages());
        ExecuteCommand command = new ExecuteCommand(replacedOperation, extent);
        command.execute();
        ChangeDescription changeDescription = recorder.endRecording();
        this.adaptMapping(changeDescription, current, replaced);
    }

    private void adaptMapping(ChangeDescription changeDescription, EcoreForwardReconstructor current, EcoreForwardReconstructor replaced) {
        for (EObject replacedElement : changeDescription.getObjectsToDetach()) {
            if (replacedElement instanceof EGenericType) continue;
            try {
                EObject container = replacedElement.eContainer();
                EObject originalContainer = replaced.getMapping().getSource(container);
                EObject currentContainer = current.getMapping().getTarget(originalContainer);
                EReference containment = replacedElement.eContainmentFeature();
                if (containment.isMany()) {
                    int index = ((List)container.eGet((EStructuralFeature)containment)).indexOf(replacedElement);
                    EObject currentElement = (EObject)((List)currentContainer.eGet((EStructuralFeature)containment)).get(index);
                    EObject originalElement = current.getMapping().getSource(currentElement);
                    replaced.getMapping().map(originalElement, replacedElement);
                    continue;
                }
                EObject originalElement = (EObject)originalContainer.eGet((EStructuralFeature)containment);
                replaced.getMapping().map(originalElement, replacedElement);
            }
            catch (RuntimeException e) {
                LoggingUtils.logError((Plugin)HistoryEditPlugin.getPlugin(), (Throwable)e);
            }
        }
    }

    protected void doExecute() {
        OperationChange change = HistoryFactory.eINSTANCE.createOperationChange();
        change.setOperation(this.operation);
        PrimitiveChange firstChange = this.changes.get(0);
        Release release = (Release)firstChange.eContainer();
        release.getChanges().add(release.getChanges().indexOf((Object)firstChange), (Object)change);
        change.getChanges().addAll(this.changes);
    }
}

