/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.presentation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecp.view.model.presentation.ViewEditorPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class ViewModelWizardNewFileCreationPage
extends WizardNewFileCreationPage {
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(ViewEditorPlugin.INSTANCE.getString("_UI_ViewEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = ViewEditorPlugin.INSTANCE.getString("_UI_ViewEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    private EClass eClass;
    private final IStructuredSelection selection;

    public EClass getEClass() {
        return this.eClass;
    }

    public void setEClass(EClass eClass) {
        this.eClass = eClass;
    }

    public ViewModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
        super(pageId, selection);
        this.selection = selection;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Object selectedElement;
            if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
                IResource selectedResource = (IResource)selectedElement;
                if (selectedResource.getType() == 1) {
                    selectedResource = selectedResource.getParent();
                }
                if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                    this.setContainerFullPath(selectedResource.getFullPath());
                }
                String defaultModelBaseFilename = this.eClass.getName();
                String defaultModelFilenameExtension = FILE_EXTENSIONS.get(0);
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.setFileName(modelFilename);
                this.setPageComplete(true);
            }
        } else {
            this.setPageComplete(false);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            String extension = new Path(this.getFileName()).getFileExtension();
            if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                this.setErrorMessage(ViewEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                return false;
            }
            this.checkProjectNature();
            return true;
        }
        return false;
    }

    private void checkProjectNature() {
        IProject project = this.getModelFile().getProject();
        try {
            if (!project.hasNature("org.eclipse.pde.PluginNature")) {
                this.setMessage(ViewEditorPlugin.INSTANCE.getString("_WARN_PluginProject"), 2);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public IFile getModelFile() {
        if (this.getContainerFullPath() == null || this.getFileName() == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
    }
}

