/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import java.util.Calendar;
import java.util.Locale;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.DateAndTimeObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.ViewLocaleService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;

public class DateTimeControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private final EMFFormsLocalizationService localizationService;
    private final ImageRegistryService imageRegistryService;
    private Label unsetLabel;
    private StackLayout stackLayout;
    private Composite stackComposite;
    private Composite dateTimeComposite;
    private Composite composite;
    private Shell dialog;
    private ModelChangeListener domainModelChangeListener;

    @Inject
    public DateTimeControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsLocalizationService localizationService, ImageRegistryService imageRegistryService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.localizationService = localizationService;
        this.imageRegistryService = imageRegistryService;
    }

    @Override
    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        DateTime date = (DateTime)((Composite)((Composite)((Composite)control).getChildren()[0]).getChildren()[0]).getChildren()[0];
        DateTime time = (DateTime)((Composite)((Composite)((Composite)control).getChildren()[0]).getChildren()[0]).getChildren()[1];
        Button unsetBtn = (Button)((Composite)((Composite)((Composite)control).getChildren()[0]).getChildren()[0]).getChildren()[2];
        Button setBtn = (Button)((Composite)control).getChildren()[1];
        ISWTObservableValue dateObserver = SWTObservables.observeSelection((Control)date);
        ISWTObservableValue timeObserver = SWTObservables.observeSelection((Control)time);
        DateAndTimeObservableValue target = new DateAndTimeObservableValue((IObservableValue)dateObserver, (IObservableValue)timeObserver);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)target, this.getModelValue());
        setBtn.addSelectionListener((SelectionListener)new SetBtnSelectionAdapterExtension(setBtn, this.getModelValue(), this.getViewModelContext()));
        unsetBtn.addSelectionListener((SelectionListener)new UnsetBtnSelectionAdapterExtension());
        this.domainModelChangeListener = new ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                EStructuralFeature structuralFeature;
                try {
                    structuralFeature = (EStructuralFeature)DateTimeControlSWTRenderer.this.getModelValue().getValueType();
                }
                catch (DatabindingFailedException ex) {
                    DateTimeControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return;
                }
                if (structuralFeature.equals(notification.getStructuralFeature())) {
                    DateTimeControlSWTRenderer.this.updateChangeListener(notification.getRawNotification().getNewValue());
                }
            }
        };
        this.getViewModelContext().registerDomainChangeListener(this.domainModelChangeListener);
        return new Binding[]{binding};
    }

    @Override
    protected void dispose() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.dialog.dispose();
        }
        this.getViewModelContext().unregisterDomainChangeListener(this.domainModelChangeListener);
        super.dispose();
    }

    @Override
    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        this.composite = new Composite(parent, 0);
        this.composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(2, 0).equalWidth(false).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.composite);
        this.stackComposite = new Composite(this.composite, 0);
        this.stackComposite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(2, 0).equalWidth(false).applyTo(this.stackComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.stackComposite);
        this.dateTimeComposite = new Composite(this.stackComposite, 0);
        this.dateTimeComposite.setBackground(this.composite.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(2, 0).equalWidth(false).applyTo(this.dateTimeComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.dateTimeComposite);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.unsetLabel = new Label(this.stackComposite, 0x1000000);
        this.unsetLabel.setText(this.getUnsetText());
        this.unsetLabel.setBackground(this.stackComposite.getBackground());
        this.unsetLabel.setForeground(parent.getDisplay().getSystemColor(16));
        this.unsetLabel.setAlignment(0x1000000);
        DateTime dateWidget = new DateTime(this.dateTimeComposite, 2080);
        dateWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        dateWidget.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_date");
        DateTime timeWidget = new DateTime(this.dateTimeComposite, 34944);
        timeWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        timeWidget.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_time");
        Button bUnset = new Button(this.dateTimeComposite, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)bUnset);
        bUnset.setImage(this.imageRegistryService.getImage(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), "icons/unset_feature.png"));
        bUnset.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_buttonUnset");
        bUnset.setToolTipText(this.getLocalizedString("DateTimeControlSWTRenderer_CleanDate"));
        Button bDate = new Button(this.composite, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)bDate);
        bDate.setImage(this.imageRegistryService.getImage(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), "icons/date.png"));
        bDate.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_buttonSet");
        bDate.setToolTipText(this.getLocalizedString("DateTimeControlSWTRenderer_SelectData"));
        IObservableValue observableValue = this.getEMFFormsDatabinding().getObservableValue(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        EObject eObject = (EObject)((IObserving)observableValue).getObserved();
        observableValue.dispose();
        this.stackLayout.topControl = eObject.eIsSet(structuralFeature) ? this.dateTimeComposite : this.unsetLabel;
        return this.composite;
    }

    @Override
    protected void setValidationColor(Control control, Color validationColor) {
        ((Composite)control).getChildren()[0].setBackground(validationColor);
        ((Composite)control).getChildren()[1].setBackground(validationColor);
    }

    @Override
    protected String getUnsetText() {
        return this.getLocalizedString("DateTimeControl_NoDateSetClickToSetDate");
    }

    private String getLocalizedString(String key) {
        return this.localizationService.getString(((Object)((Object)this)).getClass(), key);
    }

    private Locale getLocale(ViewModelContext viewModelContext) {
        ViewLocaleService service = (ViewLocaleService)viewModelContext.getService(ViewLocaleService.class);
        if (service == null) {
            return Locale.getDefault();
        }
        return service.getLocale();
    }

    private void updateChangeListener(Object value) {
        if (value == null) {
            if (this.stackLayout.topControl != this.unsetLabel) {
                this.stackLayout.topControl = this.unsetLabel;
                this.stackComposite.layout();
            }
        } else if (this.stackLayout.topControl != this.dateTimeComposite) {
            this.stackLayout.topControl = this.dateTimeComposite;
            this.stackComposite.layout();
        }
    }

    private class SetBtnSelectionAdapterExtension
    extends SelectionAdapter {
        private final Button btn;
        private final IObservableValue modelValue;
        private final ViewModelContext viewModelContext;

        public SetBtnSelectionAdapterExtension(Button btn, IObservableValue modelValue, ViewModelContext viewModelContext) {
            this.btn = btn;
            this.modelValue = modelValue;
            this.viewModelContext = viewModelContext;
        }

        public void widgetSelected(SelectionEvent e) {
            if (DateTimeControlSWTRenderer.this.dialog != null && !DateTimeControlSWTRenderer.this.dialog.isDisposed()) {
                DateTimeControlSWTRenderer.this.dialog.dispose();
                return;
            }
            DateTimeControlSWTRenderer.this.dialog = new Shell(this.btn.getShell(), 0);
            DateTimeControlSWTRenderer.this.dialog.setLayout((Layout)new GridLayout(1, false));
            DateTime calendar = new DateTime((Composite)DateTimeControlSWTRenderer.this.dialog, 3072);
            Calendar defaultCalendar = Calendar.getInstance(DateTimeControlSWTRenderer.this.getLocale(this.viewModelContext));
            calendar.setDate(defaultCalendar.get(1), defaultCalendar.get(2), defaultCalendar.get(5));
            ISWTObservableValue calendarObserver = SWTObservables.observeSelection((Control)calendar);
            UpdateValueStrategy modelToTarget = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
            UpdateValueStrategy targetToModel = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
            final Binding binding = DateTimeControlSWTRenderer.this.getDataBindingContext().bindValue((IObservableValue)calendarObserver, this.modelValue, modelToTarget, targetToModel);
            binding.updateModelToTarget();
            Button okButton = new Button((Composite)DateTimeControlSWTRenderer.this.dialog, 8);
            okButton.setText(JFaceResources.getString((String)"ok"));
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)okButton);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    binding.updateTargetToModel();
                    binding.dispose();
                    DateTimeControlSWTRenderer.this.dialog.close();
                    DateTimeControlSWTRenderer.this.updateChangeListener(SetBtnSelectionAdapterExtension.this.modelValue.getValue());
                }
            });
            DateTimeControlSWTRenderer.this.dialog.pack();
            DateTimeControlSWTRenderer.this.dialog.layout();
            DateTimeControlSWTRenderer.this.dialog.setLocation(this.btn.getParent().toDisplay(this.btn.getLocation().x + this.btn.getSize().x - ((DateTimeControlSWTRenderer)DateTimeControlSWTRenderer.this).dialog.getSize().x, this.btn.getLocation().y + this.btn.getSize().y));
            DateTimeControlSWTRenderer.this.dialog.open();
        }
    }

    private class UnsetBtnSelectionAdapterExtension
    extends SelectionAdapter {
        private UnsetBtnSelectionAdapterExtension() {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                EStructuralFeature structuralFeature = (EStructuralFeature)DateTimeControlSWTRenderer.this.getModelValue().getValueType();
                EObject eObject = (EObject)((IObserving)DateTimeControlSWTRenderer.this.getModelValue()).getObserved();
                Command removeCommand = SetCommand.create((EditingDomain)DateTimeControlSWTRenderer.this.getEditingDomain(eObject), (Object)eObject, (Object)structuralFeature, null);
                DateTimeControlSWTRenderer.this.getEditingDomain(eObject).getCommandStack().execute(removeCommand);
                DateTimeControlSWTRenderer.this.updateChangeListener(DateTimeControlSWTRenderer.this.getModelValue().getValue());
            }
            catch (DatabindingFailedException ex) {
                DateTimeControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            }
        }
    }
}

