/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.internal.validation.Activator;
import org.eclipse.emf.ecp.view.internal.validation.ValidationServiceImpl;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.validation.ValidationProvider;

public final class ValidationProviderHelper {
    private final Map<ValidationProvider, ValidationProvider> providers = new HashMap<ValidationProvider, ValidationProvider>();
    private final ViewModelContext context;
    private final ValidationServiceImpl validationService;

    ValidationProviderHelper(ViewModelContext context, ValidationServiceImpl validationService) {
        this.context = context;
        this.validationService = validationService;
    }

    public Set<ValidationProvider> getValidationProviders() {
        return Collections.unmodifiableSet(this.providers.keySet());
    }

    public void initialize() {
        ValidationProviderHelper.fetchValidationProviders().forEach(p -> this.validationService.addValidationProvider((ValidationProvider)p, false));
    }

    public void dispose() {
        try {
            this.providers.keySet().forEach(p -> this.validationService.removeValidationProvider((ValidationProvider)p, false));
        }
        finally {
            this.providers.clear();
        }
    }

    ValidationProvider wrap(ValidationProvider provider) {
        return this.providers.computeIfAbsent(provider, arg_0 -> Wrapper.new(this, arg_0));
    }

    ValidationProvider unwrap(ValidationProvider provider) {
        return provider instanceof Wrapper ? ((Wrapper)provider).delegate : provider;
    }

    @Deprecated
    public static Set<ValidationProvider> fetchValidationProviders() {
        IConfigurationElement[] controls;
        LinkedHashSet<ValidationProvider> providers = new LinkedHashSet<ValidationProvider>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return providers;
        }
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.validation.validationProvider");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                ValidationProvider provider = (ValidationProvider)e.createExecutableExtension("class");
                providers.add(provider);
            }
            catch (CoreException e1) {
                Activator.logException((Exception)((Object)e1));
            }
            ++n2;
        }
        return providers;
    }

    private final class Wrapper
    implements ValidationProvider {
        private final ValidationProvider delegate;

        Wrapper(ValidationProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setContext(ViewModelContext context) {
            this.delegate.setContext(context);
        }

        @Override
        public void unsetContext(ViewModelContext context) {
            this.delegate.unsetContext(context);
        }

        public List<Diagnostic> validate(EObject eObject) {
            Iterable<? extends Diagnostic> delegated = this.delegate.validate(ValidationProviderHelper.this.context, eObject);
            if (delegated == null) {
                return Collections.emptyList();
            }
            if (delegated instanceof List) {
                return (List)delegated;
            }
            if (delegated instanceof Collection) {
                return new ArrayList<Diagnostic>((Collection)delegated);
            }
            ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
            delegated.forEach(result::add);
            return result;
        }

        @Override
        public Iterable<? extends Diagnostic> validate(ViewModelContext userContext, EObject object) {
            return this.delegate.validate(userContext, object);
        }
    }
}

