/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.genmodel.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emfforms.internal.editor.genmodel.Activator;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class PluginXmlUtil {
    private PluginXmlUtil() {
    }

    public static void addEditorExtensionPoint(IFile file, String editorClass, boolean defaultEditor, String extensions, String icon, String id, String name) {
        Transformer transformer;
        Document document;
        DocumentBuilder builder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.editor.genmodel", ex.getMessage(), (Throwable)ex)));
            return;
        }
        try {
            document = builder.parse(file.getContents());
        }
        catch (SAXException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.editor.genmodel", ex.getMessage(), (Throwable)ex)));
            return;
        }
        catch (IOException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.editor.genmodel", ex.getMessage(), (Throwable)ex)));
            return;
        }
        catch (CoreException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.editor.genmodel", ex.getMessage(), (Throwable)ex)));
            return;
        }
        Element plugin = document.getDocumentElement();
        Element editor = document.createElement("editor");
        editor.setAttribute("class", editorClass);
        editor.setAttribute("default", Boolean.toString(defaultEditor));
        editor.setAttribute("extensions", extensions);
        editor.setAttribute("icon", icon);
        editor.setAttribute("id", id);
        editor.setAttribute("name", name);
        Element extension = document.createElement("extension");
        extension.setAttribute("point", "org.eclipse.ui.editors");
        plugin.appendChild(extension);
        extension.appendChild(editor);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.editor.genmodel", ex.getMessage(), (Throwable)ex)));
            return;
        }
        DOMSource domSource = new DOMSource(document);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            transformer.transform(domSource, new StreamResult(bos));
        }
        catch (TransformerException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.editor.genmodel", ex.getMessage(), (Throwable)ex)));
            return;
        }
        try {
            file.setContents((InputStream)new ByteArrayInputStream(bos.toByteArray()), false, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.editor.genmodel", ex.getMessage(), (Throwable)ex)));
            return;
        }
    }
}

