/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.common;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;

public final class Feature {
    private final String id;
    private final String description;
    private final STRATEGY strategy;

    public Feature(String id, String description) {
        this.id = id;
        this.description = description;
        this.strategy = STRATEGY.NONE;
    }

    public Feature(String id, String description, STRATEGY strategy) {
        this.id = id;
        this.description = description;
        this.strategy = strategy;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public STRATEGY getStrategy() {
        return this.strategy;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.format("Feature(%s, %s)", new Object[]{this.id, this.strategy});
    }

    public static Set<Feature> inherit(Collection<Feature> features, Predicate<? super Feature> isSupported) {
        LinkedHashSet<Feature> result = new LinkedHashSet<Feature>();
        for (Feature feature : features) {
            if (!STRATEGY.INHERIT.equals((Object)feature.getStrategy()) || !isSupported.test(feature)) continue;
            result.add(feature);
        }
        return result;
    }

    public static enum STRATEGY {
        NONE,
        INHERIT;

    }
}

