/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.section.swt;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.section.model.VSection;
import org.eclipse.emf.ecp.view.spi.section.model.VSectionedArea;
import org.eclipse.emf.ecp.view.spi.section.swt.AbstractSectionSWTRenderer;
import org.eclipse.emf.ecp.view.spi.section.swt.SectionLeafSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.LayoutProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractAdditionalSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SectionedAreaSWTRenderer
extends AbstractSWTRenderer<VSectionedArea> {
    private static final String CUSTOM_VARIANT_VALUE = "org_eclipse_emf_ecp_ui_section";
    private SWTGridDescription gridDescription;
    private AbstractSectionSWTRenderer rootRenderer;

    @Inject
    public SectionedAreaSWTRenderer(VSectionedArea vElement, ViewModelContext viewContext, ReportService reportService) {
        super((VElement)vElement, viewContext, reportService);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.gridDescription == null) {
            this.gridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.gridDescription;
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        SWTGridDescription gridDescription;
        VSection child = ((VSectionedArea)this.getVElement()).getRoot();
        if (!this.checkPreconditions(gridCell, parent, child)) {
            return null;
        }
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setData("org.eclipse.rap.rwt.customVariant", (Object)CUSTOM_VARIANT_VALUE);
        columnComposite.setBackground(parent.getBackground());
        SWTGridDescription maximalGridDescription = null;
        SWTGridDescription rowGridDescription = null;
        SWTGridDescription controlGridDescription = null;
        try {
            this.rootRenderer = (AbstractSectionSWTRenderer)((Object)AbstractSectionSWTRenderer.class.cast(((EMFFormsRendererFactory)this.getViewModelContext().getService(EMFFormsRendererFactory.class)).getRendererInstance((VElement)child, this.getViewModelContext())));
        }
        catch (EMFFormsNoRendererException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return columnComposite;
        }
        Collection additionalRenderers = ((EMFFormsRendererFactory)this.getViewModelContext().getService(EMFFormsRendererFactory.class)).getAdditionalRendererInstances((VElement)child, this.getViewModelContext());
        controlGridDescription = gridDescription = this.rootRenderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
        for (AbstractAdditionalSWTRenderer additionalRenderer : additionalRenderers) {
            gridDescription = additionalRenderer.getGridDescription(gridDescription);
        }
        rowGridDescription = gridDescription;
        maximalGridDescription = gridDescription;
        LinkedHashSet<AbstractSectionSWTRenderer> allRenderer = new LinkedHashSet<AbstractSectionSWTRenderer>();
        allRenderer.add(this.rootRenderer);
        allRenderer.addAll(additionalRenderers);
        if (maximalGridDescription == null) {
            return columnComposite;
        }
        columnComposite.setLayout(LayoutProviderHelper.getColumnLayout((int)maximalGridDescription.getColumns(), (boolean)false));
        try {
            SWTGridDescription gridDescription2 = rowGridDescription;
            if (gridDescription2 == null) {
                return columnComposite;
            }
            for (SWTGridCell childGridCell : gridDescription2.getGrid()) {
                Control control = ((AbstractSWTRenderer)childGridCell.getRenderer()).render(childGridCell, columnComposite);
                if (control == null) continue;
                this.setLayoutDataForControl(childGridCell, controlGridDescription, gridDescription2, maximalGridDescription, ((AbstractSWTRenderer)childGridCell.getRenderer()).getVElement(), control);
            }
            for (SWTGridCell childGridCell : gridDescription2.getGrid()) {
                ((AbstractSWTRenderer)childGridCell.getRenderer()).finalizeRendering(columnComposite);
            }
        }
        catch (NoPropertyDescriptorFoundExeption ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return columnComposite;
        }
        parent.layout(true);
        return columnComposite;
    }

    private boolean checkPreconditions(SWTGridCell gridCell, Composite parent, VSection root) {
        if (gridCell.getColumn() != 0) {
            this.getReportService().report(new AbstractReport(MessageFormat.format("Unexpected column in SectionedAreaSWTRenderer: {0}", gridCell.getColumn())));
            return false;
        }
        if (root == null) {
            this.getReportService().report(new AbstractReport("A SectionedArea requires a root section"));
            return false;
        }
        return true;
    }

    protected void setLayoutDataForControl(SWTGridCell gridCell, SWTGridDescription gridDescription, SWTGridDescription currentRowGridDescription, SWTGridDescription fullGridDescription, VElement vElement, Control control) {
        Object layoutData = LayoutProviderHelper.getLayoutData((SWTGridCell)gridCell, (SWTGridDescription)gridDescription, (SWTGridDescription)currentRowGridDescription, (SWTGridDescription)fullGridDescription, (VElement)vElement, (EObject)this.getViewModelContext().getDomainModel(), (Control)control);
        if (!GridData.class.isInstance(layoutData)) {
            return;
        }
        int lastColumnIndex = fullGridDescription.getColumns() - 1;
        if (gridCell.getColumn() == lastColumnIndex) {
            if (SectionLeafSWTRenderer.class.isInstance(gridCell.getRenderer())) {
                ((GridData)GridData.class.cast((Object)layoutData)).grabExcessHorizontalSpace = false;
                ((GridData)GridData.class.cast((Object)layoutData)).horizontalAlignment = 1;
            }
            ((GridData)GridData.class.cast((Object)layoutData)).widthHint = 250;
        }
        control.setLayoutData(layoutData);
    }

    public void finalizeRendering(Composite parent) {
        this.rootRenderer.initCollapseState();
        super.finalizeRendering(parent);
    }
}

